package io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class InfoItemSourceBuilder extends InfoItemSourceFluentImpl<InfoItemSourceBuilder> implements VisitableBuilder<InfoItemSource,InfoItemSourceBuilder>{
  public InfoItemSourceBuilder() {
    this(false);
  }
  public InfoItemSourceBuilder(Boolean validationEnabled) {
    this(new InfoItemSource(), validationEnabled);
  }
  public InfoItemSourceBuilder(InfoItemSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public InfoItemSourceBuilder(InfoItemSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new InfoItemSource(), validationEnabled);
  }
  public InfoItemSourceBuilder(InfoItemSourceFluent<?> fluent,InfoItemSource instance) {
    this(fluent, instance, false);
  }
  public InfoItemSourceBuilder(InfoItemSourceFluent<?> fluent,InfoItemSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConfigMapKeyRef(instance.getConfigMapKeyRef()); 
    fluent.withIngressRef(instance.getIngressRef()); 
    fluent.withSecretKeyRef(instance.getSecretKeyRef()); 
    fluent.withServiceRef(instance.getServiceRef()); 
    fluent.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  public InfoItemSourceBuilder(InfoItemSource instance) {
    this(instance,false);
  }
  public InfoItemSourceBuilder(InfoItemSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withConfigMapKeyRef(instance.getConfigMapKeyRef()); 
    this.withIngressRef(instance.getIngressRef()); 
    this.withSecretKeyRef(instance.getSecretKeyRef()); 
    this.withServiceRef(instance.getServiceRef()); 
    this.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  InfoItemSourceFluent<?> fluent;
  Boolean validationEnabled;
  public InfoItemSource build() {
    InfoItemSource buildable = new InfoItemSource(fluent.getConfigMapKeyRef(),fluent.getIngressRef(),fluent.getSecretKeyRef(),fluent.getServiceRef(),fluent.getType());
    return buildable;
  }
  
}