package io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DescriptorFluentImpl<A extends DescriptorFluent<A>> extends BaseFluent<A> implements DescriptorFluent<A>{
  public DescriptorFluentImpl() {
  }
  public DescriptorFluentImpl(Descriptor instance) {
    this.withDescription(instance.getDescription()); 
    this.withIcons(instance.getIcons()); 
    this.withKeywords(instance.getKeywords()); 
    this.withLinks(instance.getLinks()); 
    this.withMaintainers(instance.getMaintainers()); 
    this.withNotes(instance.getNotes()); 
    this.withOwners(instance.getOwners()); 
    this.withType(instance.getType()); 
    this.withVersion(instance.getVersion()); 
  }
  private String description;
  private ArrayList<ImageSpecBuilder> icons = new ArrayList<ImageSpecBuilder>();
  private List<String> keywords = new ArrayList<String>();
  private ArrayList<LinkBuilder> links = new ArrayList<LinkBuilder>();
  private ArrayList<ContactDataBuilder> maintainers = new ArrayList<ContactDataBuilder>();
  private String notes;
  private ArrayList<ContactDataBuilder> owners = new ArrayList<ContactDataBuilder>();
  private String type;
  private String version;
  public String getDescription() {
    return this.description;
  }
  public A withDescription(String description) {
    this.description=description; return (A) this;
  }
  public Boolean hasDescription() {
    return this.description != null;
  }
  public A addToIcons(Integer index,ImageSpec item) {
    if (this.icons == null) {this.icons = new ArrayList<ImageSpecBuilder>();}
    ImageSpecBuilder builder = new ImageSpecBuilder(item);_visitables.get("icons").add(index >= 0 ? index : _visitables.get("icons").size(), builder);this.icons.add(index >= 0 ? index : icons.size(), builder); return (A)this;
  }
  public A setToIcons(Integer index,ImageSpec item) {
    if (this.icons == null) {this.icons = new ArrayList<ImageSpecBuilder>();}
    ImageSpecBuilder builder = new ImageSpecBuilder(item);
    if (index < 0 || index >= _visitables.get("icons").size()) { _visitables.get("icons").add(builder); } else { _visitables.get("icons").set(index, builder);}
    if (index < 0 || index >= icons.size()) { icons.add(builder); } else { icons.set(index, builder);}
     return (A)this;
  }
  public A addToIcons(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ImageSpec... items) {
    if (this.icons == null) {this.icons = new ArrayList<ImageSpecBuilder>();}
    for (ImageSpec item : items) {ImageSpecBuilder builder = new ImageSpecBuilder(item);_visitables.get("icons").add(builder);this.icons.add(builder);} return (A)this;
  }
  public A addAllToIcons(Collection<ImageSpec> items) {
    if (this.icons == null) {this.icons = new ArrayList<ImageSpecBuilder>();}
    for (ImageSpec item : items) {ImageSpecBuilder builder = new ImageSpecBuilder(item);_visitables.get("icons").add(builder);this.icons.add(builder);} return (A)this;
  }
  public A removeFromIcons(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ImageSpec... items) {
    for (ImageSpec item : items) {ImageSpecBuilder builder = new ImageSpecBuilder(item);_visitables.get("icons").remove(builder);if (this.icons != null) {this.icons.remove(builder);}} return (A)this;
  }
  public A removeAllFromIcons(Collection<ImageSpec> items) {
    for (ImageSpec item : items) {ImageSpecBuilder builder = new ImageSpecBuilder(item);_visitables.get("icons").remove(builder);if (this.icons != null) {this.icons.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromIcons(Predicate<ImageSpecBuilder> predicate) {
    if (icons == null) return (A) this;
    final Iterator<ImageSpecBuilder> each = icons.iterator();
    final List visitables = _visitables.get("icons");
    while (each.hasNext()) {
      ImageSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildIcons instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ImageSpec> getIcons() {
    return icons != null ? build(icons) : null;
  }
  public List<ImageSpec> buildIcons() {
    return icons != null ? build(icons) : null;
  }
  public ImageSpec buildIcon(Integer index) {
    return this.icons.get(index).build();
  }
  public ImageSpec buildFirstIcon() {
    return this.icons.get(0).build();
  }
  public ImageSpec buildLastIcon() {
    return this.icons.get(icons.size() - 1).build();
  }
  public ImageSpec buildMatchingIcon(Predicate<ImageSpecBuilder> predicate) {
    for (ImageSpecBuilder item: icons) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingIcon(Predicate<ImageSpecBuilder> predicate) {
    for (ImageSpecBuilder item: icons) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withIcons(List<ImageSpec> icons) {
    if (this.icons != null) { _visitables.get("icons").removeAll(this.icons);}
    if (icons != null) {this.icons = new ArrayList(); for (ImageSpec item : icons){this.addToIcons(item);}} else { this.icons = null;} return (A) this;
  }
  public A withIcons(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ImageSpec... icons) {
    if (this.icons != null) {this.icons.clear();}
    if (icons != null) {for (ImageSpec item :icons){ this.addToIcons(item);}} return (A) this;
  }
  public Boolean hasIcons() {
    return icons != null && !icons.isEmpty();
  }
  public A addNewIcon(String size,String src,String type) {
    return (A)addToIcons(new ImageSpec(size, src, type));
  }
  public DescriptorFluent.IconsNested<A> addNewIcon() {
    return new DescriptorFluentImpl.IconsNestedImpl();
  }
  public DescriptorFluent.IconsNested<A> addNewIconLike(ImageSpec item) {
    return new DescriptorFluentImpl.IconsNestedImpl(-1, item);
  }
  public DescriptorFluent.IconsNested<A> setNewIconLike(Integer index,ImageSpec item) {
    return new DescriptorFluentImpl.IconsNestedImpl(index, item);
  }
  public DescriptorFluent.IconsNested<A> editIcon(Integer index) {
    if (icons.size() <= index) throw new RuntimeException("Can't edit icons. Index exceeds size.");
    return setNewIconLike(index, buildIcon(index));
  }
  public DescriptorFluent.IconsNested<A> editFirstIcon() {
    if (icons.size() == 0) throw new RuntimeException("Can't edit first icons. The list is empty.");
    return setNewIconLike(0, buildIcon(0));
  }
  public DescriptorFluent.IconsNested<A> editLastIcon() {
    int index = icons.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last icons. The list is empty.");
    return setNewIconLike(index, buildIcon(index));
  }
  public DescriptorFluent.IconsNested<A> editMatchingIcon(Predicate<ImageSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<icons.size();i++) { 
    if (predicate.test(icons.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching icons. No match found.");
    return setNewIconLike(index, buildIcon(index));
  }
  public A addToKeywords(Integer index,String item) {
    if (this.keywords == null) {this.keywords = new ArrayList<String>();}
    this.keywords.add(index, item);
    return (A)this;
  }
  public A setToKeywords(Integer index,String item) {
    if (this.keywords == null) {this.keywords = new ArrayList<String>();}
    this.keywords.set(index, item); return (A)this;
  }
  public A addToKeywords(java.lang.String... items) {
    if (this.keywords == null) {this.keywords = new ArrayList<String>();}
    for (String item : items) {this.keywords.add(item);} return (A)this;
  }
  public A addAllToKeywords(Collection<String> items) {
    if (this.keywords == null) {this.keywords = new ArrayList<String>();}
    for (String item : items) {this.keywords.add(item);} return (A)this;
  }
  public A removeFromKeywords(java.lang.String... items) {
    for (String item : items) {if (this.keywords!= null){ this.keywords.remove(item);}} return (A)this;
  }
  public A removeAllFromKeywords(Collection<String> items) {
    for (String item : items) {if (this.keywords!= null){ this.keywords.remove(item);}} return (A)this;
  }
  public List<String> getKeywords() {
    return this.keywords;
  }
  public String getKeyword(Integer index) {
    return this.keywords.get(index);
  }
  public String getFirstKeyword() {
    return this.keywords.get(0);
  }
  public String getLastKeyword() {
    return this.keywords.get(keywords.size() - 1);
  }
  public String getMatchingKeyword(Predicate<String> predicate) {
    for (String item: keywords) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingKeyword(Predicate<String> predicate) {
    for (String item: keywords) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withKeywords(List<String> keywords) {
    if (keywords != null) {this.keywords = new ArrayList(); for (String item : keywords){this.addToKeywords(item);}} else { this.keywords = null;} return (A) this;
  }
  public A withKeywords(java.lang.String... keywords) {
    if (this.keywords != null) {this.keywords.clear();}
    if (keywords != null) {for (String item :keywords){ this.addToKeywords(item);}} return (A) this;
  }
  public Boolean hasKeywords() {
    return keywords != null && !keywords.isEmpty();
  }
  public A addToLinks(Integer index,Link item) {
    if (this.links == null) {this.links = new ArrayList<LinkBuilder>();}
    LinkBuilder builder = new LinkBuilder(item);_visitables.get("links").add(index >= 0 ? index : _visitables.get("links").size(), builder);this.links.add(index >= 0 ? index : links.size(), builder); return (A)this;
  }
  public A setToLinks(Integer index,Link item) {
    if (this.links == null) {this.links = new ArrayList<LinkBuilder>();}
    LinkBuilder builder = new LinkBuilder(item);
    if (index < 0 || index >= _visitables.get("links").size()) { _visitables.get("links").add(builder); } else { _visitables.get("links").set(index, builder);}
    if (index < 0 || index >= links.size()) { links.add(builder); } else { links.set(index, builder);}
     return (A)this;
  }
  public A addToLinks(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.Link... items) {
    if (this.links == null) {this.links = new ArrayList<LinkBuilder>();}
    for (Link item : items) {LinkBuilder builder = new LinkBuilder(item);_visitables.get("links").add(builder);this.links.add(builder);} return (A)this;
  }
  public A addAllToLinks(Collection<Link> items) {
    if (this.links == null) {this.links = new ArrayList<LinkBuilder>();}
    for (Link item : items) {LinkBuilder builder = new LinkBuilder(item);_visitables.get("links").add(builder);this.links.add(builder);} return (A)this;
  }
  public A removeFromLinks(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.Link... items) {
    for (Link item : items) {LinkBuilder builder = new LinkBuilder(item);_visitables.get("links").remove(builder);if (this.links != null) {this.links.remove(builder);}} return (A)this;
  }
  public A removeAllFromLinks(Collection<Link> items) {
    for (Link item : items) {LinkBuilder builder = new LinkBuilder(item);_visitables.get("links").remove(builder);if (this.links != null) {this.links.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromLinks(Predicate<LinkBuilder> predicate) {
    if (links == null) return (A) this;
    final Iterator<LinkBuilder> each = links.iterator();
    final List visitables = _visitables.get("links");
    while (each.hasNext()) {
      LinkBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildLinks instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Link> getLinks() {
    return links != null ? build(links) : null;
  }
  public List<Link> buildLinks() {
    return links != null ? build(links) : null;
  }
  public Link buildLink(Integer index) {
    return this.links.get(index).build();
  }
  public Link buildFirstLink() {
    return this.links.get(0).build();
  }
  public Link buildLastLink() {
    return this.links.get(links.size() - 1).build();
  }
  public Link buildMatchingLink(Predicate<LinkBuilder> predicate) {
    for (LinkBuilder item: links) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingLink(Predicate<LinkBuilder> predicate) {
    for (LinkBuilder item: links) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withLinks(List<Link> links) {
    if (this.links != null) { _visitables.get("links").removeAll(this.links);}
    if (links != null) {this.links = new ArrayList(); for (Link item : links){this.addToLinks(item);}} else { this.links = null;} return (A) this;
  }
  public A withLinks(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.Link... links) {
    if (this.links != null) {this.links.clear();}
    if (links != null) {for (Link item :links){ this.addToLinks(item);}} return (A) this;
  }
  public Boolean hasLinks() {
    return links != null && !links.isEmpty();
  }
  public A addNewLink(String description,String url) {
    return (A)addToLinks(new Link(description, url));
  }
  public DescriptorFluent.LinksNested<A> addNewLink() {
    return new DescriptorFluentImpl.LinksNestedImpl();
  }
  public DescriptorFluent.LinksNested<A> addNewLinkLike(Link item) {
    return new DescriptorFluentImpl.LinksNestedImpl(-1, item);
  }
  public DescriptorFluent.LinksNested<A> setNewLinkLike(Integer index,Link item) {
    return new DescriptorFluentImpl.LinksNestedImpl(index, item);
  }
  public DescriptorFluent.LinksNested<A> editLink(Integer index) {
    if (links.size() <= index) throw new RuntimeException("Can't edit links. Index exceeds size.");
    return setNewLinkLike(index, buildLink(index));
  }
  public DescriptorFluent.LinksNested<A> editFirstLink() {
    if (links.size() == 0) throw new RuntimeException("Can't edit first links. The list is empty.");
    return setNewLinkLike(0, buildLink(0));
  }
  public DescriptorFluent.LinksNested<A> editLastLink() {
    int index = links.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last links. The list is empty.");
    return setNewLinkLike(index, buildLink(index));
  }
  public DescriptorFluent.LinksNested<A> editMatchingLink(Predicate<LinkBuilder> predicate) {
    int index = -1;
    for (int i=0;i<links.size();i++) { 
    if (predicate.test(links.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching links. No match found.");
    return setNewLinkLike(index, buildLink(index));
  }
  public A addToMaintainers(Integer index,ContactData item) {
    if (this.maintainers == null) {this.maintainers = new ArrayList<ContactDataBuilder>();}
    ContactDataBuilder builder = new ContactDataBuilder(item);_visitables.get("maintainers").add(index >= 0 ? index : _visitables.get("maintainers").size(), builder);this.maintainers.add(index >= 0 ? index : maintainers.size(), builder); return (A)this;
  }
  public A setToMaintainers(Integer index,ContactData item) {
    if (this.maintainers == null) {this.maintainers = new ArrayList<ContactDataBuilder>();}
    ContactDataBuilder builder = new ContactDataBuilder(item);
    if (index < 0 || index >= _visitables.get("maintainers").size()) { _visitables.get("maintainers").add(builder); } else { _visitables.get("maintainers").set(index, builder);}
    if (index < 0 || index >= maintainers.size()) { maintainers.add(builder); } else { maintainers.set(index, builder);}
     return (A)this;
  }
  public A addToMaintainers(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ContactData... items) {
    if (this.maintainers == null) {this.maintainers = new ArrayList<ContactDataBuilder>();}
    for (ContactData item : items) {ContactDataBuilder builder = new ContactDataBuilder(item);_visitables.get("maintainers").add(builder);this.maintainers.add(builder);} return (A)this;
  }
  public A addAllToMaintainers(Collection<ContactData> items) {
    if (this.maintainers == null) {this.maintainers = new ArrayList<ContactDataBuilder>();}
    for (ContactData item : items) {ContactDataBuilder builder = new ContactDataBuilder(item);_visitables.get("maintainers").add(builder);this.maintainers.add(builder);} return (A)this;
  }
  public A removeFromMaintainers(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ContactData... items) {
    for (ContactData item : items) {ContactDataBuilder builder = new ContactDataBuilder(item);_visitables.get("maintainers").remove(builder);if (this.maintainers != null) {this.maintainers.remove(builder);}} return (A)this;
  }
  public A removeAllFromMaintainers(Collection<ContactData> items) {
    for (ContactData item : items) {ContactDataBuilder builder = new ContactDataBuilder(item);_visitables.get("maintainers").remove(builder);if (this.maintainers != null) {this.maintainers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromMaintainers(Predicate<ContactDataBuilder> predicate) {
    if (maintainers == null) return (A) this;
    final Iterator<ContactDataBuilder> each = maintainers.iterator();
    final List visitables = _visitables.get("maintainers");
    while (each.hasNext()) {
      ContactDataBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildMaintainers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ContactData> getMaintainers() {
    return maintainers != null ? build(maintainers) : null;
  }
  public List<ContactData> buildMaintainers() {
    return maintainers != null ? build(maintainers) : null;
  }
  public ContactData buildMaintainer(Integer index) {
    return this.maintainers.get(index).build();
  }
  public ContactData buildFirstMaintainer() {
    return this.maintainers.get(0).build();
  }
  public ContactData buildLastMaintainer() {
    return this.maintainers.get(maintainers.size() - 1).build();
  }
  public ContactData buildMatchingMaintainer(Predicate<ContactDataBuilder> predicate) {
    for (ContactDataBuilder item: maintainers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingMaintainer(Predicate<ContactDataBuilder> predicate) {
    for (ContactDataBuilder item: maintainers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMaintainers(List<ContactData> maintainers) {
    if (this.maintainers != null) { _visitables.get("maintainers").removeAll(this.maintainers);}
    if (maintainers != null) {this.maintainers = new ArrayList(); for (ContactData item : maintainers){this.addToMaintainers(item);}} else { this.maintainers = null;} return (A) this;
  }
  public A withMaintainers(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ContactData... maintainers) {
    if (this.maintainers != null) {this.maintainers.clear();}
    if (maintainers != null) {for (ContactData item :maintainers){ this.addToMaintainers(item);}} return (A) this;
  }
  public Boolean hasMaintainers() {
    return maintainers != null && !maintainers.isEmpty();
  }
  public A addNewMaintainer(String email,String name,String url) {
    return (A)addToMaintainers(new ContactData(email, name, url));
  }
  public DescriptorFluent.MaintainersNested<A> addNewMaintainer() {
    return new DescriptorFluentImpl.MaintainersNestedImpl();
  }
  public DescriptorFluent.MaintainersNested<A> addNewMaintainerLike(ContactData item) {
    return new DescriptorFluentImpl.MaintainersNestedImpl(-1, item);
  }
  public DescriptorFluent.MaintainersNested<A> setNewMaintainerLike(Integer index,ContactData item) {
    return new DescriptorFluentImpl.MaintainersNestedImpl(index, item);
  }
  public DescriptorFluent.MaintainersNested<A> editMaintainer(Integer index) {
    if (maintainers.size() <= index) throw new RuntimeException("Can't edit maintainers. Index exceeds size.");
    return setNewMaintainerLike(index, buildMaintainer(index));
  }
  public DescriptorFluent.MaintainersNested<A> editFirstMaintainer() {
    if (maintainers.size() == 0) throw new RuntimeException("Can't edit first maintainers. The list is empty.");
    return setNewMaintainerLike(0, buildMaintainer(0));
  }
  public DescriptorFluent.MaintainersNested<A> editLastMaintainer() {
    int index = maintainers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last maintainers. The list is empty.");
    return setNewMaintainerLike(index, buildMaintainer(index));
  }
  public DescriptorFluent.MaintainersNested<A> editMatchingMaintainer(Predicate<ContactDataBuilder> predicate) {
    int index = -1;
    for (int i=0;i<maintainers.size();i++) { 
    if (predicate.test(maintainers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching maintainers. No match found.");
    return setNewMaintainerLike(index, buildMaintainer(index));
  }
  public String getNotes() {
    return this.notes;
  }
  public A withNotes(String notes) {
    this.notes=notes; return (A) this;
  }
  public Boolean hasNotes() {
    return this.notes != null;
  }
  public A addToOwners(Integer index,ContactData item) {
    if (this.owners == null) {this.owners = new ArrayList<ContactDataBuilder>();}
    ContactDataBuilder builder = new ContactDataBuilder(item);_visitables.get("owners").add(index >= 0 ? index : _visitables.get("owners").size(), builder);this.owners.add(index >= 0 ? index : owners.size(), builder); return (A)this;
  }
  public A setToOwners(Integer index,ContactData item) {
    if (this.owners == null) {this.owners = new ArrayList<ContactDataBuilder>();}
    ContactDataBuilder builder = new ContactDataBuilder(item);
    if (index < 0 || index >= _visitables.get("owners").size()) { _visitables.get("owners").add(builder); } else { _visitables.get("owners").set(index, builder);}
    if (index < 0 || index >= owners.size()) { owners.add(builder); } else { owners.set(index, builder);}
     return (A)this;
  }
  public A addToOwners(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ContactData... items) {
    if (this.owners == null) {this.owners = new ArrayList<ContactDataBuilder>();}
    for (ContactData item : items) {ContactDataBuilder builder = new ContactDataBuilder(item);_visitables.get("owners").add(builder);this.owners.add(builder);} return (A)this;
  }
  public A addAllToOwners(Collection<ContactData> items) {
    if (this.owners == null) {this.owners = new ArrayList<ContactDataBuilder>();}
    for (ContactData item : items) {ContactDataBuilder builder = new ContactDataBuilder(item);_visitables.get("owners").add(builder);this.owners.add(builder);} return (A)this;
  }
  public A removeFromOwners(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ContactData... items) {
    for (ContactData item : items) {ContactDataBuilder builder = new ContactDataBuilder(item);_visitables.get("owners").remove(builder);if (this.owners != null) {this.owners.remove(builder);}} return (A)this;
  }
  public A removeAllFromOwners(Collection<ContactData> items) {
    for (ContactData item : items) {ContactDataBuilder builder = new ContactDataBuilder(item);_visitables.get("owners").remove(builder);if (this.owners != null) {this.owners.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromOwners(Predicate<ContactDataBuilder> predicate) {
    if (owners == null) return (A) this;
    final Iterator<ContactDataBuilder> each = owners.iterator();
    final List visitables = _visitables.get("owners");
    while (each.hasNext()) {
      ContactDataBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildOwners instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ContactData> getOwners() {
    return owners != null ? build(owners) : null;
  }
  public List<ContactData> buildOwners() {
    return owners != null ? build(owners) : null;
  }
  public ContactData buildOwner(Integer index) {
    return this.owners.get(index).build();
  }
  public ContactData buildFirstOwner() {
    return this.owners.get(0).build();
  }
  public ContactData buildLastOwner() {
    return this.owners.get(owners.size() - 1).build();
  }
  public ContactData buildMatchingOwner(Predicate<ContactDataBuilder> predicate) {
    for (ContactDataBuilder item: owners) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingOwner(Predicate<ContactDataBuilder> predicate) {
    for (ContactDataBuilder item: owners) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withOwners(List<ContactData> owners) {
    if (this.owners != null) { _visitables.get("owners").removeAll(this.owners);}
    if (owners != null) {this.owners = new ArrayList(); for (ContactData item : owners){this.addToOwners(item);}} else { this.owners = null;} return (A) this;
  }
  public A withOwners(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ContactData... owners) {
    if (this.owners != null) {this.owners.clear();}
    if (owners != null) {for (ContactData item :owners){ this.addToOwners(item);}} return (A) this;
  }
  public Boolean hasOwners() {
    return owners != null && !owners.isEmpty();
  }
  public A addNewOwner(String email,String name,String url) {
    return (A)addToOwners(new ContactData(email, name, url));
  }
  public DescriptorFluent.OwnersNested<A> addNewOwner() {
    return new DescriptorFluentImpl.OwnersNestedImpl();
  }
  public DescriptorFluent.OwnersNested<A> addNewOwnerLike(ContactData item) {
    return new DescriptorFluentImpl.OwnersNestedImpl(-1, item);
  }
  public DescriptorFluent.OwnersNested<A> setNewOwnerLike(Integer index,ContactData item) {
    return new DescriptorFluentImpl.OwnersNestedImpl(index, item);
  }
  public DescriptorFluent.OwnersNested<A> editOwner(Integer index) {
    if (owners.size() <= index) throw new RuntimeException("Can't edit owners. Index exceeds size.");
    return setNewOwnerLike(index, buildOwner(index));
  }
  public DescriptorFluent.OwnersNested<A> editFirstOwner() {
    if (owners.size() == 0) throw new RuntimeException("Can't edit first owners. The list is empty.");
    return setNewOwnerLike(0, buildOwner(0));
  }
  public DescriptorFluent.OwnersNested<A> editLastOwner() {
    int index = owners.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last owners. The list is empty.");
    return setNewOwnerLike(index, buildOwner(index));
  }
  public DescriptorFluent.OwnersNested<A> editMatchingOwner(Predicate<ContactDataBuilder> predicate) {
    int index = -1;
    for (int i=0;i<owners.size();i++) { 
    if (predicate.test(owners.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching owners. No match found.");
    return setNewOwnerLike(index, buildOwner(index));
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public Boolean hasType() {
    return this.type != null;
  }
  public String getVersion() {
    return this.version;
  }
  public A withVersion(String version) {
    this.version=version; return (A) this;
  }
  public Boolean hasVersion() {
    return this.version != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DescriptorFluentImpl that = (DescriptorFluentImpl) o;
    if (description != null ? !description.equals(that.description) :that.description != null) return false;
    if (icons != null ? !icons.equals(that.icons) :that.icons != null) return false;
    if (keywords != null ? !keywords.equals(that.keywords) :that.keywords != null) return false;
    if (links != null ? !links.equals(that.links) :that.links != null) return false;
    if (maintainers != null ? !maintainers.equals(that.maintainers) :that.maintainers != null) return false;
    if (notes != null ? !notes.equals(that.notes) :that.notes != null) return false;
    if (owners != null ? !owners.equals(that.owners) :that.owners != null) return false;
    if (type != null ? !type.equals(that.type) :that.type != null) return false;
    if (version != null ? !version.equals(that.version) :that.version != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(description,  icons,  keywords,  links,  maintainers,  notes,  owners,  type,  version,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (description != null) { sb.append("description:"); sb.append(description + ","); }
    if (icons != null && !icons.isEmpty()) { sb.append("icons:"); sb.append(icons + ","); }
    if (keywords != null && !keywords.isEmpty()) { sb.append("keywords:"); sb.append(keywords + ","); }
    if (links != null && !links.isEmpty()) { sb.append("links:"); sb.append(links + ","); }
    if (maintainers != null && !maintainers.isEmpty()) { sb.append("maintainers:"); sb.append(maintainers + ","); }
    if (notes != null) { sb.append("notes:"); sb.append(notes + ","); }
    if (owners != null && !owners.isEmpty()) { sb.append("owners:"); sb.append(owners + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (version != null) { sb.append("version:"); sb.append(version); }
    sb.append("}");
    return sb.toString();
  }
  class IconsNestedImpl<N> extends ImageSpecFluentImpl<DescriptorFluent.IconsNested<N>> implements DescriptorFluent.IconsNested<N>,Nested<N>{
    IconsNestedImpl(Integer index,ImageSpec item) {
      this.index = index;
      this.builder = new ImageSpecBuilder(this, item);
    }
    IconsNestedImpl() {
      this.index = -1;
      this.builder = new ImageSpecBuilder(this);
    }
    ImageSpecBuilder builder;
    Integer index;
    public N and() {
      return (N) DescriptorFluentImpl.this.setToIcons(index,builder.build());
    }
    public N endIcon() {
      return and();
    }
    
  }
  class LinksNestedImpl<N> extends LinkFluentImpl<DescriptorFluent.LinksNested<N>> implements DescriptorFluent.LinksNested<N>,Nested<N>{
    LinksNestedImpl(Integer index,Link item) {
      this.index = index;
      this.builder = new LinkBuilder(this, item);
    }
    LinksNestedImpl() {
      this.index = -1;
      this.builder = new LinkBuilder(this);
    }
    LinkBuilder builder;
    Integer index;
    public N and() {
      return (N) DescriptorFluentImpl.this.setToLinks(index,builder.build());
    }
    public N endLink() {
      return and();
    }
    
  }
  class MaintainersNestedImpl<N> extends ContactDataFluentImpl<DescriptorFluent.MaintainersNested<N>> implements DescriptorFluent.MaintainersNested<N>,Nested<N>{
    MaintainersNestedImpl(Integer index,ContactData item) {
      this.index = index;
      this.builder = new ContactDataBuilder(this, item);
    }
    MaintainersNestedImpl() {
      this.index = -1;
      this.builder = new ContactDataBuilder(this);
    }
    ContactDataBuilder builder;
    Integer index;
    public N and() {
      return (N) DescriptorFluentImpl.this.setToMaintainers(index,builder.build());
    }
    public N endMaintainer() {
      return and();
    }
    
  }
  class OwnersNestedImpl<N> extends ContactDataFluentImpl<DescriptorFluent.OwnersNested<N>> implements DescriptorFluent.OwnersNested<N>,Nested<N>{
    OwnersNestedImpl(Integer index,ContactData item) {
      this.index = index;
      this.builder = new ContactDataBuilder(this, item);
    }
    OwnersNestedImpl() {
      this.index = -1;
      this.builder = new ContactDataBuilder(this);
    }
    ContactDataBuilder builder;
    Integer index;
    public N and() {
      return (N) DescriptorFluentImpl.this.setToOwners(index,builder.build());
    }
    public N endOwner() {
      return and();
    }
    
  }
  
}