package io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.GroupKind;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ApplicationSpecFluentImpl<A extends ApplicationSpecFluent<A>> extends BaseFluent<A> implements ApplicationSpecFluent<A>{
  public ApplicationSpecFluentImpl() {
  }
  public ApplicationSpecFluentImpl(ApplicationSpec instance) {
    this.withAddOwnerRef(instance.getAddOwnerRef()); 
    this.withAssemblyPhase(instance.getAssemblyPhase()); 
    this.withComponentKinds(instance.getComponentKinds()); 
    this.withDescriptor(instance.getDescriptor()); 
    this.withInfo(instance.getInfo()); 
    this.withSelector(instance.getSelector()); 
  }
  private Boolean addOwnerRef;
  private String assemblyPhase;
  private List<GroupKind> componentKinds = new ArrayList<GroupKind>();
  private DescriptorBuilder descriptor;
  private ArrayList<InfoItemBuilder> info = new ArrayList<InfoItemBuilder>();
  private LabelSelectorBuilder selector;
  public Boolean getAddOwnerRef() {
    return this.addOwnerRef;
  }
  public A withAddOwnerRef(Boolean addOwnerRef) {
    this.addOwnerRef=addOwnerRef; return (A) this;
  }
  public Boolean hasAddOwnerRef() {
    return this.addOwnerRef != null;
  }
  public String getAssemblyPhase() {
    return this.assemblyPhase;
  }
  public A withAssemblyPhase(String assemblyPhase) {
    this.assemblyPhase=assemblyPhase; return (A) this;
  }
  public Boolean hasAssemblyPhase() {
    return this.assemblyPhase != null;
  }
  public A addToComponentKinds(Integer index,GroupKind item) {
    if (this.componentKinds == null) {this.componentKinds = new ArrayList<GroupKind>();}
    this.componentKinds.add(index, item);
    return (A)this;
  }
  public A setToComponentKinds(Integer index,GroupKind item) {
    if (this.componentKinds == null) {this.componentKinds = new ArrayList<GroupKind>();}
    this.componentKinds.set(index, item); return (A)this;
  }
  public A addToComponentKinds(io.fabric8.kubernetes.api.model.GroupKind... items) {
    if (this.componentKinds == null) {this.componentKinds = new ArrayList<GroupKind>();}
    for (GroupKind item : items) {this.componentKinds.add(item);} return (A)this;
  }
  public A addAllToComponentKinds(Collection<GroupKind> items) {
    if (this.componentKinds == null) {this.componentKinds = new ArrayList<GroupKind>();}
    for (GroupKind item : items) {this.componentKinds.add(item);} return (A)this;
  }
  public A removeFromComponentKinds(io.fabric8.kubernetes.api.model.GroupKind... items) {
    for (GroupKind item : items) {if (this.componentKinds!= null){ this.componentKinds.remove(item);}} return (A)this;
  }
  public A removeAllFromComponentKinds(Collection<GroupKind> items) {
    for (GroupKind item : items) {if (this.componentKinds!= null){ this.componentKinds.remove(item);}} return (A)this;
  }
  public List<GroupKind> getComponentKinds() {
    return this.componentKinds;
  }
  public GroupKind getComponentKind(Integer index) {
    return this.componentKinds.get(index);
  }
  public GroupKind getFirstComponentKind() {
    return this.componentKinds.get(0);
  }
  public GroupKind getLastComponentKind() {
    return this.componentKinds.get(componentKinds.size() - 1);
  }
  public GroupKind getMatchingComponentKind(Predicate<GroupKind> predicate) {
    for (GroupKind item: componentKinds) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingComponentKind(Predicate<GroupKind> predicate) {
    for (GroupKind item: componentKinds) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withComponentKinds(List<GroupKind> componentKinds) {
    if (componentKinds != null) {this.componentKinds = new ArrayList(); for (GroupKind item : componentKinds){this.addToComponentKinds(item);}} else { this.componentKinds = null;} return (A) this;
  }
  public A withComponentKinds(io.fabric8.kubernetes.api.model.GroupKind... componentKinds) {
    if (this.componentKinds != null) {this.componentKinds.clear();}
    if (componentKinds != null) {for (GroupKind item :componentKinds){ this.addToComponentKinds(item);}} return (A) this;
  }
  public Boolean hasComponentKinds() {
    return componentKinds != null && !componentKinds.isEmpty();
  }
  public A addNewComponentKind(String group,String kind) {
    return (A)addToComponentKinds(new GroupKind(group, kind));
  }
  
  /**
   * This method has been deprecated, please use method buildDescriptor instead.
   * @return The buildable object.
   */
  @Deprecated
  public Descriptor getDescriptor() {
    return this.descriptor!=null ?this.descriptor.build():null;
  }
  public Descriptor buildDescriptor() {
    return this.descriptor!=null ?this.descriptor.build():null;
  }
  public A withDescriptor(Descriptor descriptor) {
    _visitables.get("descriptor").remove(this.descriptor);
    if (descriptor!=null){ this.descriptor= new DescriptorBuilder(descriptor); _visitables.get("descriptor").add(this.descriptor);} else { this.descriptor = null; _visitables.get("descriptor").remove(this.descriptor); } return (A) this;
  }
  public Boolean hasDescriptor() {
    return this.descriptor != null;
  }
  public ApplicationSpecFluent.DescriptorNested<A> withNewDescriptor() {
    return new ApplicationSpecFluentImpl.DescriptorNestedImpl();
  }
  public ApplicationSpecFluent.DescriptorNested<A> withNewDescriptorLike(Descriptor item) {
    return new ApplicationSpecFluentImpl.DescriptorNestedImpl(item);
  }
  public ApplicationSpecFluent.DescriptorNested<A> editDescriptor() {
    return withNewDescriptorLike(getDescriptor());
  }
  public ApplicationSpecFluent.DescriptorNested<A> editOrNewDescriptor() {
    return withNewDescriptorLike(getDescriptor() != null ? getDescriptor(): new DescriptorBuilder().build());
  }
  public ApplicationSpecFluent.DescriptorNested<A> editOrNewDescriptorLike(Descriptor item) {
    return withNewDescriptorLike(getDescriptor() != null ? getDescriptor(): item);
  }
  public A addToInfo(Integer index,InfoItem item) {
    if (this.info == null) {this.info = new ArrayList<InfoItemBuilder>();}
    InfoItemBuilder builder = new InfoItemBuilder(item);_visitables.get("info").add(index >= 0 ? index : _visitables.get("info").size(), builder);this.info.add(index >= 0 ? index : info.size(), builder); return (A)this;
  }
  public A setToInfo(Integer index,InfoItem item) {
    if (this.info == null) {this.info = new ArrayList<InfoItemBuilder>();}
    InfoItemBuilder builder = new InfoItemBuilder(item);
    if (index < 0 || index >= _visitables.get("info").size()) { _visitables.get("info").add(builder); } else { _visitables.get("info").set(index, builder);}
    if (index < 0 || index >= info.size()) { info.add(builder); } else { info.set(index, builder);}
     return (A)this;
  }
  public A addToInfo(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItem... items) {
    if (this.info == null) {this.info = new ArrayList<InfoItemBuilder>();}
    for (InfoItem item : items) {InfoItemBuilder builder = new InfoItemBuilder(item);_visitables.get("info").add(builder);this.info.add(builder);} return (A)this;
  }
  public A addAllToInfo(Collection<InfoItem> items) {
    if (this.info == null) {this.info = new ArrayList<InfoItemBuilder>();}
    for (InfoItem item : items) {InfoItemBuilder builder = new InfoItemBuilder(item);_visitables.get("info").add(builder);this.info.add(builder);} return (A)this;
  }
  public A removeFromInfo(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItem... items) {
    for (InfoItem item : items) {InfoItemBuilder builder = new InfoItemBuilder(item);_visitables.get("info").remove(builder);if (this.info != null) {this.info.remove(builder);}} return (A)this;
  }
  public A removeAllFromInfo(Collection<InfoItem> items) {
    for (InfoItem item : items) {InfoItemBuilder builder = new InfoItemBuilder(item);_visitables.get("info").remove(builder);if (this.info != null) {this.info.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromInfo(Predicate<InfoItemBuilder> predicate) {
    if (info == null) return (A) this;
    final Iterator<InfoItemBuilder> each = info.iterator();
    final List visitables = _visitables.get("info");
    while (each.hasNext()) {
      InfoItemBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildInfo instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<InfoItem> getInfo() {
    return info != null ? build(info) : null;
  }
  public List<InfoItem> buildInfo() {
    return info != null ? build(info) : null;
  }
  public InfoItem buildInfo(Integer index) {
    return this.info.get(index).build();
  }
  public InfoItem buildFirstInfo() {
    return this.info.get(0).build();
  }
  public InfoItem buildLastInfo() {
    return this.info.get(info.size() - 1).build();
  }
  public InfoItem buildMatchingInfo(Predicate<InfoItemBuilder> predicate) {
    for (InfoItemBuilder item: info) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingInfo(Predicate<InfoItemBuilder> predicate) {
    for (InfoItemBuilder item: info) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withInfo(List<InfoItem> info) {
    if (this.info != null) { _visitables.get("info").removeAll(this.info);}
    if (info != null) {this.info = new ArrayList(); for (InfoItem item : info){this.addToInfo(item);}} else { this.info = null;} return (A) this;
  }
  public A withInfo(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItem... info) {
    if (this.info != null) {this.info.clear();}
    if (info != null) {for (InfoItem item :info){ this.addToInfo(item);}} return (A) this;
  }
  public Boolean hasInfo() {
    return info != null && !info.isEmpty();
  }
  public ApplicationSpecFluent.InfoNested<A> addNewInfo() {
    return new ApplicationSpecFluentImpl.InfoNestedImpl();
  }
  public ApplicationSpecFluent.InfoNested<A> addNewInfoLike(InfoItem item) {
    return new ApplicationSpecFluentImpl.InfoNestedImpl(-1, item);
  }
  public ApplicationSpecFluent.InfoNested<A> setNewInfoLike(Integer index,InfoItem item) {
    return new ApplicationSpecFluentImpl.InfoNestedImpl(index, item);
  }
  public ApplicationSpecFluent.InfoNested<A> editInfo(Integer index) {
    if (info.size() <= index) throw new RuntimeException("Can't edit info. Index exceeds size.");
    return setNewInfoLike(index, buildInfo(index));
  }
  public ApplicationSpecFluent.InfoNested<A> editFirstInfo() {
    if (info.size() == 0) throw new RuntimeException("Can't edit first info. The list is empty.");
    return setNewInfoLike(0, buildInfo(0));
  }
  public ApplicationSpecFluent.InfoNested<A> editLastInfo() {
    int index = info.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last info. The list is empty.");
    return setNewInfoLike(index, buildInfo(index));
  }
  public ApplicationSpecFluent.InfoNested<A> editMatchingInfo(Predicate<InfoItemBuilder> predicate) {
    int index = -1;
    for (int i=0;i<info.size();i++) { 
    if (predicate.test(info.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching info. No match found.");
    return setNewInfoLike(index, buildInfo(index));
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public LabelSelector buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(LabelSelector selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  public ApplicationSpecFluent.SelectorNested<A> withNewSelector() {
    return new ApplicationSpecFluentImpl.SelectorNestedImpl();
  }
  public ApplicationSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
    return new ApplicationSpecFluentImpl.SelectorNestedImpl(item);
  }
  public ApplicationSpecFluent.SelectorNested<A> editSelector() {
    return withNewSelectorLike(getSelector());
  }
  public ApplicationSpecFluent.SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new LabelSelectorBuilder().build());
  }
  public ApplicationSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApplicationSpecFluentImpl that = (ApplicationSpecFluentImpl) o;
    if (addOwnerRef != null ? !addOwnerRef.equals(that.addOwnerRef) :that.addOwnerRef != null) return false;
    if (assemblyPhase != null ? !assemblyPhase.equals(that.assemblyPhase) :that.assemblyPhase != null) return false;
    if (componentKinds != null ? !componentKinds.equals(that.componentKinds) :that.componentKinds != null) return false;
    if (descriptor != null ? !descriptor.equals(that.descriptor) :that.descriptor != null) return false;
    if (info != null ? !info.equals(that.info) :that.info != null) return false;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(addOwnerRef,  assemblyPhase,  componentKinds,  descriptor,  info,  selector,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (addOwnerRef != null) { sb.append("addOwnerRef:"); sb.append(addOwnerRef + ","); }
    if (assemblyPhase != null) { sb.append("assemblyPhase:"); sb.append(assemblyPhase + ","); }
    if (componentKinds != null && !componentKinds.isEmpty()) { sb.append("componentKinds:"); sb.append(componentKinds + ","); }
    if (descriptor != null) { sb.append("descriptor:"); sb.append(descriptor + ","); }
    if (info != null && !info.isEmpty()) { sb.append("info:"); sb.append(info + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector); }
    sb.append("}");
    return sb.toString();
  }
  public A withAddOwnerRef() {
    return withAddOwnerRef(true);
  }
  class DescriptorNestedImpl<N> extends DescriptorFluentImpl<ApplicationSpecFluent.DescriptorNested<N>> implements ApplicationSpecFluent.DescriptorNested<N>,Nested<N>{
    DescriptorNestedImpl(Descriptor item) {
      this.builder = new DescriptorBuilder(this, item);
    }
    DescriptorNestedImpl() {
      this.builder = new DescriptorBuilder(this);
    }
    DescriptorBuilder builder;
    public N and() {
      return (N) ApplicationSpecFluentImpl.this.withDescriptor(builder.build());
    }
    public N endDescriptor() {
      return and();
    }
    
  }
  class InfoNestedImpl<N> extends InfoItemFluentImpl<ApplicationSpecFluent.InfoNested<N>> implements ApplicationSpecFluent.InfoNested<N>,Nested<N>{
    InfoNestedImpl(Integer index,InfoItem item) {
      this.index = index;
      this.builder = new InfoItemBuilder(this, item);
    }
    InfoNestedImpl() {
      this.index = -1;
      this.builder = new InfoItemBuilder(this);
    }
    InfoItemBuilder builder;
    Integer index;
    public N and() {
      return (N) ApplicationSpecFluentImpl.this.setToInfo(index,builder.build());
    }
    public N endInfo() {
      return and();
    }
    
  }
  class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<ApplicationSpecFluent.SelectorNested<N>> implements ApplicationSpecFluent.SelectorNested<N>,Nested<N>{
    SelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    SelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) ApplicationSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  
}