package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.helmrelease.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitBuilder extends GitFluentImpl<GitBuilder> implements VisitableBuilder<Git,GitBuilder>{
  public GitBuilder() {
    this(false);
  }
  public GitBuilder(Boolean validationEnabled) {
    this(new Git(), validationEnabled);
  }
  public GitBuilder(GitFluent<?> fluent) {
    this(fluent, false);
  }
  public GitBuilder(GitFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Git(), validationEnabled);
  }
  public GitBuilder(GitFluent<?> fluent,Git instance) {
    this(fluent, instance, false);
  }
  public GitBuilder(GitFluent<?> fluent,Git instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBranch(instance.getBranch()); 
    fluent.withChartPath(instance.getChartPath()); 
    fluent.withUrls(instance.getUrls()); 
    this.validationEnabled = validationEnabled; 
  }
  public GitBuilder(Git instance) {
    this(instance,false);
  }
  public GitBuilder(Git instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withBranch(instance.getBranch()); 
    this.withChartPath(instance.getChartPath()); 
    this.withUrls(instance.getUrls()); 
    this.validationEnabled = validationEnabled; 
  }
  GitFluent<?> fluent;
  Boolean validationEnabled;
  public Git build() {
    Git buildable = new Git(fluent.getBranch(),fluent.getChartPath(),fluent.getUrls());
    return buildable;
  }
  
}