package io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ApplicationListBuilder extends ApplicationListFluentImpl<ApplicationListBuilder> implements VisitableBuilder<ApplicationList,ApplicationListBuilder>{
  public ApplicationListBuilder() {
    this(false);
  }
  public ApplicationListBuilder(Boolean validationEnabled) {
    this(new ApplicationList(), validationEnabled);
  }
  public ApplicationListBuilder(ApplicationListFluent<?> fluent) {
    this(fluent, false);
  }
  public ApplicationListBuilder(ApplicationListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ApplicationList(), validationEnabled);
  }
  public ApplicationListBuilder(ApplicationListFluent<?> fluent,ApplicationList instance) {
    this(fluent, instance, false);
  }
  public ApplicationListBuilder(ApplicationListFluent<?> fluent,ApplicationList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public ApplicationListBuilder(ApplicationList instance) {
    this(instance,false);
  }
  public ApplicationListBuilder(ApplicationList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  ApplicationListFluent<?> fluent;
  Boolean validationEnabled;
  public ApplicationList build() {
    ApplicationList buildable = new ApplicationList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}