package io.fabric8.openclustermanagement.api.model.multicloudoperatorschannel.apps.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ChannelSpecBuilder extends ChannelSpecFluentImpl<ChannelSpecBuilder> implements VisitableBuilder<ChannelSpec,io.fabric8.openclustermanagement.api.model.multicloudoperatorschannel.apps.v1.ChannelSpecBuilder>{
  public ChannelSpecBuilder() {
    this(false);
  }
  public ChannelSpecBuilder(Boolean validationEnabled) {
    this(new ChannelSpec(), validationEnabled);
  }
  public ChannelSpecBuilder(ChannelSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ChannelSpecBuilder(io.fabric8.openclustermanagement.api.model.multicloudoperatorschannel.apps.v1.ChannelSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ChannelSpec(), validationEnabled);
  }
  public ChannelSpecBuilder(io.fabric8.openclustermanagement.api.model.multicloudoperatorschannel.apps.v1.ChannelSpecFluent<?> fluent,io.fabric8.openclustermanagement.api.model.multicloudoperatorschannel.apps.v1.ChannelSpec instance) {
    this(fluent, instance, false);
  }
  public ChannelSpecBuilder(io.fabric8.openclustermanagement.api.model.multicloudoperatorschannel.apps.v1.ChannelSpecFluent<?> fluent,io.fabric8.openclustermanagement.api.model.multicloudoperatorschannel.apps.v1.ChannelSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConfigMapRef(instance.getConfigMapRef()); 
    fluent.withGates(instance.getGates()); 
    fluent.withInsecureSkipVerify(instance.getInsecureSkipVerify()); 
    fluent.withPathname(instance.getPathname()); 
    fluent.withSecretRef(instance.getSecretRef()); 
    fluent.withSourceNamespaces(instance.getSourceNamespaces()); 
    fluent.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  public ChannelSpecBuilder(io.fabric8.openclustermanagement.api.model.multicloudoperatorschannel.apps.v1.ChannelSpec instance) {
    this(instance,false);
  }
  public ChannelSpecBuilder(io.fabric8.openclustermanagement.api.model.multicloudoperatorschannel.apps.v1.ChannelSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withConfigMapRef(instance.getConfigMapRef()); 
    this.withGates(instance.getGates()); 
    this.withInsecureSkipVerify(instance.getInsecureSkipVerify()); 
    this.withPathname(instance.getPathname()); 
    this.withSecretRef(instance.getSecretRef()); 
    this.withSourceNamespaces(instance.getSourceNamespaces()); 
    this.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openclustermanagement.api.model.multicloudoperatorschannel.apps.v1.ChannelSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openclustermanagement.api.model.multicloudoperatorschannel.apps.v1.ChannelSpec build() {
    ChannelSpec buildable = new ChannelSpec(fluent.getConfigMapRef(),fluent.getGates(),fluent.getInsecureSkipVerify(),fluent.getPathname(),fluent.getSecretRef(),fluent.getSourceNamespaces(),fluent.getType());
    return buildable;
  }
  
}