package io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DescriptorBuilder extends DescriptorFluentImpl<DescriptorBuilder> implements VisitableBuilder<Descriptor,io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.DescriptorBuilder>{
  public DescriptorBuilder() {
    this(false);
  }
  public DescriptorBuilder(Boolean validationEnabled) {
    this(new Descriptor(), validationEnabled);
  }
  public DescriptorBuilder(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.DescriptorFluent<?> fluent) {
    this(fluent, false);
  }
  public DescriptorBuilder(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.DescriptorFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Descriptor(), validationEnabled);
  }
  public DescriptorBuilder(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.DescriptorFluent<?> fluent,io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.Descriptor instance) {
    this(fluent, instance, false);
  }
  public DescriptorBuilder(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.DescriptorFluent<?> fluent,io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.Descriptor instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDescription(instance.getDescription()); 
    fluent.withIcons(instance.getIcons()); 
    fluent.withKeywords(instance.getKeywords()); 
    fluent.withLinks(instance.getLinks()); 
    fluent.withMaintainers(instance.getMaintainers()); 
    fluent.withNotes(instance.getNotes()); 
    fluent.withOwners(instance.getOwners()); 
    fluent.withType(instance.getType()); 
    fluent.withVersion(instance.getVersion()); 
    this.validationEnabled = validationEnabled; 
  }
  public DescriptorBuilder(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.Descriptor instance) {
    this(instance,false);
  }
  public DescriptorBuilder(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.Descriptor instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDescription(instance.getDescription()); 
    this.withIcons(instance.getIcons()); 
    this.withKeywords(instance.getKeywords()); 
    this.withLinks(instance.getLinks()); 
    this.withMaintainers(instance.getMaintainers()); 
    this.withNotes(instance.getNotes()); 
    this.withOwners(instance.getOwners()); 
    this.withType(instance.getType()); 
    this.withVersion(instance.getVersion()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.DescriptorFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.Descriptor build() {
    Descriptor buildable = new Descriptor(fluent.getDescription(),fluent.getIcons(),fluent.getKeywords(),fluent.getLinks(),fluent.getMaintainers(),fluent.getNotes(),fluent.getOwners(),fluent.getType(),fluent.getVersion());
    return buildable;
  }
  
}