package io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.GroupKind;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ApplicationSpecFluentImpl<A extends ApplicationSpecFluent<A>> extends BaseFluent<A> implements ApplicationSpecFluent<A>{
  public ApplicationSpecFluentImpl() {
  }
  public ApplicationSpecFluentImpl(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ApplicationSpec instance) {
    this.withAddOwnerRef(instance.getAddOwnerRef()); 
    this.withAssemblyPhase(instance.getAssemblyPhase()); 
    this.withComponentKinds(instance.getComponentKinds()); 
    this.withDescriptor(instance.getDescriptor()); 
    this.withInfo(instance.getInfo()); 
    this.withSelector(instance.getSelector()); 
  }
  private Boolean addOwnerRef;
  private String assemblyPhase;
  private List<GroupKind> componentKinds = new ArrayList<io.fabric8.kubernetes.api.model.GroupKind>();
  private DescriptorBuilder descriptor;
  private java.util.ArrayList<InfoItemBuilder> info = new java.util.ArrayList<InfoItemBuilder>();
  private LabelSelectorBuilder selector;
  public java.lang.Boolean getAddOwnerRef() {
    return this.addOwnerRef;
  }
  public A withAddOwnerRef(java.lang.Boolean addOwnerRef) {
    this.addOwnerRef=addOwnerRef; return (A) this;
  }
  public java.lang.Boolean hasAddOwnerRef() {
    return this.addOwnerRef != null;
  }
  public java.lang.String getAssemblyPhase() {
    return this.assemblyPhase;
  }
  public A withAssemblyPhase(java.lang.String assemblyPhase) {
    this.assemblyPhase=assemblyPhase; return (A) this;
  }
  public java.lang.Boolean hasAssemblyPhase() {
    return this.assemblyPhase != null;
  }
  public A addToComponentKinds(Integer index,io.fabric8.kubernetes.api.model.GroupKind item) {
    if (this.componentKinds == null) {this.componentKinds = new java.util.ArrayList<io.fabric8.kubernetes.api.model.GroupKind>();}
    this.componentKinds.add(index, item);
    return (A)this;
  }
  public A setToComponentKinds(java.lang.Integer index,io.fabric8.kubernetes.api.model.GroupKind item) {
    if (this.componentKinds == null) {this.componentKinds = new java.util.ArrayList<io.fabric8.kubernetes.api.model.GroupKind>();}
    this.componentKinds.set(index, item); return (A)this;
  }
  public A addToComponentKinds(io.fabric8.kubernetes.api.model.GroupKind... items) {
    if (this.componentKinds == null) {this.componentKinds = new java.util.ArrayList<io.fabric8.kubernetes.api.model.GroupKind>();}
    for (io.fabric8.kubernetes.api.model.GroupKind item : items) {this.componentKinds.add(item);} return (A)this;
  }
  public A addAllToComponentKinds(Collection<io.fabric8.kubernetes.api.model.GroupKind> items) {
    if (this.componentKinds == null) {this.componentKinds = new java.util.ArrayList<io.fabric8.kubernetes.api.model.GroupKind>();}
    for (io.fabric8.kubernetes.api.model.GroupKind item : items) {this.componentKinds.add(item);} return (A)this;
  }
  public A removeFromComponentKinds(io.fabric8.kubernetes.api.model.GroupKind... items) {
    for (io.fabric8.kubernetes.api.model.GroupKind item : items) {if (this.componentKinds!= null){ this.componentKinds.remove(item);}} return (A)this;
  }
  public A removeAllFromComponentKinds(java.util.Collection<io.fabric8.kubernetes.api.model.GroupKind> items) {
    for (io.fabric8.kubernetes.api.model.GroupKind item : items) {if (this.componentKinds!= null){ this.componentKinds.remove(item);}} return (A)this;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.GroupKind> getComponentKinds() {
    return this.componentKinds;
  }
  public io.fabric8.kubernetes.api.model.GroupKind getComponentKind(java.lang.Integer index) {
    return this.componentKinds.get(index);
  }
  public io.fabric8.kubernetes.api.model.GroupKind getFirstComponentKind() {
    return this.componentKinds.get(0);
  }
  public io.fabric8.kubernetes.api.model.GroupKind getLastComponentKind() {
    return this.componentKinds.get(componentKinds.size() - 1);
  }
  public io.fabric8.kubernetes.api.model.GroupKind getMatchingComponentKind(Predicate<io.fabric8.kubernetes.api.model.GroupKind> predicate) {
    for (io.fabric8.kubernetes.api.model.GroupKind item: componentKinds) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingComponentKind(java.util.function.Predicate<io.fabric8.kubernetes.api.model.GroupKind> predicate) {
    for (io.fabric8.kubernetes.api.model.GroupKind item: componentKinds) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withComponentKinds(java.util.List<io.fabric8.kubernetes.api.model.GroupKind> componentKinds) {
    if (componentKinds != null) {this.componentKinds = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.GroupKind item : componentKinds){this.addToComponentKinds(item);}} else { this.componentKinds = null;} return (A) this;
  }
  public A withComponentKinds(io.fabric8.kubernetes.api.model.GroupKind... componentKinds) {
    if (this.componentKinds != null) {this.componentKinds.clear();}
    if (componentKinds != null) {for (io.fabric8.kubernetes.api.model.GroupKind item :componentKinds){ this.addToComponentKinds(item);}} return (A) this;
  }
  public java.lang.Boolean hasComponentKinds() {
    return componentKinds != null && !componentKinds.isEmpty();
  }
  public A addNewComponentKind(java.lang.String group,java.lang.String kind) {
    return (A)addToComponentKinds(new GroupKind(group, kind));
  }
  
  /**
   * This method has been deprecated, please use method buildDescriptor instead.
   * @return The buildable object.
   */
  @Deprecated
  public Descriptor getDescriptor() {
    return this.descriptor!=null ?this.descriptor.build():null;
  }
  public io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.Descriptor buildDescriptor() {
    return this.descriptor!=null ?this.descriptor.build():null;
  }
  public A withDescriptor(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.Descriptor descriptor) {
    _visitables.get("descriptor").remove(this.descriptor);
    if (descriptor!=null){ this.descriptor= new io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.DescriptorBuilder(descriptor); _visitables.get("descriptor").add(this.descriptor);} return (A) this;
  }
  public java.lang.Boolean hasDescriptor() {
    return this.descriptor != null;
  }
  public ApplicationSpecFluent.DescriptorNested<A> withNewDescriptor() {
    return new ApplicationSpecFluentImpl.DescriptorNestedImpl();
  }
  public io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ApplicationSpecFluent.DescriptorNested<A> withNewDescriptorLike(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.Descriptor item) {
    return new ApplicationSpecFluentImpl.DescriptorNestedImpl(item);
  }
  public io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ApplicationSpecFluent.DescriptorNested<A> editDescriptor() {
    return withNewDescriptorLike(getDescriptor());
  }
  public io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ApplicationSpecFluent.DescriptorNested<A> editOrNewDescriptor() {
    return withNewDescriptorLike(getDescriptor() != null ? getDescriptor(): new io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.DescriptorBuilder().build());
  }
  public io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ApplicationSpecFluent.DescriptorNested<A> editOrNewDescriptorLike(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.Descriptor item) {
    return withNewDescriptorLike(getDescriptor() != null ? getDescriptor(): item);
  }
  public A addToInfo(java.lang.Integer index,io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItem item) {
    if (this.info == null) {this.info = new java.util.ArrayList<io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItemBuilder>();}
    io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItemBuilder builder = new io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItemBuilder(item);_visitables.get("info").add(index >= 0 ? index : _visitables.get("info").size(), builder);this.info.add(index >= 0 ? index : info.size(), builder); return (A)this;
  }
  public A setToInfo(java.lang.Integer index,io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItem item) {
    if (this.info == null) {this.info = new java.util.ArrayList<io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItemBuilder>();}
    io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItemBuilder builder = new io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItemBuilder(item);
    if (index < 0 || index >= _visitables.get("info").size()) { _visitables.get("info").add(builder); } else { _visitables.get("info").set(index, builder);}
    if (index < 0 || index >= info.size()) { info.add(builder); } else { info.set(index, builder);}
     return (A)this;
  }
  public A addToInfo(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItem... items) {
    if (this.info == null) {this.info = new java.util.ArrayList<io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItemBuilder>();}
    for (io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItem item : items) {io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItemBuilder builder = new io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItemBuilder(item);_visitables.get("info").add(builder);this.info.add(builder);} return (A)this;
  }
  public A addAllToInfo(java.util.Collection<io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItem> items) {
    if (this.info == null) {this.info = new java.util.ArrayList<io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItemBuilder>();}
    for (io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItem item : items) {io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItemBuilder builder = new io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItemBuilder(item);_visitables.get("info").add(builder);this.info.add(builder);} return (A)this;
  }
  public A removeFromInfo(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItem... items) {
    for (io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItem item : items) {io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItemBuilder builder = new io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItemBuilder(item);_visitables.get("info").remove(builder);if (this.info != null) {this.info.remove(builder);}} return (A)this;
  }
  public A removeAllFromInfo(java.util.Collection<io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItem> items) {
    for (io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItem item : items) {io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItemBuilder builder = new io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItemBuilder(item);_visitables.get("info").remove(builder);if (this.info != null) {this.info.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromInfo(java.util.function.Predicate<io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItemBuilder> predicate) {
    if (info == null) return (A) this;
    final Iterator<io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItemBuilder> each = info.iterator();
    final List visitables = _visitables.get("info");
    while (each.hasNext()) {
      io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItemBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildInfo instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItem> getInfo() {
    return info != null ? build(info) : null;
  }
  public java.util.List<io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItem> buildInfo() {
    return info != null ? build(info) : null;
  }
  public io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItem buildInfo(java.lang.Integer index) {
    return this.info.get(index).build();
  }
  public io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItem buildFirstInfo() {
    return this.info.get(0).build();
  }
  public io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItem buildLastInfo() {
    return this.info.get(info.size() - 1).build();
  }
  public io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItem buildMatchingInfo(java.util.function.Predicate<io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItemBuilder> predicate) {
    for (io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItemBuilder item: info) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingInfo(java.util.function.Predicate<io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItemBuilder> predicate) {
    for (io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItemBuilder item: info) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withInfo(java.util.List<io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItem> info) {
    if (this.info != null) { _visitables.get("info").removeAll(this.info);}
    if (info != null) {this.info = new java.util.ArrayList(); for (io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItem item : info){this.addToInfo(item);}} else { this.info = null;} return (A) this;
  }
  public A withInfo(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItem... info) {
    if (this.info != null) {this.info.clear();}
    if (info != null) {for (io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItem item :info){ this.addToInfo(item);}} return (A) this;
  }
  public java.lang.Boolean hasInfo() {
    return info != null && !info.isEmpty();
  }
  public ApplicationSpecFluent.InfoNested<A> addNewInfo() {
    return new ApplicationSpecFluentImpl.InfoNestedImpl();
  }
  public io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ApplicationSpecFluent.InfoNested<A> addNewInfoLike(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItem item) {
    return new io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ApplicationSpecFluentImpl.InfoNestedImpl(-1, item);
  }
  public io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ApplicationSpecFluent.InfoNested<A> setNewInfoLike(java.lang.Integer index,io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItem item) {
    return new io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ApplicationSpecFluentImpl.InfoNestedImpl(index, item);
  }
  public io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ApplicationSpecFluent.InfoNested<A> editInfo(java.lang.Integer index) {
    if (info.size() <= index) throw new RuntimeException("Can't edit info. Index exceeds size.");
    return setNewInfoLike(index, buildInfo(index));
  }
  public io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ApplicationSpecFluent.InfoNested<A> editFirstInfo() {
    if (info.size() == 0) throw new RuntimeException("Can't edit first info. The list is empty.");
    return setNewInfoLike(0, buildInfo(0));
  }
  public io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ApplicationSpecFluent.InfoNested<A> editLastInfo() {
    int index = info.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last info. The list is empty.");
    return setNewInfoLike(index, buildInfo(index));
  }
  public io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ApplicationSpecFluent.InfoNested<A> editMatchingInfo(java.util.function.Predicate<io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItemBuilder> predicate) {
    int index = -1;
    for (int i=0;i<info.size();i++) { 
    if (predicate.test(info.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching info. No match found.");
    return setNewInfoLike(index, buildInfo(index));
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public LabelSelector getSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public io.fabric8.kubernetes.api.model.LabelSelector buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(io.fabric8.kubernetes.api.model.LabelSelector selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
  }
  public java.lang.Boolean hasSelector() {
    return this.selector != null;
  }
  public ApplicationSpecFluent.SelectorNested<A> withNewSelector() {
    return new ApplicationSpecFluentImpl.SelectorNestedImpl();
  }
  public io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ApplicationSpecFluent.SelectorNested<A> withNewSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
    return new io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ApplicationSpecFluentImpl.SelectorNestedImpl(item);
  }
  public io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ApplicationSpecFluent.SelectorNested<A> editSelector() {
    return withNewSelectorLike(getSelector());
  }
  public io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ApplicationSpecFluent.SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new io.fabric8.kubernetes.api.model.LabelSelectorBuilder().build());
  }
  public io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ApplicationSpecFluent.SelectorNested<A> editOrNewSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApplicationSpecFluentImpl that = (ApplicationSpecFluentImpl) o;
    if (addOwnerRef != null ? !addOwnerRef.equals(that.addOwnerRef) :that.addOwnerRef != null) return false;
    if (assemblyPhase != null ? !assemblyPhase.equals(that.assemblyPhase) :that.assemblyPhase != null) return false;
    if (componentKinds != null ? !componentKinds.equals(that.componentKinds) :that.componentKinds != null) return false;
    if (descriptor != null ? !descriptor.equals(that.descriptor) :that.descriptor != null) return false;
    if (info != null ? !info.equals(that.info) :that.info != null) return false;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(addOwnerRef,  assemblyPhase,  componentKinds,  descriptor,  info,  selector,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (addOwnerRef != null) { sb.append("addOwnerRef:"); sb.append(addOwnerRef + ","); }
    if (assemblyPhase != null) { sb.append("assemblyPhase:"); sb.append(assemblyPhase + ","); }
    if (componentKinds != null && !componentKinds.isEmpty()) { sb.append("componentKinds:"); sb.append(componentKinds + ","); }
    if (descriptor != null) { sb.append("descriptor:"); sb.append(descriptor + ","); }
    if (info != null && !info.isEmpty()) { sb.append("info:"); sb.append(info + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector); }
    sb.append("}");
    return sb.toString();
  }
  public A withAddOwnerRef() {
    return withAddOwnerRef(true);
  }
  class DescriptorNestedImpl<N> extends DescriptorFluentImpl<ApplicationSpecFluent.DescriptorNested<N>> implements io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ApplicationSpecFluent.DescriptorNested<N>,Nested<N>{
    DescriptorNestedImpl(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.Descriptor item) {
      this.builder = new DescriptorBuilder(this, item);
    }
    DescriptorNestedImpl() {
      this.builder = new io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.DescriptorBuilder(this);
    }
    io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.DescriptorBuilder builder;
    public N and() {
      return (N) ApplicationSpecFluentImpl.this.withDescriptor(builder.build());
    }
    public N endDescriptor() {
      return and();
    }
    
  }
  class InfoNestedImpl<N> extends InfoItemFluentImpl<ApplicationSpecFluent.InfoNested<N>> implements io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ApplicationSpecFluent.InfoNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    InfoNestedImpl(java.lang.Integer index,io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItem item) {
      this.index = index;
      this.builder = new InfoItemBuilder(this, item);
    }
    InfoNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItemBuilder(this);
    }
    io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItemBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ApplicationSpecFluentImpl.this.setToInfo(index,builder.build());
    }
    public N endInfo() {
      return and();
    }
    
  }
  class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<ApplicationSpecFluent.SelectorNested<N>> implements io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ApplicationSpecFluent.SelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SelectorNestedImpl(io.fabric8.kubernetes.api.model.LabelSelector item) {
      this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this, item);
    }
    SelectorNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this);
    }
    io.fabric8.kubernetes.api.model.LabelSelectorBuilder builder;
    public N and() {
      return (N) ApplicationSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  
}