package io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ApplicationBuilder extends ApplicationFluentImpl<ApplicationBuilder> implements VisitableBuilder<Application,io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ApplicationBuilder>{
  public ApplicationBuilder() {
    this(false);
  }
  public ApplicationBuilder(Boolean validationEnabled) {
    this(new Application(), validationEnabled);
  }
  public ApplicationBuilder(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ApplicationFluent<?> fluent) {
    this(fluent, false);
  }
  public ApplicationBuilder(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ApplicationFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Application(), validationEnabled);
  }
  public ApplicationBuilder(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ApplicationFluent<?> fluent,io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.Application instance) {
    this(fluent, instance, false);
  }
  public ApplicationBuilder(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ApplicationFluent<?> fluent,io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.Application instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public ApplicationBuilder(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.Application instance) {
    this(instance,false);
  }
  public ApplicationBuilder(io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.Application instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ApplicationFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.Application build() {
    Application buildable = new Application(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}