/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.GroupKind;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ApplicationSpec;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.ApplicationSpecFluent;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.Descriptor;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.DescriptorBuilder;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.DescriptorFluentImpl;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItem;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItemBuilder;
import io.fabric8.openclustermanagement.api.model.app.k8s.v1beta1.InfoItemFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ApplicationSpecFluentImpl<A extends ApplicationSpecFluent<A>>
extends BaseFluent<A>
implements ApplicationSpecFluent<A> {
    private Boolean addOwnerRef;
    private String assemblyPhase;
    private List<GroupKind> componentKinds;
    private DescriptorBuilder descriptor;
    private List<InfoItemBuilder> info;
    private LabelSelectorBuilder selector;

    public ApplicationSpecFluentImpl() {
    }

    public ApplicationSpecFluentImpl(ApplicationSpec instance) {
        this.withAddOwnerRef(instance.getAddOwnerRef());
        this.withAssemblyPhase(instance.getAssemblyPhase());
        this.withComponentKinds(instance.getComponentKinds());
        this.withDescriptor(instance.getDescriptor());
        this.withInfo(instance.getInfo());
        this.withSelector(instance.getSelector());
    }

    @Override
    public Boolean getAddOwnerRef() {
        return this.addOwnerRef;
    }

    @Override
    public A withAddOwnerRef(Boolean addOwnerRef) {
        this.addOwnerRef = addOwnerRef;
        return (A)this;
    }

    @Override
    public Boolean hasAddOwnerRef() {
        return this.addOwnerRef != null;
    }

    @Override
    public String getAssemblyPhase() {
        return this.assemblyPhase;
    }

    @Override
    public A withAssemblyPhase(String assemblyPhase) {
        this.assemblyPhase = assemblyPhase;
        return (A)this;
    }

    @Override
    public Boolean hasAssemblyPhase() {
        return this.assemblyPhase != null;
    }

    @Override
    @Deprecated
    public A withNewAssemblyPhase(String arg0) {
        return this.withAssemblyPhase(new String(arg0));
    }

    @Override
    public A addToComponentKinds(Integer index, GroupKind item) {
        if (this.componentKinds == null) {
            this.componentKinds = new ArrayList<GroupKind>();
        }
        this.componentKinds.add(index, item);
        return (A)this;
    }

    @Override
    public A setToComponentKinds(Integer index, GroupKind item) {
        if (this.componentKinds == null) {
            this.componentKinds = new ArrayList<GroupKind>();
        }
        this.componentKinds.set(index, item);
        return (A)this;
    }

    @Override
    public A addToComponentKinds(GroupKind ... items) {
        if (this.componentKinds == null) {
            this.componentKinds = new ArrayList<GroupKind>();
        }
        for (GroupKind item : items) {
            this.componentKinds.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToComponentKinds(Collection<GroupKind> items) {
        if (this.componentKinds == null) {
            this.componentKinds = new ArrayList<GroupKind>();
        }
        for (GroupKind item : items) {
            this.componentKinds.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromComponentKinds(GroupKind ... items) {
        for (GroupKind item : items) {
            if (this.componentKinds == null) continue;
            this.componentKinds.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromComponentKinds(Collection<GroupKind> items) {
        for (GroupKind item : items) {
            if (this.componentKinds == null) continue;
            this.componentKinds.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<GroupKind> getComponentKinds() {
        return this.componentKinds;
    }

    @Override
    public GroupKind getComponentKind(Integer index) {
        return this.componentKinds.get(index);
    }

    @Override
    public GroupKind getFirstComponentKind() {
        return this.componentKinds.get(0);
    }

    @Override
    public GroupKind getLastComponentKind() {
        return this.componentKinds.get(this.componentKinds.size() - 1);
    }

    @Override
    public GroupKind getMatchingComponentKind(Predicate<GroupKind> predicate) {
        for (GroupKind item : this.componentKinds) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingComponentKind(Predicate<GroupKind> predicate) {
        for (GroupKind item : this.componentKinds) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withComponentKinds(List<GroupKind> componentKinds) {
        if (componentKinds != null) {
            this.componentKinds = new ArrayList<GroupKind>();
            for (GroupKind item : componentKinds) {
                this.addToComponentKinds(item);
            }
        } else {
            this.componentKinds = null;
        }
        return (A)this;
    }

    @Override
    public A withComponentKinds(GroupKind ... componentKinds) {
        if (this.componentKinds != null) {
            this.componentKinds.clear();
        }
        if (componentKinds != null) {
            for (GroupKind item : componentKinds) {
                this.addToComponentKinds(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasComponentKinds() {
        return this.componentKinds != null && !this.componentKinds.isEmpty();
    }

    @Override
    public A addNewComponentKind(String group, String kind) {
        return this.addToComponentKinds(new GroupKind(group, kind));
    }

    @Override
    @Deprecated
    public Descriptor getDescriptor() {
        return this.descriptor != null ? this.descriptor.build() : null;
    }

    @Override
    public Descriptor buildDescriptor() {
        return this.descriptor != null ? this.descriptor.build() : null;
    }

    @Override
    public A withDescriptor(Descriptor descriptor) {
        this._visitables.get((Object)"descriptor").remove(this.descriptor);
        if (descriptor != null) {
            this.descriptor = new DescriptorBuilder(descriptor);
            this._visitables.get((Object)"descriptor").add(this.descriptor);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDescriptor() {
        return this.descriptor != null;
    }

    @Override
    public ApplicationSpecFluent.DescriptorNested<A> withNewDescriptor() {
        return new DescriptorNestedImpl();
    }

    @Override
    public ApplicationSpecFluent.DescriptorNested<A> withNewDescriptorLike(Descriptor item) {
        return new DescriptorNestedImpl(item);
    }

    @Override
    public ApplicationSpecFluent.DescriptorNested<A> editDescriptor() {
        return this.withNewDescriptorLike(this.getDescriptor());
    }

    @Override
    public ApplicationSpecFluent.DescriptorNested<A> editOrNewDescriptor() {
        return this.withNewDescriptorLike(this.getDescriptor() != null ? this.getDescriptor() : new DescriptorBuilder().build());
    }

    @Override
    public ApplicationSpecFluent.DescriptorNested<A> editOrNewDescriptorLike(Descriptor item) {
        return this.withNewDescriptorLike(this.getDescriptor() != null ? this.getDescriptor() : item);
    }

    @Override
    public A addToInfo(Integer index, InfoItem item) {
        if (this.info == null) {
            this.info = new ArrayList<InfoItemBuilder>();
        }
        InfoItemBuilder builder = new InfoItemBuilder(item);
        this._visitables.get((Object)"info").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"info").size(), builder);
        this.info.add(index >= 0 ? index.intValue() : this.info.size(), builder);
        return (A)this;
    }

    @Override
    public A setToInfo(Integer index, InfoItem item) {
        if (this.info == null) {
            this.info = new ArrayList<InfoItemBuilder>();
        }
        InfoItemBuilder builder = new InfoItemBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"info").size()) {
            this._visitables.get((Object)"info").add(builder);
        } else {
            this._visitables.get((Object)"info").set(index, builder);
        }
        if (index < 0 || index >= this.info.size()) {
            this.info.add(builder);
        } else {
            this.info.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToInfo(InfoItem ... items) {
        if (this.info == null) {
            this.info = new ArrayList<InfoItemBuilder>();
        }
        for (InfoItem item : items) {
            InfoItemBuilder builder = new InfoItemBuilder(item);
            this._visitables.get((Object)"info").add(builder);
            this.info.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToInfo(Collection<InfoItem> items) {
        if (this.info == null) {
            this.info = new ArrayList<InfoItemBuilder>();
        }
        for (InfoItem item : items) {
            InfoItemBuilder builder = new InfoItemBuilder(item);
            this._visitables.get((Object)"info").add(builder);
            this.info.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromInfo(InfoItem ... items) {
        for (InfoItem item : items) {
            InfoItemBuilder builder = new InfoItemBuilder(item);
            this._visitables.get((Object)"info").remove(builder);
            if (this.info == null) continue;
            this.info.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromInfo(Collection<InfoItem> items) {
        for (InfoItem item : items) {
            InfoItemBuilder builder = new InfoItemBuilder(item);
            this._visitables.get((Object)"info").remove(builder);
            if (this.info == null) continue;
            this.info.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromInfo(Predicate<InfoItemBuilder> predicate) {
        if (this.info == null) {
            return (A)this;
        }
        Iterator<InfoItemBuilder> each = this.info.iterator();
        List visitables = this._visitables.get((Object)"info");
        while (each.hasNext()) {
            InfoItemBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<InfoItem> getInfo() {
        return ApplicationSpecFluentImpl.build(this.info);
    }

    @Override
    public List<InfoItem> buildInfo() {
        return ApplicationSpecFluentImpl.build(this.info);
    }

    @Override
    public InfoItem buildInfo(Integer index) {
        return this.info.get(index).build();
    }

    @Override
    public InfoItem buildFirstInfo() {
        return this.info.get(0).build();
    }

    @Override
    public InfoItem buildLastInfo() {
        return this.info.get(this.info.size() - 1).build();
    }

    @Override
    public InfoItem buildMatchingInfo(Predicate<InfoItemBuilder> predicate) {
        for (InfoItemBuilder item : this.info) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingInfo(Predicate<InfoItemBuilder> predicate) {
        for (InfoItemBuilder item : this.info) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withInfo(List<InfoItem> info) {
        if (this.info != null) {
            this._visitables.get((Object)"info").removeAll(this.info);
        }
        if (info != null) {
            this.info = new ArrayList<InfoItemBuilder>();
            for (InfoItem item : info) {
                this.addToInfo(item);
            }
        } else {
            this.info = null;
        }
        return (A)this;
    }

    @Override
    public A withInfo(InfoItem ... info) {
        if (this.info != null) {
            this.info.clear();
        }
        if (info != null) {
            for (InfoItem item : info) {
                this.addToInfo(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasInfo() {
        return this.info != null && !this.info.isEmpty();
    }

    @Override
    public ApplicationSpecFluent.InfoNested<A> addNewInfo() {
        return new InfoNestedImpl();
    }

    @Override
    public ApplicationSpecFluent.InfoNested<A> addNewInfoLike(InfoItem item) {
        return new InfoNestedImpl(-1, item);
    }

    @Override
    public ApplicationSpecFluent.InfoNested<A> setNewInfoLike(Integer index, InfoItem item) {
        return new InfoNestedImpl(index, item);
    }

    @Override
    public ApplicationSpecFluent.InfoNested<A> editInfo(Integer index) {
        if (this.info.size() <= index) {
            throw new RuntimeException("Can't edit info. Index exceeds size.");
        }
        return this.setNewInfoLike(index, this.buildInfo(index));
    }

    @Override
    public ApplicationSpecFluent.InfoNested<A> editFirstInfo() {
        if (this.info.size() == 0) {
            throw new RuntimeException("Can't edit first info. The list is empty.");
        }
        return this.setNewInfoLike(0, this.buildInfo(0));
    }

    @Override
    public ApplicationSpecFluent.InfoNested<A> editLastInfo() {
        int index = this.info.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last info. The list is empty.");
        }
        return this.setNewInfoLike(index, this.buildInfo(index));
    }

    @Override
    public ApplicationSpecFluent.InfoNested<A> editMatchingInfo(Predicate<InfoItemBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.info.size(); ++i) {
            if (!predicate.test(this.info.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching info. No match found.");
        }
        return this.setNewInfoLike(index, this.buildInfo(index));
    }

    @Override
    @Deprecated
    public LabelSelector getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(LabelSelector selector) {
        this._visitables.get((Object)"selector").remove(this.selector);
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get((Object)"selector").add(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public ApplicationSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public ApplicationSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public ApplicationSpecFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public ApplicationSpecFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public ApplicationSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationSpecFluentImpl that = (ApplicationSpecFluentImpl)o;
        if (this.addOwnerRef != null ? !this.addOwnerRef.equals(that.addOwnerRef) : that.addOwnerRef != null) {
            return false;
        }
        if (this.assemblyPhase != null ? !this.assemblyPhase.equals(that.assemblyPhase) : that.assemblyPhase != null) {
            return false;
        }
        if (this.componentKinds != null ? !this.componentKinds.equals(that.componentKinds) : that.componentKinds != null) {
            return false;
        }
        if (this.descriptor != null ? !this.descriptor.equals(that.descriptor) : that.descriptor != null) {
            return false;
        }
        if (this.info != null ? !this.info.equals(that.info) : that.info != null) {
            return false;
        }
        return !(this.selector != null ? !this.selector.equals((Object)that.selector) : that.selector != null);
    }

    public int hashCode() {
        return Objects.hash(this.addOwnerRef, this.assemblyPhase, this.componentKinds, this.descriptor, this.info, this.selector, super.hashCode());
    }

    public class SelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<ApplicationSpecFluent.SelectorNested<N>>
    implements ApplicationSpecFluent.SelectorNested<N>,
    Nested<N> {
        LabelSelectorBuilder builder;

        SelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        SelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this);
        }

        @Override
        public N and() {
            return (N)ApplicationSpecFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }

    public class InfoNestedImpl<N>
    extends InfoItemFluentImpl<ApplicationSpecFluent.InfoNested<N>>
    implements ApplicationSpecFluent.InfoNested<N>,
    Nested<N> {
        InfoItemBuilder builder;
        Integer index;

        InfoNestedImpl(Integer index, InfoItem item) {
            this.index = index;
            this.builder = new InfoItemBuilder(this, item);
        }

        InfoNestedImpl() {
            this.index = -1;
            this.builder = new InfoItemBuilder(this);
        }

        @Override
        public N and() {
            return (N)ApplicationSpecFluentImpl.this.setToInfo(this.index, this.builder.build());
        }

        @Override
        public N endInfo() {
            return this.and();
        }
    }

    public class DescriptorNestedImpl<N>
    extends DescriptorFluentImpl<ApplicationSpecFluent.DescriptorNested<N>>
    implements ApplicationSpecFluent.DescriptorNested<N>,
    Nested<N> {
        DescriptorBuilder builder;

        DescriptorNestedImpl(Descriptor item) {
            this.builder = new DescriptorBuilder(this, item);
        }

        DescriptorNestedImpl() {
            this.builder = new DescriptorBuilder(this);
        }

        @Override
        public N and() {
            return (N)ApplicationSpecFluentImpl.this.withDescriptor(this.builder.build());
        }

        @Override
        public N endDescriptor() {
            return this.and();
        }
    }
}

