package io.fabric8.openclustermanagement.api.model.agent.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KlusterletAddonConfigSpecFluent<A extends KlusterletAddonConfigSpecFluent<A>> extends BaseFluent<A>{
  public KlusterletAddonConfigSpecFluent() {
  }
  
  public KlusterletAddonConfigSpecFluent(KlusterletAddonConfigSpec instance) {
    this.copyInstance(instance);
  }
  private KlusterletAddonAgentConfigSpecBuilder applicationManager;
  private KlusterletAddonAgentConfigSpecBuilder certPolicyController;
  private Map<String,String> clusterLabels;
  private String clusterName;
  private String clusterNamespace;
  private KlusterletAddonAgentConfigSpecBuilder iamPolicyController;
  private KlusterletAddonAgentConfigSpecBuilder policyController;
  private ProxyConfigBuilder proxyConfig;
  private KlusterletAddonAgentConfigSpecBuilder searchCollector;
  private String version;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(KlusterletAddonConfigSpec instance) {
    instance = (instance != null ? instance : new KlusterletAddonConfigSpec());
    if (instance != null) {
          this.withApplicationManager(instance.getApplicationManager());
          this.withCertPolicyController(instance.getCertPolicyController());
          this.withClusterLabels(instance.getClusterLabels());
          this.withClusterName(instance.getClusterName());
          this.withClusterNamespace(instance.getClusterNamespace());
          this.withIamPolicyController(instance.getIamPolicyController());
          this.withPolicyController(instance.getPolicyController());
          this.withProxyConfig(instance.getProxyConfig());
          this.withSearchCollector(instance.getSearchCollector());
          this.withVersion(instance.getVersion());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public KlusterletAddonAgentConfigSpec buildApplicationManager() {
    return this.applicationManager != null ? this.applicationManager.build() : null;
  }
  
  public A withApplicationManager(KlusterletAddonAgentConfigSpec applicationManager) {
    this._visitables.remove("applicationManager");
    if (applicationManager != null) {
        this.applicationManager = new KlusterletAddonAgentConfigSpecBuilder(applicationManager);
        this._visitables.get("applicationManager").add(this.applicationManager);
    } else {
        this.applicationManager = null;
        this._visitables.get("applicationManager").remove(this.applicationManager);
    }
    return (A) this;
  }
  
  public boolean hasApplicationManager() {
    return this.applicationManager != null;
  }
  
  public A withNewApplicationManager(Boolean enabled,String proxyPolicy) {
    return (A)withApplicationManager(new KlusterletAddonAgentConfigSpec(enabled, proxyPolicy));
  }
  
  public ApplicationManagerNested<A> withNewApplicationManager() {
    return new ApplicationManagerNested(null);
  }
  
  public ApplicationManagerNested<A> withNewApplicationManagerLike(KlusterletAddonAgentConfigSpec item) {
    return new ApplicationManagerNested(item);
  }
  
  public ApplicationManagerNested<A> editApplicationManager() {
    return withNewApplicationManagerLike(java.util.Optional.ofNullable(buildApplicationManager()).orElse(null));
  }
  
  public ApplicationManagerNested<A> editOrNewApplicationManager() {
    return withNewApplicationManagerLike(java.util.Optional.ofNullable(buildApplicationManager()).orElse(new KlusterletAddonAgentConfigSpecBuilder().build()));
  }
  
  public ApplicationManagerNested<A> editOrNewApplicationManagerLike(KlusterletAddonAgentConfigSpec item) {
    return withNewApplicationManagerLike(java.util.Optional.ofNullable(buildApplicationManager()).orElse(item));
  }
  
  public KlusterletAddonAgentConfigSpec buildCertPolicyController() {
    return this.certPolicyController != null ? this.certPolicyController.build() : null;
  }
  
  public A withCertPolicyController(KlusterletAddonAgentConfigSpec certPolicyController) {
    this._visitables.remove("certPolicyController");
    if (certPolicyController != null) {
        this.certPolicyController = new KlusterletAddonAgentConfigSpecBuilder(certPolicyController);
        this._visitables.get("certPolicyController").add(this.certPolicyController);
    } else {
        this.certPolicyController = null;
        this._visitables.get("certPolicyController").remove(this.certPolicyController);
    }
    return (A) this;
  }
  
  public boolean hasCertPolicyController() {
    return this.certPolicyController != null;
  }
  
  public A withNewCertPolicyController(Boolean enabled,String proxyPolicy) {
    return (A)withCertPolicyController(new KlusterletAddonAgentConfigSpec(enabled, proxyPolicy));
  }
  
  public CertPolicyControllerNested<A> withNewCertPolicyController() {
    return new CertPolicyControllerNested(null);
  }
  
  public CertPolicyControllerNested<A> withNewCertPolicyControllerLike(KlusterletAddonAgentConfigSpec item) {
    return new CertPolicyControllerNested(item);
  }
  
  public CertPolicyControllerNested<A> editCertPolicyController() {
    return withNewCertPolicyControllerLike(java.util.Optional.ofNullable(buildCertPolicyController()).orElse(null));
  }
  
  public CertPolicyControllerNested<A> editOrNewCertPolicyController() {
    return withNewCertPolicyControllerLike(java.util.Optional.ofNullable(buildCertPolicyController()).orElse(new KlusterletAddonAgentConfigSpecBuilder().build()));
  }
  
  public CertPolicyControllerNested<A> editOrNewCertPolicyControllerLike(KlusterletAddonAgentConfigSpec item) {
    return withNewCertPolicyControllerLike(java.util.Optional.ofNullable(buildCertPolicyController()).orElse(item));
  }
  
  public A addToClusterLabels(String key,String value) {
    if(this.clusterLabels == null && key != null && value != null) { this.clusterLabels = new LinkedHashMap(); }
    if(key != null && value != null) {this.clusterLabels.put(key, value);} return (A)this;
  }
  
  public A addToClusterLabels(Map<String,String> map) {
    if(this.clusterLabels == null && map != null) { this.clusterLabels = new LinkedHashMap(); }
    if(map != null) { this.clusterLabels.putAll(map);} return (A)this;
  }
  
  public A removeFromClusterLabels(String key) {
    if(this.clusterLabels == null) { return (A) this; }
    if(key != null && this.clusterLabels != null) {this.clusterLabels.remove(key);} return (A)this;
  }
  
  public A removeFromClusterLabels(Map<String,String> map) {
    if(this.clusterLabels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.clusterLabels != null){this.clusterLabels.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getClusterLabels() {
    return this.clusterLabels;
  }
  
  public <K,V>A withClusterLabels(Map<String,String> clusterLabels) {
    if (clusterLabels == null) {
      this.clusterLabels = null;
    } else {
      this.clusterLabels = new LinkedHashMap(clusterLabels);
    }
    return (A) this;
  }
  
  public boolean hasClusterLabels() {
    return this.clusterLabels != null;
  }
  
  public String getClusterName() {
    return this.clusterName;
  }
  
  public A withClusterName(String clusterName) {
    this.clusterName = clusterName;
    return (A) this;
  }
  
  public boolean hasClusterName() {
    return this.clusterName != null;
  }
  
  public String getClusterNamespace() {
    return this.clusterNamespace;
  }
  
  public A withClusterNamespace(String clusterNamespace) {
    this.clusterNamespace = clusterNamespace;
    return (A) this;
  }
  
  public boolean hasClusterNamespace() {
    return this.clusterNamespace != null;
  }
  
  public KlusterletAddonAgentConfigSpec buildIamPolicyController() {
    return this.iamPolicyController != null ? this.iamPolicyController.build() : null;
  }
  
  public A withIamPolicyController(KlusterletAddonAgentConfigSpec iamPolicyController) {
    this._visitables.remove("iamPolicyController");
    if (iamPolicyController != null) {
        this.iamPolicyController = new KlusterletAddonAgentConfigSpecBuilder(iamPolicyController);
        this._visitables.get("iamPolicyController").add(this.iamPolicyController);
    } else {
        this.iamPolicyController = null;
        this._visitables.get("iamPolicyController").remove(this.iamPolicyController);
    }
    return (A) this;
  }
  
  public boolean hasIamPolicyController() {
    return this.iamPolicyController != null;
  }
  
  public A withNewIamPolicyController(Boolean enabled,String proxyPolicy) {
    return (A)withIamPolicyController(new KlusterletAddonAgentConfigSpec(enabled, proxyPolicy));
  }
  
  public IamPolicyControllerNested<A> withNewIamPolicyController() {
    return new IamPolicyControllerNested(null);
  }
  
  public IamPolicyControllerNested<A> withNewIamPolicyControllerLike(KlusterletAddonAgentConfigSpec item) {
    return new IamPolicyControllerNested(item);
  }
  
  public IamPolicyControllerNested<A> editIamPolicyController() {
    return withNewIamPolicyControllerLike(java.util.Optional.ofNullable(buildIamPolicyController()).orElse(null));
  }
  
  public IamPolicyControllerNested<A> editOrNewIamPolicyController() {
    return withNewIamPolicyControllerLike(java.util.Optional.ofNullable(buildIamPolicyController()).orElse(new KlusterletAddonAgentConfigSpecBuilder().build()));
  }
  
  public IamPolicyControllerNested<A> editOrNewIamPolicyControllerLike(KlusterletAddonAgentConfigSpec item) {
    return withNewIamPolicyControllerLike(java.util.Optional.ofNullable(buildIamPolicyController()).orElse(item));
  }
  
  public KlusterletAddonAgentConfigSpec buildPolicyController() {
    return this.policyController != null ? this.policyController.build() : null;
  }
  
  public A withPolicyController(KlusterletAddonAgentConfigSpec policyController) {
    this._visitables.remove("policyController");
    if (policyController != null) {
        this.policyController = new KlusterletAddonAgentConfigSpecBuilder(policyController);
        this._visitables.get("policyController").add(this.policyController);
    } else {
        this.policyController = null;
        this._visitables.get("policyController").remove(this.policyController);
    }
    return (A) this;
  }
  
  public boolean hasPolicyController() {
    return this.policyController != null;
  }
  
  public A withNewPolicyController(Boolean enabled,String proxyPolicy) {
    return (A)withPolicyController(new KlusterletAddonAgentConfigSpec(enabled, proxyPolicy));
  }
  
  public PolicyControllerNested<A> withNewPolicyController() {
    return new PolicyControllerNested(null);
  }
  
  public PolicyControllerNested<A> withNewPolicyControllerLike(KlusterletAddonAgentConfigSpec item) {
    return new PolicyControllerNested(item);
  }
  
  public PolicyControllerNested<A> editPolicyController() {
    return withNewPolicyControllerLike(java.util.Optional.ofNullable(buildPolicyController()).orElse(null));
  }
  
  public PolicyControllerNested<A> editOrNewPolicyController() {
    return withNewPolicyControllerLike(java.util.Optional.ofNullable(buildPolicyController()).orElse(new KlusterletAddonAgentConfigSpecBuilder().build()));
  }
  
  public PolicyControllerNested<A> editOrNewPolicyControllerLike(KlusterletAddonAgentConfigSpec item) {
    return withNewPolicyControllerLike(java.util.Optional.ofNullable(buildPolicyController()).orElse(item));
  }
  
  public ProxyConfig buildProxyConfig() {
    return this.proxyConfig != null ? this.proxyConfig.build() : null;
  }
  
  public A withProxyConfig(ProxyConfig proxyConfig) {
    this._visitables.remove("proxyConfig");
    if (proxyConfig != null) {
        this.proxyConfig = new ProxyConfigBuilder(proxyConfig);
        this._visitables.get("proxyConfig").add(this.proxyConfig);
    } else {
        this.proxyConfig = null;
        this._visitables.get("proxyConfig").remove(this.proxyConfig);
    }
    return (A) this;
  }
  
  public boolean hasProxyConfig() {
    return this.proxyConfig != null;
  }
  
  public A withNewProxyConfig(String httpProxy,String httpsProxy,String noProxy) {
    return (A)withProxyConfig(new ProxyConfig(httpProxy, httpsProxy, noProxy));
  }
  
  public ProxyConfigNested<A> withNewProxyConfig() {
    return new ProxyConfigNested(null);
  }
  
  public ProxyConfigNested<A> withNewProxyConfigLike(ProxyConfig item) {
    return new ProxyConfigNested(item);
  }
  
  public ProxyConfigNested<A> editProxyConfig() {
    return withNewProxyConfigLike(java.util.Optional.ofNullable(buildProxyConfig()).orElse(null));
  }
  
  public ProxyConfigNested<A> editOrNewProxyConfig() {
    return withNewProxyConfigLike(java.util.Optional.ofNullable(buildProxyConfig()).orElse(new ProxyConfigBuilder().build()));
  }
  
  public ProxyConfigNested<A> editOrNewProxyConfigLike(ProxyConfig item) {
    return withNewProxyConfigLike(java.util.Optional.ofNullable(buildProxyConfig()).orElse(item));
  }
  
  public KlusterletAddonAgentConfigSpec buildSearchCollector() {
    return this.searchCollector != null ? this.searchCollector.build() : null;
  }
  
  public A withSearchCollector(KlusterletAddonAgentConfigSpec searchCollector) {
    this._visitables.remove("searchCollector");
    if (searchCollector != null) {
        this.searchCollector = new KlusterletAddonAgentConfigSpecBuilder(searchCollector);
        this._visitables.get("searchCollector").add(this.searchCollector);
    } else {
        this.searchCollector = null;
        this._visitables.get("searchCollector").remove(this.searchCollector);
    }
    return (A) this;
  }
  
  public boolean hasSearchCollector() {
    return this.searchCollector != null;
  }
  
  public A withNewSearchCollector(Boolean enabled,String proxyPolicy) {
    return (A)withSearchCollector(new KlusterletAddonAgentConfigSpec(enabled, proxyPolicy));
  }
  
  public SearchCollectorNested<A> withNewSearchCollector() {
    return new SearchCollectorNested(null);
  }
  
  public SearchCollectorNested<A> withNewSearchCollectorLike(KlusterletAddonAgentConfigSpec item) {
    return new SearchCollectorNested(item);
  }
  
  public SearchCollectorNested<A> editSearchCollector() {
    return withNewSearchCollectorLike(java.util.Optional.ofNullable(buildSearchCollector()).orElse(null));
  }
  
  public SearchCollectorNested<A> editOrNewSearchCollector() {
    return withNewSearchCollectorLike(java.util.Optional.ofNullable(buildSearchCollector()).orElse(new KlusterletAddonAgentConfigSpecBuilder().build()));
  }
  
  public SearchCollectorNested<A> editOrNewSearchCollectorLike(KlusterletAddonAgentConfigSpec item) {
    return withNewSearchCollectorLike(java.util.Optional.ofNullable(buildSearchCollector()).orElse(item));
  }
  
  public String getVersion() {
    return this.version;
  }
  
  public A withVersion(String version) {
    this.version = version;
    return (A) this;
  }
  
  public boolean hasVersion() {
    return this.version != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KlusterletAddonConfigSpecFluent that = (KlusterletAddonConfigSpecFluent) o;
    if (!java.util.Objects.equals(applicationManager, that.applicationManager)) return false;
    if (!java.util.Objects.equals(certPolicyController, that.certPolicyController)) return false;
    if (!java.util.Objects.equals(clusterLabels, that.clusterLabels)) return false;
    if (!java.util.Objects.equals(clusterName, that.clusterName)) return false;
    if (!java.util.Objects.equals(clusterNamespace, that.clusterNamespace)) return false;
    if (!java.util.Objects.equals(iamPolicyController, that.iamPolicyController)) return false;
    if (!java.util.Objects.equals(policyController, that.policyController)) return false;
    if (!java.util.Objects.equals(proxyConfig, that.proxyConfig)) return false;
    if (!java.util.Objects.equals(searchCollector, that.searchCollector)) return false;
    if (!java.util.Objects.equals(version, that.version)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(applicationManager,  certPolicyController,  clusterLabels,  clusterName,  clusterNamespace,  iamPolicyController,  policyController,  proxyConfig,  searchCollector,  version,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (applicationManager != null) { sb.append("applicationManager:"); sb.append(applicationManager + ","); }
    if (certPolicyController != null) { sb.append("certPolicyController:"); sb.append(certPolicyController + ","); }
    if (clusterLabels != null && !clusterLabels.isEmpty()) { sb.append("clusterLabels:"); sb.append(clusterLabels + ","); }
    if (clusterName != null) { sb.append("clusterName:"); sb.append(clusterName + ","); }
    if (clusterNamespace != null) { sb.append("clusterNamespace:"); sb.append(clusterNamespace + ","); }
    if (iamPolicyController != null) { sb.append("iamPolicyController:"); sb.append(iamPolicyController + ","); }
    if (policyController != null) { sb.append("policyController:"); sb.append(policyController + ","); }
    if (proxyConfig != null) { sb.append("proxyConfig:"); sb.append(proxyConfig + ","); }
    if (searchCollector != null) { sb.append("searchCollector:"); sb.append(searchCollector + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ApplicationManagerNested<N> extends KlusterletAddonAgentConfigSpecFluent<ApplicationManagerNested<N>> implements Nested<N>{
    ApplicationManagerNested(KlusterletAddonAgentConfigSpec item) {
      this.builder = new KlusterletAddonAgentConfigSpecBuilder(this, item);
    }
    KlusterletAddonAgentConfigSpecBuilder builder;
    
    public N and() {
      return (N) KlusterletAddonConfigSpecFluent.this.withApplicationManager(builder.build());
    }
    
    public N endApplicationManager() {
      return and();
    }
    
  
  }
  public class CertPolicyControllerNested<N> extends KlusterletAddonAgentConfigSpecFluent<CertPolicyControllerNested<N>> implements Nested<N>{
    CertPolicyControllerNested(KlusterletAddonAgentConfigSpec item) {
      this.builder = new KlusterletAddonAgentConfigSpecBuilder(this, item);
    }
    KlusterletAddonAgentConfigSpecBuilder builder;
    
    public N and() {
      return (N) KlusterletAddonConfigSpecFluent.this.withCertPolicyController(builder.build());
    }
    
    public N endCertPolicyController() {
      return and();
    }
    
  
  }
  public class IamPolicyControllerNested<N> extends KlusterletAddonAgentConfigSpecFluent<IamPolicyControllerNested<N>> implements Nested<N>{
    IamPolicyControllerNested(KlusterletAddonAgentConfigSpec item) {
      this.builder = new KlusterletAddonAgentConfigSpecBuilder(this, item);
    }
    KlusterletAddonAgentConfigSpecBuilder builder;
    
    public N and() {
      return (N) KlusterletAddonConfigSpecFluent.this.withIamPolicyController(builder.build());
    }
    
    public N endIamPolicyController() {
      return and();
    }
    
  
  }
  public class PolicyControllerNested<N> extends KlusterletAddonAgentConfigSpecFluent<PolicyControllerNested<N>> implements Nested<N>{
    PolicyControllerNested(KlusterletAddonAgentConfigSpec item) {
      this.builder = new KlusterletAddonAgentConfigSpecBuilder(this, item);
    }
    KlusterletAddonAgentConfigSpecBuilder builder;
    
    public N and() {
      return (N) KlusterletAddonConfigSpecFluent.this.withPolicyController(builder.build());
    }
    
    public N endPolicyController() {
      return and();
    }
    
  
  }
  public class ProxyConfigNested<N> extends ProxyConfigFluent<ProxyConfigNested<N>> implements Nested<N>{
    ProxyConfigNested(ProxyConfig item) {
      this.builder = new ProxyConfigBuilder(this, item);
    }
    ProxyConfigBuilder builder;
    
    public N and() {
      return (N) KlusterletAddonConfigSpecFluent.this.withProxyConfig(builder.build());
    }
    
    public N endProxyConfig() {
      return and();
    }
    
  
  }
  public class SearchCollectorNested<N> extends KlusterletAddonAgentConfigSpecFluent<SearchCollectorNested<N>> implements Nested<N>{
    SearchCollectorNested(KlusterletAddonAgentConfigSpec item) {
      this.builder = new KlusterletAddonAgentConfigSpecBuilder(this, item);
    }
    KlusterletAddonAgentConfigSpecBuilder builder;
    
    public N and() {
      return (N) KlusterletAddonConfigSpecFluent.this.withSearchCollector(builder.build());
    }
    
    public N endSearchCollector() {
      return and();
    }
    
  
  }

}