package io.fabric8.openclustermanagement.api.model.agent.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProxyConfigBuilder extends ProxyConfigFluent<ProxyConfigBuilder> implements VisitableBuilder<ProxyConfig,ProxyConfigBuilder>{
  public ProxyConfigBuilder() {
    this(false);
  }
  public ProxyConfigBuilder(Boolean validationEnabled) {
    this(new ProxyConfig(), validationEnabled);
  }
  public ProxyConfigBuilder(ProxyConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ProxyConfigBuilder(ProxyConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ProxyConfig(), validationEnabled);
  }
  public ProxyConfigBuilder(ProxyConfigFluent<?> fluent,ProxyConfig instance) {
    this(fluent, instance, false);
  }
  public ProxyConfigBuilder(ProxyConfigFluent<?> fluent,ProxyConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ProxyConfig());

    if (instance != null) {
      fluent.withHttpProxy(instance.getHttpProxy());
      fluent.withHttpsProxy(instance.getHttpsProxy());
      fluent.withNoProxy(instance.getNoProxy());
      fluent.withHttpProxy(instance.getHttpProxy());
      fluent.withHttpsProxy(instance.getHttpsProxy());
      fluent.withNoProxy(instance.getNoProxy());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ProxyConfigBuilder(ProxyConfig instance) {
    this(instance,false);
  }
  public ProxyConfigBuilder(ProxyConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ProxyConfig());

    if (instance != null) {
      this.withHttpProxy(instance.getHttpProxy());
      this.withHttpsProxy(instance.getHttpsProxy());
      this.withNoProxy(instance.getNoProxy());
      this.withHttpProxy(instance.getHttpProxy());
      this.withHttpsProxy(instance.getHttpsProxy());
      this.withNoProxy(instance.getNoProxy());
    }
    this.validationEnabled = validationEnabled; 
  }
  ProxyConfigFluent<?> fluent;
  Boolean validationEnabled;
  public ProxyConfig build() {
    ProxyConfig buildable = new ProxyConfig(fluent.getHttpProxy(),fluent.getHttpsProxy(),fluent.getNoProxy());
    return buildable;
  }
  
}