package io.fabric8.openclustermanagement.api.model.agent.v1;

import io.fabric8.kubernetes.api.model.Condition;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KlusterletAddonConfigStatusFluent<A extends KlusterletAddonConfigStatusFluent<A>> extends BaseFluent<A>{
  public KlusterletAddonConfigStatusFluent() {
  }
  public KlusterletAddonConfigStatusFluent(KlusterletAddonConfigStatus instance) {
    instance = (instance != null ? instance : new KlusterletAddonConfigStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withOcpGlobalProxy(instance.getOcpGlobalProxy());
      this.withConditions(instance.getConditions());
      this.withOcpGlobalProxy(instance.getOcpGlobalProxy());
    }
  }
  private List<Condition> conditions = new ArrayList<Condition>();
  private ProxyConfigBuilder ocpGlobalProxy;
  public A addToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  public A setToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.set(index, item); return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  public A removeAllFromConditions(Collection<Condition> items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  public List<Condition> getConditions() {
    return this.conditions;
  }
  public Condition getCondition(int index) {
    return this.conditions.get(index);
  }
  public Condition getFirstCondition() {
    return this.conditions.get(0);
  }
  public Condition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  public Condition getMatchingCondition(Predicate<Condition> predicate) {
    for (Condition item: conditions) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingCondition(Predicate<Condition> predicate) {
    for (Condition item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<Condition> conditions) {
    if (conditions != null) {this.conditions = new ArrayList(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public ProxyConfig buildOcpGlobalProxy() {
    return this.ocpGlobalProxy!=null ?this.ocpGlobalProxy.build():null;
  }
  public A withOcpGlobalProxy(ProxyConfig ocpGlobalProxy) {
    _visitables.get("ocpGlobalProxy").remove(this.ocpGlobalProxy);
    if (ocpGlobalProxy!=null){ this.ocpGlobalProxy= new ProxyConfigBuilder(ocpGlobalProxy); _visitables.get("ocpGlobalProxy").add(this.ocpGlobalProxy);} else { this.ocpGlobalProxy = null; _visitables.get("ocpGlobalProxy").remove(this.ocpGlobalProxy); } return (A) this;
  }
  public boolean hasOcpGlobalProxy() {
    return this.ocpGlobalProxy != null;
  }
  public A withNewOcpGlobalProxy(String httpProxy,String httpsProxy,String noProxy) {
    return (A)withOcpGlobalProxy(new ProxyConfig(httpProxy, httpsProxy, noProxy));
  }
  public OcpGlobalProxyNested<A> withNewOcpGlobalProxy() {
    return new OcpGlobalProxyNested(null);
  }
  public OcpGlobalProxyNested<A> withNewOcpGlobalProxyLike(ProxyConfig item) {
    return new OcpGlobalProxyNested(item);
  }
  public OcpGlobalProxyNested<A> editOcpGlobalProxy() {
    return withNewOcpGlobalProxyLike(java.util.Optional.ofNullable(buildOcpGlobalProxy()).orElse(null));
  }
  public OcpGlobalProxyNested<A> editOrNewOcpGlobalProxy() {
    return withNewOcpGlobalProxyLike(java.util.Optional.ofNullable(buildOcpGlobalProxy()).orElse(new ProxyConfigBuilder().build()));
  }
  public OcpGlobalProxyNested<A> editOrNewOcpGlobalProxyLike(ProxyConfig item) {
    return withNewOcpGlobalProxyLike(java.util.Optional.ofNullable(buildOcpGlobalProxy()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KlusterletAddonConfigStatusFluent that = (KlusterletAddonConfigStatusFluent) o;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(ocpGlobalProxy, that.ocpGlobalProxy)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  ocpGlobalProxy,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (ocpGlobalProxy != null) { sb.append("ocpGlobalProxy:"); sb.append(ocpGlobalProxy); }
    sb.append("}");
    return sb.toString();
  }
  public class OcpGlobalProxyNested<N> extends ProxyConfigFluent<OcpGlobalProxyNested<N>> implements Nested<N>{
    OcpGlobalProxyNested(ProxyConfig item) {
      this.builder = new ProxyConfigBuilder(this, item);
    }
    ProxyConfigBuilder builder;
    public N and() {
      return (N) KlusterletAddonConfigStatusFluent.this.withOcpGlobalProxy(builder.build());
    }
    public N endOcpGlobalProxy() {
      return and();
    }
    
  }
  
}