package io.fabric8.openclustermanagement.api.model.agent.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KlusterletAddonConfigSpecFluentImpl<A extends KlusterletAddonConfigSpecFluent<A>> extends BaseFluent<A> implements KlusterletAddonConfigSpecFluent<A>{
  public KlusterletAddonConfigSpecFluentImpl() {
  }
  public KlusterletAddonConfigSpecFluentImpl(KlusterletAddonConfigSpec instance) {
    if (instance != null) {
      this.withApplicationManager(instance.getApplicationManager());
      this.withCertPolicyController(instance.getCertPolicyController());
      this.withClusterLabels(instance.getClusterLabels());
      this.withClusterName(instance.getClusterName());
      this.withClusterNamespace(instance.getClusterNamespace());
      this.withIamPolicyController(instance.getIamPolicyController());
      this.withPolicyController(instance.getPolicyController());
      this.withProxyConfig(instance.getProxyConfig());
      this.withSearchCollector(instance.getSearchCollector());
      this.withVersion(instance.getVersion());
    }
  }
  private KlusterletAddonAgentConfigSpecBuilder applicationManager;
  private KlusterletAddonAgentConfigSpecBuilder certPolicyController;
  private Map<String,String> clusterLabels;
  private String clusterName;
  private String clusterNamespace;
  private KlusterletAddonAgentConfigSpecBuilder iamPolicyController;
  private KlusterletAddonAgentConfigSpecBuilder policyController;
  private ProxyConfigBuilder proxyConfig;
  private KlusterletAddonAgentConfigSpecBuilder searchCollector;
  private String version;
  
  /**
   * This method has been deprecated, please use method buildApplicationManager instead.
   * @return The buildable object.
   */
  @Deprecated
  public KlusterletAddonAgentConfigSpec getApplicationManager() {
    return this.applicationManager!=null ?this.applicationManager.build():null;
  }
  public KlusterletAddonAgentConfigSpec buildApplicationManager() {
    return this.applicationManager!=null ?this.applicationManager.build():null;
  }
  public A withApplicationManager(KlusterletAddonAgentConfigSpec applicationManager) {
    _visitables.get("applicationManager").remove(this.applicationManager);
    if (applicationManager!=null){ this.applicationManager= new KlusterletAddonAgentConfigSpecBuilder(applicationManager); _visitables.get("applicationManager").add(this.applicationManager);} else { this.applicationManager = null; _visitables.get("applicationManager").remove(this.applicationManager); } return (A) this;
  }
  public Boolean hasApplicationManager() {
    return this.applicationManager != null;
  }
  public A withNewApplicationManager(Boolean enabled,String proxyPolicy) {
    return (A)withApplicationManager(new KlusterletAddonAgentConfigSpec(enabled, proxyPolicy));
  }
  public KlusterletAddonConfigSpecFluentImpl.ApplicationManagerNested<A> withNewApplicationManager() {
    return new KlusterletAddonConfigSpecFluentImpl.ApplicationManagerNestedImpl();
  }
  public KlusterletAddonConfigSpecFluentImpl.ApplicationManagerNested<A> withNewApplicationManagerLike(KlusterletAddonAgentConfigSpec item) {
    return new KlusterletAddonConfigSpecFluentImpl.ApplicationManagerNestedImpl(item);
  }
  public KlusterletAddonConfigSpecFluentImpl.ApplicationManagerNested<A> editApplicationManager() {
    return withNewApplicationManagerLike(getApplicationManager());
  }
  public KlusterletAddonConfigSpecFluentImpl.ApplicationManagerNested<A> editOrNewApplicationManager() {
    return withNewApplicationManagerLike(getApplicationManager() != null ? getApplicationManager(): new KlusterletAddonAgentConfigSpecBuilder().build());
  }
  public KlusterletAddonConfigSpecFluentImpl.ApplicationManagerNested<A> editOrNewApplicationManagerLike(KlusterletAddonAgentConfigSpec item) {
    return withNewApplicationManagerLike(getApplicationManager() != null ? getApplicationManager(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildCertPolicyController instead.
   * @return The buildable object.
   */
  @Deprecated
  public KlusterletAddonAgentConfigSpec getCertPolicyController() {
    return this.certPolicyController!=null ?this.certPolicyController.build():null;
  }
  public KlusterletAddonAgentConfigSpec buildCertPolicyController() {
    return this.certPolicyController!=null ?this.certPolicyController.build():null;
  }
  public A withCertPolicyController(KlusterletAddonAgentConfigSpec certPolicyController) {
    _visitables.get("certPolicyController").remove(this.certPolicyController);
    if (certPolicyController!=null){ this.certPolicyController= new KlusterletAddonAgentConfigSpecBuilder(certPolicyController); _visitables.get("certPolicyController").add(this.certPolicyController);} else { this.certPolicyController = null; _visitables.get("certPolicyController").remove(this.certPolicyController); } return (A) this;
  }
  public Boolean hasCertPolicyController() {
    return this.certPolicyController != null;
  }
  public A withNewCertPolicyController(Boolean enabled,String proxyPolicy) {
    return (A)withCertPolicyController(new KlusterletAddonAgentConfigSpec(enabled, proxyPolicy));
  }
  public KlusterletAddonConfigSpecFluentImpl.CertPolicyControllerNested<A> withNewCertPolicyController() {
    return new KlusterletAddonConfigSpecFluentImpl.CertPolicyControllerNestedImpl();
  }
  public KlusterletAddonConfigSpecFluentImpl.CertPolicyControllerNested<A> withNewCertPolicyControllerLike(KlusterletAddonAgentConfigSpec item) {
    return new KlusterletAddonConfigSpecFluentImpl.CertPolicyControllerNestedImpl(item);
  }
  public KlusterletAddonConfigSpecFluentImpl.CertPolicyControllerNested<A> editCertPolicyController() {
    return withNewCertPolicyControllerLike(getCertPolicyController());
  }
  public KlusterletAddonConfigSpecFluentImpl.CertPolicyControllerNested<A> editOrNewCertPolicyController() {
    return withNewCertPolicyControllerLike(getCertPolicyController() != null ? getCertPolicyController(): new KlusterletAddonAgentConfigSpecBuilder().build());
  }
  public KlusterletAddonConfigSpecFluentImpl.CertPolicyControllerNested<A> editOrNewCertPolicyControllerLike(KlusterletAddonAgentConfigSpec item) {
    return withNewCertPolicyControllerLike(getCertPolicyController() != null ? getCertPolicyController(): item);
  }
  public A addToClusterLabels(String key,String value) {
    if(this.clusterLabels == null && key != null && value != null) { this.clusterLabels = new LinkedHashMap(); }
    if(key != null && value != null) {this.clusterLabels.put(key, value);} return (A)this;
  }
  public A addToClusterLabels(Map<String,String> map) {
    if(this.clusterLabels == null && map != null) { this.clusterLabels = new LinkedHashMap(); }
    if(map != null) { this.clusterLabels.putAll(map);} return (A)this;
  }
  public A removeFromClusterLabels(String key) {
    if(this.clusterLabels == null) { return (A) this; }
    if(key != null && this.clusterLabels != null) {this.clusterLabels.remove(key);} return (A)this;
  }
  public A removeFromClusterLabels(Map<String,String> map) {
    if(this.clusterLabels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.clusterLabels != null){this.clusterLabels.remove(key);}}} return (A)this;
  }
  public Map<String,String> getClusterLabels() {
    return this.clusterLabels;
  }
  public <K,V>A withClusterLabels(Map<String,String> clusterLabels) {
    if (clusterLabels == null) { this.clusterLabels =  null;} else {this.clusterLabels = new LinkedHashMap(clusterLabels);} return (A) this;
  }
  public Boolean hasClusterLabels() {
    return this.clusterLabels != null;
  }
  public String getClusterName() {
    return this.clusterName;
  }
  public A withClusterName(String clusterName) {
    this.clusterName=clusterName; return (A) this;
  }
  public Boolean hasClusterName() {
    return this.clusterName != null;
  }
  public String getClusterNamespace() {
    return this.clusterNamespace;
  }
  public A withClusterNamespace(String clusterNamespace) {
    this.clusterNamespace=clusterNamespace; return (A) this;
  }
  public Boolean hasClusterNamespace() {
    return this.clusterNamespace != null;
  }
  
  /**
   * This method has been deprecated, please use method buildIamPolicyController instead.
   * @return The buildable object.
   */
  @Deprecated
  public KlusterletAddonAgentConfigSpec getIamPolicyController() {
    return this.iamPolicyController!=null ?this.iamPolicyController.build():null;
  }
  public KlusterletAddonAgentConfigSpec buildIamPolicyController() {
    return this.iamPolicyController!=null ?this.iamPolicyController.build():null;
  }
  public A withIamPolicyController(KlusterletAddonAgentConfigSpec iamPolicyController) {
    _visitables.get("iamPolicyController").remove(this.iamPolicyController);
    if (iamPolicyController!=null){ this.iamPolicyController= new KlusterletAddonAgentConfigSpecBuilder(iamPolicyController); _visitables.get("iamPolicyController").add(this.iamPolicyController);} else { this.iamPolicyController = null; _visitables.get("iamPolicyController").remove(this.iamPolicyController); } return (A) this;
  }
  public Boolean hasIamPolicyController() {
    return this.iamPolicyController != null;
  }
  public A withNewIamPolicyController(Boolean enabled,String proxyPolicy) {
    return (A)withIamPolicyController(new KlusterletAddonAgentConfigSpec(enabled, proxyPolicy));
  }
  public KlusterletAddonConfigSpecFluentImpl.IamPolicyControllerNested<A> withNewIamPolicyController() {
    return new KlusterletAddonConfigSpecFluentImpl.IamPolicyControllerNestedImpl();
  }
  public KlusterletAddonConfigSpecFluentImpl.IamPolicyControllerNested<A> withNewIamPolicyControllerLike(KlusterletAddonAgentConfigSpec item) {
    return new KlusterletAddonConfigSpecFluentImpl.IamPolicyControllerNestedImpl(item);
  }
  public KlusterletAddonConfigSpecFluentImpl.IamPolicyControllerNested<A> editIamPolicyController() {
    return withNewIamPolicyControllerLike(getIamPolicyController());
  }
  public KlusterletAddonConfigSpecFluentImpl.IamPolicyControllerNested<A> editOrNewIamPolicyController() {
    return withNewIamPolicyControllerLike(getIamPolicyController() != null ? getIamPolicyController(): new KlusterletAddonAgentConfigSpecBuilder().build());
  }
  public KlusterletAddonConfigSpecFluentImpl.IamPolicyControllerNested<A> editOrNewIamPolicyControllerLike(KlusterletAddonAgentConfigSpec item) {
    return withNewIamPolicyControllerLike(getIamPolicyController() != null ? getIamPolicyController(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPolicyController instead.
   * @return The buildable object.
   */
  @Deprecated
  public KlusterletAddonAgentConfigSpec getPolicyController() {
    return this.policyController!=null ?this.policyController.build():null;
  }
  public KlusterletAddonAgentConfigSpec buildPolicyController() {
    return this.policyController!=null ?this.policyController.build():null;
  }
  public A withPolicyController(KlusterletAddonAgentConfigSpec policyController) {
    _visitables.get("policyController").remove(this.policyController);
    if (policyController!=null){ this.policyController= new KlusterletAddonAgentConfigSpecBuilder(policyController); _visitables.get("policyController").add(this.policyController);} else { this.policyController = null; _visitables.get("policyController").remove(this.policyController); } return (A) this;
  }
  public Boolean hasPolicyController() {
    return this.policyController != null;
  }
  public A withNewPolicyController(Boolean enabled,String proxyPolicy) {
    return (A)withPolicyController(new KlusterletAddonAgentConfigSpec(enabled, proxyPolicy));
  }
  public KlusterletAddonConfigSpecFluentImpl.PolicyControllerNested<A> withNewPolicyController() {
    return new KlusterletAddonConfigSpecFluentImpl.PolicyControllerNestedImpl();
  }
  public KlusterletAddonConfigSpecFluentImpl.PolicyControllerNested<A> withNewPolicyControllerLike(KlusterletAddonAgentConfigSpec item) {
    return new KlusterletAddonConfigSpecFluentImpl.PolicyControllerNestedImpl(item);
  }
  public KlusterletAddonConfigSpecFluentImpl.PolicyControllerNested<A> editPolicyController() {
    return withNewPolicyControllerLike(getPolicyController());
  }
  public KlusterletAddonConfigSpecFluentImpl.PolicyControllerNested<A> editOrNewPolicyController() {
    return withNewPolicyControllerLike(getPolicyController() != null ? getPolicyController(): new KlusterletAddonAgentConfigSpecBuilder().build());
  }
  public KlusterletAddonConfigSpecFluentImpl.PolicyControllerNested<A> editOrNewPolicyControllerLike(KlusterletAddonAgentConfigSpec item) {
    return withNewPolicyControllerLike(getPolicyController() != null ? getPolicyController(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildProxyConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public ProxyConfig getProxyConfig() {
    return this.proxyConfig!=null ?this.proxyConfig.build():null;
  }
  public ProxyConfig buildProxyConfig() {
    return this.proxyConfig!=null ?this.proxyConfig.build():null;
  }
  public A withProxyConfig(ProxyConfig proxyConfig) {
    _visitables.get("proxyConfig").remove(this.proxyConfig);
    if (proxyConfig!=null){ this.proxyConfig= new ProxyConfigBuilder(proxyConfig); _visitables.get("proxyConfig").add(this.proxyConfig);} else { this.proxyConfig = null; _visitables.get("proxyConfig").remove(this.proxyConfig); } return (A) this;
  }
  public Boolean hasProxyConfig() {
    return this.proxyConfig != null;
  }
  public A withNewProxyConfig(String httpProxy,String httpsProxy,String noProxy) {
    return (A)withProxyConfig(new ProxyConfig(httpProxy, httpsProxy, noProxy));
  }
  public KlusterletAddonConfigSpecFluentImpl.ProxyConfigNested<A> withNewProxyConfig() {
    return new KlusterletAddonConfigSpecFluentImpl.ProxyConfigNestedImpl();
  }
  public KlusterletAddonConfigSpecFluentImpl.ProxyConfigNested<A> withNewProxyConfigLike(ProxyConfig item) {
    return new KlusterletAddonConfigSpecFluentImpl.ProxyConfigNestedImpl(item);
  }
  public KlusterletAddonConfigSpecFluentImpl.ProxyConfigNested<A> editProxyConfig() {
    return withNewProxyConfigLike(getProxyConfig());
  }
  public KlusterletAddonConfigSpecFluentImpl.ProxyConfigNested<A> editOrNewProxyConfig() {
    return withNewProxyConfigLike(getProxyConfig() != null ? getProxyConfig(): new ProxyConfigBuilder().build());
  }
  public KlusterletAddonConfigSpecFluentImpl.ProxyConfigNested<A> editOrNewProxyConfigLike(ProxyConfig item) {
    return withNewProxyConfigLike(getProxyConfig() != null ? getProxyConfig(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSearchCollector instead.
   * @return The buildable object.
   */
  @Deprecated
  public KlusterletAddonAgentConfigSpec getSearchCollector() {
    return this.searchCollector!=null ?this.searchCollector.build():null;
  }
  public KlusterletAddonAgentConfigSpec buildSearchCollector() {
    return this.searchCollector!=null ?this.searchCollector.build():null;
  }
  public A withSearchCollector(KlusterletAddonAgentConfigSpec searchCollector) {
    _visitables.get("searchCollector").remove(this.searchCollector);
    if (searchCollector!=null){ this.searchCollector= new KlusterletAddonAgentConfigSpecBuilder(searchCollector); _visitables.get("searchCollector").add(this.searchCollector);} else { this.searchCollector = null; _visitables.get("searchCollector").remove(this.searchCollector); } return (A) this;
  }
  public Boolean hasSearchCollector() {
    return this.searchCollector != null;
  }
  public A withNewSearchCollector(Boolean enabled,String proxyPolicy) {
    return (A)withSearchCollector(new KlusterletAddonAgentConfigSpec(enabled, proxyPolicy));
  }
  public KlusterletAddonConfigSpecFluentImpl.SearchCollectorNested<A> withNewSearchCollector() {
    return new KlusterletAddonConfigSpecFluentImpl.SearchCollectorNestedImpl();
  }
  public KlusterletAddonConfigSpecFluentImpl.SearchCollectorNested<A> withNewSearchCollectorLike(KlusterletAddonAgentConfigSpec item) {
    return new KlusterletAddonConfigSpecFluentImpl.SearchCollectorNestedImpl(item);
  }
  public KlusterletAddonConfigSpecFluentImpl.SearchCollectorNested<A> editSearchCollector() {
    return withNewSearchCollectorLike(getSearchCollector());
  }
  public KlusterletAddonConfigSpecFluentImpl.SearchCollectorNested<A> editOrNewSearchCollector() {
    return withNewSearchCollectorLike(getSearchCollector() != null ? getSearchCollector(): new KlusterletAddonAgentConfigSpecBuilder().build());
  }
  public KlusterletAddonConfigSpecFluentImpl.SearchCollectorNested<A> editOrNewSearchCollectorLike(KlusterletAddonAgentConfigSpec item) {
    return withNewSearchCollectorLike(getSearchCollector() != null ? getSearchCollector(): item);
  }
  public String getVersion() {
    return this.version;
  }
  public A withVersion(String version) {
    this.version=version; return (A) this;
  }
  public Boolean hasVersion() {
    return this.version != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KlusterletAddonConfigSpecFluentImpl that = (KlusterletAddonConfigSpecFluentImpl) o;
    if (!java.util.Objects.equals(applicationManager, that.applicationManager)) return false;

    if (!java.util.Objects.equals(certPolicyController, that.certPolicyController)) return false;

    if (!java.util.Objects.equals(clusterLabels, that.clusterLabels)) return false;

    if (!java.util.Objects.equals(clusterName, that.clusterName)) return false;

    if (!java.util.Objects.equals(clusterNamespace, that.clusterNamespace)) return false;

    if (!java.util.Objects.equals(iamPolicyController, that.iamPolicyController)) return false;

    if (!java.util.Objects.equals(policyController, that.policyController)) return false;

    if (!java.util.Objects.equals(proxyConfig, that.proxyConfig)) return false;

    if (!java.util.Objects.equals(searchCollector, that.searchCollector)) return false;

    if (!java.util.Objects.equals(version, that.version)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(applicationManager,  certPolicyController,  clusterLabels,  clusterName,  clusterNamespace,  iamPolicyController,  policyController,  proxyConfig,  searchCollector,  version,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (applicationManager != null) { sb.append("applicationManager:"); sb.append(applicationManager + ","); }
    if (certPolicyController != null) { sb.append("certPolicyController:"); sb.append(certPolicyController + ","); }
    if (clusterLabels != null && !clusterLabels.isEmpty()) { sb.append("clusterLabels:"); sb.append(clusterLabels + ","); }
    if (clusterName != null) { sb.append("clusterName:"); sb.append(clusterName + ","); }
    if (clusterNamespace != null) { sb.append("clusterNamespace:"); sb.append(clusterNamespace + ","); }
    if (iamPolicyController != null) { sb.append("iamPolicyController:"); sb.append(iamPolicyController + ","); }
    if (policyController != null) { sb.append("policyController:"); sb.append(policyController + ","); }
    if (proxyConfig != null) { sb.append("proxyConfig:"); sb.append(proxyConfig + ","); }
    if (searchCollector != null) { sb.append("searchCollector:"); sb.append(searchCollector + ","); }
    if (version != null) { sb.append("version:"); sb.append(version); }
    sb.append("}");
    return sb.toString();
  }
  class ApplicationManagerNestedImpl<N> extends KlusterletAddonAgentConfigSpecFluentImpl<KlusterletAddonConfigSpecFluentImpl.ApplicationManagerNested<N>> implements KlusterletAddonConfigSpecFluentImpl.ApplicationManagerNested<N>,Nested<N>{
    ApplicationManagerNestedImpl(KlusterletAddonAgentConfigSpec item) {
      this.builder = new KlusterletAddonAgentConfigSpecBuilder(this, item);
    }
    ApplicationManagerNestedImpl() {
      this.builder = new KlusterletAddonAgentConfigSpecBuilder(this);
    }
    KlusterletAddonAgentConfigSpecBuilder builder;
    public N and() {
      return (N) KlusterletAddonConfigSpecFluentImpl.this.withApplicationManager(builder.build());
    }
    public N endApplicationManager() {
      return and();
    }
    
  }
  class CertPolicyControllerNestedImpl<N> extends KlusterletAddonAgentConfigSpecFluentImpl<KlusterletAddonConfigSpecFluentImpl.CertPolicyControllerNested<N>> implements KlusterletAddonConfigSpecFluentImpl.CertPolicyControllerNested<N>,Nested<N>{
    CertPolicyControllerNestedImpl(KlusterletAddonAgentConfigSpec item) {
      this.builder = new KlusterletAddonAgentConfigSpecBuilder(this, item);
    }
    CertPolicyControllerNestedImpl() {
      this.builder = new KlusterletAddonAgentConfigSpecBuilder(this);
    }
    KlusterletAddonAgentConfigSpecBuilder builder;
    public N and() {
      return (N) KlusterletAddonConfigSpecFluentImpl.this.withCertPolicyController(builder.build());
    }
    public N endCertPolicyController() {
      return and();
    }
    
  }
  class IamPolicyControllerNestedImpl<N> extends KlusterletAddonAgentConfigSpecFluentImpl<KlusterletAddonConfigSpecFluentImpl.IamPolicyControllerNested<N>> implements KlusterletAddonConfigSpecFluentImpl.IamPolicyControllerNested<N>,Nested<N>{
    IamPolicyControllerNestedImpl(KlusterletAddonAgentConfigSpec item) {
      this.builder = new KlusterletAddonAgentConfigSpecBuilder(this, item);
    }
    IamPolicyControllerNestedImpl() {
      this.builder = new KlusterletAddonAgentConfigSpecBuilder(this);
    }
    KlusterletAddonAgentConfigSpecBuilder builder;
    public N and() {
      return (N) KlusterletAddonConfigSpecFluentImpl.this.withIamPolicyController(builder.build());
    }
    public N endIamPolicyController() {
      return and();
    }
    
  }
  class PolicyControllerNestedImpl<N> extends KlusterletAddonAgentConfigSpecFluentImpl<KlusterletAddonConfigSpecFluentImpl.PolicyControllerNested<N>> implements KlusterletAddonConfigSpecFluentImpl.PolicyControllerNested<N>,Nested<N>{
    PolicyControllerNestedImpl(KlusterletAddonAgentConfigSpec item) {
      this.builder = new KlusterletAddonAgentConfigSpecBuilder(this, item);
    }
    PolicyControllerNestedImpl() {
      this.builder = new KlusterletAddonAgentConfigSpecBuilder(this);
    }
    KlusterletAddonAgentConfigSpecBuilder builder;
    public N and() {
      return (N) KlusterletAddonConfigSpecFluentImpl.this.withPolicyController(builder.build());
    }
    public N endPolicyController() {
      return and();
    }
    
  }
  class ProxyConfigNestedImpl<N> extends ProxyConfigFluentImpl<KlusterletAddonConfigSpecFluentImpl.ProxyConfigNested<N>> implements KlusterletAddonConfigSpecFluentImpl.ProxyConfigNested<N>,Nested<N>{
    ProxyConfigNestedImpl(ProxyConfig item) {
      this.builder = new ProxyConfigBuilder(this, item);
    }
    ProxyConfigNestedImpl() {
      this.builder = new ProxyConfigBuilder(this);
    }
    ProxyConfigBuilder builder;
    public N and() {
      return (N) KlusterletAddonConfigSpecFluentImpl.this.withProxyConfig(builder.build());
    }
    public N endProxyConfig() {
      return and();
    }
    
  }
  class SearchCollectorNestedImpl<N> extends KlusterletAddonAgentConfigSpecFluentImpl<KlusterletAddonConfigSpecFluentImpl.SearchCollectorNested<N>> implements KlusterletAddonConfigSpecFluentImpl.SearchCollectorNested<N>,Nested<N>{
    SearchCollectorNestedImpl(KlusterletAddonAgentConfigSpec item) {
      this.builder = new KlusterletAddonAgentConfigSpecBuilder(this, item);
    }
    SearchCollectorNestedImpl() {
      this.builder = new KlusterletAddonAgentConfigSpecBuilder(this);
    }
    KlusterletAddonAgentConfigSpecBuilder builder;
    public N and() {
      return (N) KlusterletAddonConfigSpecFluentImpl.this.withSearchCollector(builder.build());
    }
    public N endSearchCollector() {
      return and();
    }
    
  }
  
}