package io.fabric8.openclustermanagement.api.model.agent.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KlusterletAddonConfigListBuilder extends KlusterletAddonConfigListFluentImpl<KlusterletAddonConfigListBuilder> implements VisitableBuilder<KlusterletAddonConfigList,KlusterletAddonConfigListBuilder>{
  public KlusterletAddonConfigListBuilder() {
    this(false);
  }
  public KlusterletAddonConfigListBuilder(Boolean validationEnabled) {
    this(new KlusterletAddonConfigList(), validationEnabled);
  }
  public KlusterletAddonConfigListBuilder(KlusterletAddonConfigListFluent<?> fluent) {
    this(fluent, false);
  }
  public KlusterletAddonConfigListBuilder(KlusterletAddonConfigListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KlusterletAddonConfigList(), validationEnabled);
  }
  public KlusterletAddonConfigListBuilder(KlusterletAddonConfigListFluent<?> fluent,KlusterletAddonConfigList instance) {
    this(fluent, instance, false);
  }
  public KlusterletAddonConfigListBuilder(KlusterletAddonConfigListFluent<?> fluent,KlusterletAddonConfigList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KlusterletAddonConfigListBuilder(KlusterletAddonConfigList instance) {
    this(instance,false);
  }
  public KlusterletAddonConfigListBuilder(KlusterletAddonConfigList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  KlusterletAddonConfigListFluent<?> fluent;
  Boolean validationEnabled;
  public KlusterletAddonConfigList build() {
    KlusterletAddonConfigList buildable = new KlusterletAddonConfigList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}