package io.fabric8.openclustermanagement.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OpenClusterManagementAgentSchemaBuilder extends OpenClusterManagementAgentSchemaFluentImpl<OpenClusterManagementAgentSchemaBuilder> implements VisitableBuilder<OpenClusterManagementAgentSchema,OpenClusterManagementAgentSchemaBuilder>{
  public OpenClusterManagementAgentSchemaBuilder() {
    this(false);
  }
  public OpenClusterManagementAgentSchemaBuilder(Boolean validationEnabled) {
    this(new OpenClusterManagementAgentSchema(), validationEnabled);
  }
  public OpenClusterManagementAgentSchemaBuilder(OpenClusterManagementAgentSchemaFluent<?> fluent) {
    this(fluent, false);
  }
  public OpenClusterManagementAgentSchemaBuilder(OpenClusterManagementAgentSchemaFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OpenClusterManagementAgentSchema(), validationEnabled);
  }
  public OpenClusterManagementAgentSchemaBuilder(OpenClusterManagementAgentSchemaFluent<?> fluent,OpenClusterManagementAgentSchema instance) {
    this(fluent, instance, false);
  }
  public OpenClusterManagementAgentSchemaBuilder(OpenClusterManagementAgentSchemaFluent<?> fluent,OpenClusterManagementAgentSchema instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withGithubComOpenClusterManagementKlusterletAddonControllerPkgApisAgentV1KlusterletAddonAgentConfigSpec(instance.getGithubComOpenClusterManagementKlusterletAddonControllerPkgApisAgentV1KlusterletAddonAgentConfigSpec());
      fluent.withGithubComOpenClusterManagementKlusterletAddonControllerPkgApisAgentV1KlusterletAddonConfig(instance.getGithubComOpenClusterManagementKlusterletAddonControllerPkgApisAgentV1KlusterletAddonConfig());
      fluent.withGithubComOpenClusterManagementKlusterletAddonControllerPkgApisAgentV1KlusterletAddonConfigList(instance.getGithubComOpenClusterManagementKlusterletAddonControllerPkgApisAgentV1KlusterletAddonConfigList());
      fluent.withGithubComOpenClusterManagementKlusterletAddonControllerPkgApisAgentV1KlusterletAddonConfigSpec(instance.getGithubComOpenClusterManagementKlusterletAddonControllerPkgApisAgentV1KlusterletAddonConfigSpec());
      fluent.withGithubComOpenClusterManagementKlusterletAddonControllerPkgApisAgentV1KlusterletAddonConfigStatus(instance.getGithubComOpenClusterManagementKlusterletAddonControllerPkgApisAgentV1KlusterletAddonConfigStatus());
      fluent.withGithubComOpenClusterManagementKlusterletAddonControllerPkgApisAgentV1ProxyConfig(instance.getGithubComOpenClusterManagementKlusterletAddonControllerPkgApisAgentV1ProxyConfig());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OpenClusterManagementAgentSchemaBuilder(OpenClusterManagementAgentSchema instance) {
    this(instance,false);
  }
  public OpenClusterManagementAgentSchemaBuilder(OpenClusterManagementAgentSchema instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withGithubComOpenClusterManagementKlusterletAddonControllerPkgApisAgentV1KlusterletAddonAgentConfigSpec(instance.getGithubComOpenClusterManagementKlusterletAddonControllerPkgApisAgentV1KlusterletAddonAgentConfigSpec());
      this.withGithubComOpenClusterManagementKlusterletAddonControllerPkgApisAgentV1KlusterletAddonConfig(instance.getGithubComOpenClusterManagementKlusterletAddonControllerPkgApisAgentV1KlusterletAddonConfig());
      this.withGithubComOpenClusterManagementKlusterletAddonControllerPkgApisAgentV1KlusterletAddonConfigList(instance.getGithubComOpenClusterManagementKlusterletAddonControllerPkgApisAgentV1KlusterletAddonConfigList());
      this.withGithubComOpenClusterManagementKlusterletAddonControllerPkgApisAgentV1KlusterletAddonConfigSpec(instance.getGithubComOpenClusterManagementKlusterletAddonControllerPkgApisAgentV1KlusterletAddonConfigSpec());
      this.withGithubComOpenClusterManagementKlusterletAddonControllerPkgApisAgentV1KlusterletAddonConfigStatus(instance.getGithubComOpenClusterManagementKlusterletAddonControllerPkgApisAgentV1KlusterletAddonConfigStatus());
      this.withGithubComOpenClusterManagementKlusterletAddonControllerPkgApisAgentV1ProxyConfig(instance.getGithubComOpenClusterManagementKlusterletAddonControllerPkgApisAgentV1ProxyConfig());
    }
    this.validationEnabled = validationEnabled; 
  }
  OpenClusterManagementAgentSchemaFluent<?> fluent;
  Boolean validationEnabled;
  public OpenClusterManagementAgentSchema build() {
    OpenClusterManagementAgentSchema buildable = new OpenClusterManagementAgentSchema(fluent.getGithubComOpenClusterManagementKlusterletAddonControllerPkgApisAgentV1KlusterletAddonAgentConfigSpec(),fluent.getGithubComOpenClusterManagementKlusterletAddonControllerPkgApisAgentV1KlusterletAddonConfig(),fluent.getGithubComOpenClusterManagementKlusterletAddonControllerPkgApisAgentV1KlusterletAddonConfigList(),fluent.getGithubComOpenClusterManagementKlusterletAddonControllerPkgApisAgentV1KlusterletAddonConfigSpec(),fluent.getGithubComOpenClusterManagementKlusterletAddonControllerPkgApisAgentV1KlusterletAddonConfigStatus(),fluent.getGithubComOpenClusterManagementKlusterletAddonControllerPkgApisAgentV1ProxyConfig());
    return buildable;
  }
  
}