package io.fabric8.openclustermanagement.api.model.agent.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KlusterletAddonConfigBuilder extends KlusterletAddonConfigFluentImpl<KlusterletAddonConfigBuilder> implements VisitableBuilder<KlusterletAddonConfig,KlusterletAddonConfigBuilder>{
  public KlusterletAddonConfigBuilder() {
    this(false);
  }
  public KlusterletAddonConfigBuilder(Boolean validationEnabled) {
    this(new KlusterletAddonConfig(), validationEnabled);
  }
  public KlusterletAddonConfigBuilder(KlusterletAddonConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public KlusterletAddonConfigBuilder(KlusterletAddonConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KlusterletAddonConfig(), validationEnabled);
  }
  public KlusterletAddonConfigBuilder(KlusterletAddonConfigFluent<?> fluent,KlusterletAddonConfig instance) {
    this(fluent, instance, false);
  }
  public KlusterletAddonConfigBuilder(KlusterletAddonConfigFluent<?> fluent,KlusterletAddonConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public KlusterletAddonConfigBuilder(KlusterletAddonConfig instance) {
    this(instance,false);
  }
  public KlusterletAddonConfigBuilder(KlusterletAddonConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  KlusterletAddonConfigFluent<?> fluent;
  Boolean validationEnabled;
  public KlusterletAddonConfig build() {
    KlusterletAddonConfig buildable = new KlusterletAddonConfig(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}