package io.fabric8.openclustermanagement.api.model.agent.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KlusterletAddonConfigStatusBuilder extends KlusterletAddonConfigStatusFluentImpl<KlusterletAddonConfigStatusBuilder> implements VisitableBuilder<KlusterletAddonConfigStatus,KlusterletAddonConfigStatusBuilder>{
  public KlusterletAddonConfigStatusBuilder() {
    this(false);
  }
  public KlusterletAddonConfigStatusBuilder(Boolean validationEnabled) {
    this(new KlusterletAddonConfigStatus(), validationEnabled);
  }
  public KlusterletAddonConfigStatusBuilder(KlusterletAddonConfigStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public KlusterletAddonConfigStatusBuilder(KlusterletAddonConfigStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KlusterletAddonConfigStatus(), validationEnabled);
  }
  public KlusterletAddonConfigStatusBuilder(KlusterletAddonConfigStatusFluent<?> fluent,KlusterletAddonConfigStatus instance) {
    this(fluent, instance, false);
  }
  public KlusterletAddonConfigStatusBuilder(KlusterletAddonConfigStatusFluent<?> fluent,KlusterletAddonConfigStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditions(instance.getConditions()); 
    fluent.withOcpGlobalProxy(instance.getOcpGlobalProxy()); 
    this.validationEnabled = validationEnabled; 
  }
  public KlusterletAddonConfigStatusBuilder(KlusterletAddonConfigStatus instance) {
    this(instance,false);
  }
  public KlusterletAddonConfigStatusBuilder(KlusterletAddonConfigStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditions(instance.getConditions()); 
    this.withOcpGlobalProxy(instance.getOcpGlobalProxy()); 
    this.validationEnabled = validationEnabled; 
  }
  KlusterletAddonConfigStatusFluent<?> fluent;
  Boolean validationEnabled;
  public KlusterletAddonConfigStatus build() {
    KlusterletAddonConfigStatus buildable = new KlusterletAddonConfigStatus(fluent.getConditions(),fluent.getOcpGlobalProxy());
    return buildable;
  }
  
}