package io.fabric8.openclustermanagement.api.model.agent.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ProxyConfigBuilder extends io.fabric8.openclustermanagement.api.model.agent.v1.ProxyConfigFluentImpl<io.fabric8.openclustermanagement.api.model.agent.v1.ProxyConfigBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openclustermanagement.api.model.agent.v1.ProxyConfig,io.fabric8.openclustermanagement.api.model.agent.v1.ProxyConfigBuilder>{
  public ProxyConfigBuilder() {
    this(false);
  }
  public ProxyConfigBuilder(java.lang.Boolean validationEnabled) {
    this(new ProxyConfig(), validationEnabled);
  }
  public ProxyConfigBuilder(io.fabric8.openclustermanagement.api.model.agent.v1.ProxyConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ProxyConfigBuilder(io.fabric8.openclustermanagement.api.model.agent.v1.ProxyConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ProxyConfig(), validationEnabled);
  }
  public ProxyConfigBuilder(io.fabric8.openclustermanagement.api.model.agent.v1.ProxyConfigFluent<?> fluent,io.fabric8.openclustermanagement.api.model.agent.v1.ProxyConfig instance) {
    this(fluent, instance, false);
  }
  public ProxyConfigBuilder(io.fabric8.openclustermanagement.api.model.agent.v1.ProxyConfigFluent<?> fluent,io.fabric8.openclustermanagement.api.model.agent.v1.ProxyConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHttpProxy(instance.getHttpProxy()); 
    fluent.withHttpsProxy(instance.getHttpsProxy()); 
    fluent.withNoProxy(instance.getNoProxy()); 
    this.validationEnabled = validationEnabled; 
  }
  public ProxyConfigBuilder(io.fabric8.openclustermanagement.api.model.agent.v1.ProxyConfig instance) {
    this(instance,false);
  }
  public ProxyConfigBuilder(io.fabric8.openclustermanagement.api.model.agent.v1.ProxyConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withHttpProxy(instance.getHttpProxy()); 
    this.withHttpsProxy(instance.getHttpsProxy()); 
    this.withNoProxy(instance.getNoProxy()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openclustermanagement.api.model.agent.v1.ProxyConfigFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openclustermanagement.api.model.agent.v1.ProxyConfig build() {
    ProxyConfig buildable = new ProxyConfig(fluent.getHttpProxy(),fluent.getHttpsProxy(),fluent.getNoProxy());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ProxyConfigBuilder that = (ProxyConfigBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}