/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.agent.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.openclustermanagement.api.model.agent.v1.KlusterletAddonConfigStatus;
import io.fabric8.openclustermanagement.api.model.agent.v1.KlusterletAddonConfigStatusFluent;
import io.fabric8.openclustermanagement.api.model.agent.v1.ProxyConfig;
import io.fabric8.openclustermanagement.api.model.agent.v1.ProxyConfigBuilder;
import io.fabric8.openclustermanagement.api.model.agent.v1.ProxyConfigFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class KlusterletAddonConfigStatusFluentImpl<A extends KlusterletAddonConfigStatusFluent<A>>
extends BaseFluent<A>
implements KlusterletAddonConfigStatusFluent<A> {
    private List<Condition> conditions;
    private ProxyConfigBuilder ocpGlobalProxy;

    public KlusterletAddonConfigStatusFluentImpl() {
    }

    public KlusterletAddonConfigStatusFluentImpl(KlusterletAddonConfigStatus instance) {
        this.withConditions(instance.getConditions());
        this.withOcpGlobalProxy(instance.getOcpGlobalProxy());
    }

    @Override
    public A addToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(Condition ... items) {
        for (Condition item : items) {
            if (this.conditions == null) continue;
            this.conditions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<Condition> items) {
        for (Condition item : items) {
            if (this.conditions == null) continue;
            this.conditions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Override
    public Condition getCondition(Integer index) {
        return this.conditions.get(index);
    }

    @Override
    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    @Override
    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    @Override
    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    @Deprecated
    public ProxyConfig getOcpGlobalProxy() {
        return this.ocpGlobalProxy != null ? this.ocpGlobalProxy.build() : null;
    }

    @Override
    public ProxyConfig buildOcpGlobalProxy() {
        return this.ocpGlobalProxy != null ? this.ocpGlobalProxy.build() : null;
    }

    @Override
    public A withOcpGlobalProxy(ProxyConfig ocpGlobalProxy) {
        this._visitables.get((Object)"ocpGlobalProxy").remove(this.ocpGlobalProxy);
        if (ocpGlobalProxy != null) {
            this.ocpGlobalProxy = new ProxyConfigBuilder(ocpGlobalProxy);
            this._visitables.get((Object)"ocpGlobalProxy").add(this.ocpGlobalProxy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasOcpGlobalProxy() {
        return this.ocpGlobalProxy != null;
    }

    @Override
    public A withNewOcpGlobalProxy(String httpProxy, String httpsProxy, String noProxy) {
        return this.withOcpGlobalProxy(new ProxyConfig(httpProxy, httpsProxy, noProxy));
    }

    @Override
    public KlusterletAddonConfigStatusFluent.OcpGlobalProxyNested<A> withNewOcpGlobalProxy() {
        return new OcpGlobalProxyNestedImpl();
    }

    @Override
    public KlusterletAddonConfigStatusFluent.OcpGlobalProxyNested<A> withNewOcpGlobalProxyLike(ProxyConfig item) {
        return new OcpGlobalProxyNestedImpl(item);
    }

    @Override
    public KlusterletAddonConfigStatusFluent.OcpGlobalProxyNested<A> editOcpGlobalProxy() {
        return this.withNewOcpGlobalProxyLike(this.getOcpGlobalProxy());
    }

    @Override
    public KlusterletAddonConfigStatusFluent.OcpGlobalProxyNested<A> editOrNewOcpGlobalProxy() {
        return this.withNewOcpGlobalProxyLike(this.getOcpGlobalProxy() != null ? this.getOcpGlobalProxy() : new ProxyConfigBuilder().build());
    }

    @Override
    public KlusterletAddonConfigStatusFluent.OcpGlobalProxyNested<A> editOrNewOcpGlobalProxyLike(ProxyConfig item) {
        return this.withNewOcpGlobalProxyLike(this.getOcpGlobalProxy() != null ? this.getOcpGlobalProxy() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KlusterletAddonConfigStatusFluentImpl that = (KlusterletAddonConfigStatusFluentImpl)o;
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        return !(this.ocpGlobalProxy != null ? !this.ocpGlobalProxy.equals(that.ocpGlobalProxy) : that.ocpGlobalProxy != null);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.ocpGlobalProxy, super.hashCode());
    }

    public class OcpGlobalProxyNestedImpl<N>
    extends ProxyConfigFluentImpl<KlusterletAddonConfigStatusFluent.OcpGlobalProxyNested<N>>
    implements KlusterletAddonConfigStatusFluent.OcpGlobalProxyNested<N>,
    Nested<N> {
        ProxyConfigBuilder builder;

        OcpGlobalProxyNestedImpl(ProxyConfig item) {
            this.builder = new ProxyConfigBuilder(this, item);
        }

        OcpGlobalProxyNestedImpl() {
            this.builder = new ProxyConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)KlusterletAddonConfigStatusFluentImpl.this.withOcpGlobalProxy(this.builder.build());
        }

        @Override
        public N endOcpGlobalProxy() {
            return this.and();
        }
    }
}

