/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.maven.MavenJDOMWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public final class Maven {
    private Maven() {
        throw new IllegalAccessError("Utility class");
    }

    public static Model readModel(Path pom) {
        Model model;
        MavenXpp3Reader reader = new MavenXpp3Reader();
        try (BufferedReader br = Files.newBufferedReader(pom);){
            model = reader.read(br);
            model.setPomFile(pom.toFile());
        }
        catch (IOException io) {
            throw new UncheckedIOException("Error while reading pom.xml", io);
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException("Error while parsing pom.xml", e);
        }
        return model;
    }

    public static void writeModel(Model model) {
        Maven.writeModel(model, model.getPomFile().toPath());
    }

    public static void writeModel(Model model, Path pom) {
        block56: {
            Document document;
            Throwable throwable;
            if (pom.toFile().length() == 0L) {
                try (OutputStream os = Files.newOutputStream(pom, new OpenOption[0]);){
                    MavenXpp3Writer writer = new MavenXpp3Writer();
                    writer.write(os, model);
                    break block56;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Could not write POM file: " + pom, e);
                }
            }
            try {
                throwable = null;
                try (InputStream is = Files.newInputStream(pom, new OpenOption[0]);){
                    document = new SAXBuilder().build(is);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (JDOMException e) {
                throw new RuntimeException("Could not parse POM file: " + pom, e);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Could not read POM file: " + pom, e);
            }
            try {
                throwable = null;
                try (OutputStream os = Files.newOutputStream(pom, new OpenOption[0]);
                     OutputStreamWriter ow = new OutputStreamWriter(os);){
                    MavenJDOMWriter writer = new MavenJDOMWriter();
                    writer.write(model, document, "UTF-8", ow);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Could not write POM file: " + pom, e);
            }
        }
    }
}

