/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.maven.LineBreakProcessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.LineSeparator;
import org.jdom2.output.XMLOutputter;

public class XMLFormat {
    public static final XMLFormat DEFAULT = XMLFormat.builder().textMode(TextMode.PRESERVE).build();
    private final String indent;
    private final boolean insertLineBreakBetweenMajorSections;
    private final TextMode textMode;

    private XMLFormat(Builder builder) {
        this.indent = builder.indent;
        this.insertLineBreakBetweenMajorSections = builder.insertLineBreakBetweenMajorSections;
        this.textMode = builder.textMode;
    }

    public String getIndent() {
        return this.indent;
    }

    public boolean isInsertLineBreakBetweenMajorSections() {
        return this.insertLineBreakBetweenMajorSections;
    }

    public TextMode getTextMode() {
        return this.textMode;
    }

    public String format(Reader reader) {
        try {
            Document document = new SAXBuilder().build(reader);
            XMLOutputter xmlOutputter = this.createXmlOutputter();
            return xmlOutputter.outputString(document);
        }
        catch (JDOMException e) {
            throw new RuntimeException("Could not parse XML", e);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not read XML", e);
        }
    }

    public void format(Reader reader, Writer writer) {
        try {
            Document document = new SAXBuilder().build(reader);
            XMLOutputter xmlOutputter = this.createXmlOutputter();
            xmlOutputter.output(document, writer);
        }
        catch (JDOMException e) {
            throw new RuntimeException("Could not parse XML", e);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not read XML", e);
        }
    }

    XMLOutputter createXmlOutputter() {
        XMLOutputter xmlOutputter = new XMLOutputter();
        Format format = Format.getRawFormat();
        format.setIndent(this.indent);
        format.setLineSeparator(LineSeparator.UNIX);
        format.setTextMode(Format.TextMode.valueOf(this.textMode.name()));
        if (this.insertLineBreakBetweenMajorSections) {
            xmlOutputter.setXMLOutputProcessor(new LineBreakProcessor());
        }
        xmlOutputter.setFormat(format);
        return xmlOutputter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String findIndentation(Path pom) {
        try (BufferedReader br = Files.newBufferedReader(pom);){
            String line;
            int idx;
            do {
                if ((line = br.readLine()) == null) return DEFAULT.getIndent();
            } while ((idx = line.indexOf("<")) <= 0);
            String string = line.substring(0, idx);
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not read POM file: " + String.valueOf(pom), e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(XMLFormat format) {
        return new Builder().indent(format.getIndent()).insertLineBreakBetweenMajorSections(format.isInsertLineBreakBetweenMajorSections()).textMode(format.getTextMode());
    }

    public static class Builder {
        private String indent = "  ";
        private boolean insertLineBreakBetweenMajorSections = false;
        private TextMode textMode = TextMode.TRIM;

        Builder() {
        }

        public Builder indent(String indent) {
            this.indent = indent;
            return this;
        }

        public Builder insertLineBreakBetweenMajorSections() {
            return this.insertLineBreakBetweenMajorSections(true);
        }

        public Builder insertLineBreakBetweenMajorSections(boolean insertLineBreakBetweenMajorSections) {
            this.insertLineBreakBetweenMajorSections = insertLineBreakBetweenMajorSections;
            return this;
        }

        public Builder textMode(TextMode textMode) {
            this.textMode = textMode;
            return this;
        }

        public XMLFormat build() {
            return new XMLFormat(this);
        }
    }

    public static enum TextMode {
        PRESERVE,
        TRIM,
        NORMALIZE,
        TRIM_FULL_WHITE;

    }
}

