/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Properties;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Extension;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Notifier;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Parent;
import org.apache.maven.model.PatternSet;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginConfiguration;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Relocation;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryBase;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.model.Resource;
import org.apache.maven.model.Scm;
import org.apache.maven.model.Site;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jdom2.Content;
import org.jdom2.DefaultJDOMFactory;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Text;
import org.jdom2.output.XMLOutputter;

class MavenJDOMWriter {
    private final DefaultJDOMFactory factory = new DefaultJDOMFactory();
    private final String lineSeparator;
    private final String indentation;

    public MavenJDOMWriter(String indentation) {
        this.lineSeparator = "\n";
        this.indentation = indentation;
    }

    public void write(Model project, Document document, Writer writer, XMLOutputter xmlOutputter) throws IOException {
        this.updateModel(project, new Counter(0), document.getRootElement());
        xmlOutputter.output(document, writer);
    }

    protected void findAndReplaceProperties(Counter counter, Element parent, String name, Properties props) {
        boolean shouldExist = props != null && !props.isEmpty();
        Element element = this.updateElement(counter, parent, name, shouldExist);
        if (shouldExist) {
            Iterator<Object> it = props.keySet().iterator();
            Counter innerCounter = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                String key = it.next().toString();
                if (element.getChild(key, parent.getNamespace()) == null) {
                    Element newProperty = this.factory.element(key, parent.getNamespace()).setText(props.getProperty(key));
                    innerCounter.setCurrentIndex(element.getContentSize());
                    this.insertAtPreferredLocation(element, newProperty, innerCounter);
                    continue;
                }
                this.findAndReplaceSimpleElement(innerCounter, element, key, props.getProperty(key), null);
            }
            Iterator<Element> itElem = element.getChildren().iterator();
            while (itElem.hasNext()) {
                Element elem = itElem.next();
                String key = elem.getName();
                if (props.containsKey(key)) continue;
                itElem.remove();
            }
        }
    }

    protected void findAndReplaceSimpleElement(Counter counter, Element parent, String name, String text, String defaultValue) {
        if (defaultValue != null && defaultValue.equals(text)) {
            Element element = parent.getChild(name, parent.getNamespace());
            if (element != null && !defaultValue.equals(element.getText())) {
                parent.removeContent(element);
            }
            return;
        }
        boolean shouldExist = text != null && !text.trim().isEmpty();
        Element element = this.updateElement(counter, parent, name, shouldExist);
        if (shouldExist) {
            element.setText(text);
        }
    }

    protected void findAndReplaceSimpleLists(Counter counter, Element parent, Collection<String> list, String parentName, String childName) {
        boolean shouldExist = list != null && !list.isEmpty();
        Element element = this.updateElement(counter, parent, parentName, shouldExist);
        if (shouldExist) {
            Iterator<String> it = list.iterator();
            Iterator<Element> elIt = element.getChildren(childName, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                String value = it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childName, element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                el.setText(value);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void findAndReplaceXpp3DOM(Counter counter, Element parent, String name, Xpp3Dom dom) {
        boolean shouldExist = dom != null && (dom.getChildCount() > 0 || dom.getValue() != null);
        Element element = this.updateElement(counter, parent, name, shouldExist);
        if (shouldExist) {
            this.replaceXpp3DOM(element, dom, new Counter(counter.getDepth() + 1));
        }
    }

    protected void insertAtPreferredLocation(Element parent, Element child, Counter counter) {
        int contentIndex = 0;
        int elementCounter = 0;
        Iterator<Content> it = parent.getContent().iterator();
        Text lastText = null;
        int offset = 0;
        while (it.hasNext() && elementCounter < counter.getCurrentIndex()) {
            Content next = it.next();
            ++offset;
            if (next instanceof Element) {
                ++elementCounter;
                contentIndex += offset;
                offset = 0;
            }
            if (!(next instanceof Text) || !it.hasNext()) continue;
            lastText = (Text)next;
        }
        lastText = lastText != null && lastText.getTextTrim().isEmpty() ? lastText.clone() : this.factory.text(this.lineSeparator + this.indentation.repeat(counter.getDepth()));
        if (parent.getContentSize() == 0) {
            Text finalText = lastText.clone();
            finalText.setText(finalText.getText().substring(0, finalText.getText().length() - this.indentation.length()));
            parent.addContent(contentIndex, finalText);
        }
        parent.addContent(contentIndex, child);
        parent.addContent(contentIndex, lastText);
    }

    protected void iterateContributor(Counter counter, Element parent, Collection<Contributor> list) {
        boolean shouldExist = list != null && !list.isEmpty();
        Element element = this.updateElement(counter, parent, "contributors", shouldExist);
        if (shouldExist) {
            Iterator<Contributor> it = list.iterator();
            Iterator<Element> elIt = element.getChildren("contributor", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Contributor value = it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("contributor", element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateContributor(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateDependency(Counter counter, Element parent, Collection<Dependency> list) {
        boolean shouldExist = list != null && !list.isEmpty();
        Element element = this.updateElement(counter, parent, "dependencies", shouldExist);
        if (shouldExist) {
            Iterator<Dependency> it = list.iterator();
            Iterator<Element> elIt = element.getChildren("dependency", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Dependency value = it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("dependency", element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateDependency(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateDeveloper(Counter counter, Element parent, Collection<Developer> list) {
        boolean shouldExist = list != null && !list.isEmpty();
        Element element = this.updateElement(counter, parent, "developers", shouldExist);
        if (shouldExist) {
            Iterator<Developer> it = list.iterator();
            Iterator<Element> elIt = element.getChildren("developer", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Developer value = it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("developer", element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateDeveloper(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateExclusion(Counter counter, Element parent, Collection<Exclusion> list) {
        boolean shouldExist = list != null && !list.isEmpty();
        Element element = this.updateElement(counter, parent, "exclusions", shouldExist);
        if (shouldExist) {
            Iterator<Exclusion> it = list.iterator();
            Iterator<Element> elIt = element.getChildren("exclusion", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Exclusion value = it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("exclusion", element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateExclusion(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateExtension(Counter counter, Element parent, Collection<Extension> list) {
        boolean shouldExist = list != null && !list.isEmpty();
        Element element = this.updateElement(counter, parent, "extensions", shouldExist);
        if (shouldExist) {
            Iterator<Extension> it = list.iterator();
            Iterator<Element> elIt = element.getChildren("extension", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Extension value = it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("extension", element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateExtension(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateLicense(Counter counter, Element parent, Collection<License> list) {
        boolean shouldExist = list != null && !list.isEmpty();
        Element element = this.updateElement(counter, parent, "licenses", shouldExist);
        if (shouldExist) {
            Iterator<License> it = list.iterator();
            Iterator<Element> elIt = element.getChildren("license", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                License value = it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("license", element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateLicense(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateMailingList(Counter counter, Element parent, Collection<MailingList> list) {
        boolean shouldExist = list != null && !list.isEmpty();
        Element element = this.updateElement(counter, parent, "mailingLists", shouldExist);
        if (shouldExist) {
            Iterator<MailingList> it = list.iterator();
            Iterator<Element> elIt = element.getChildren("mailingList", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                MailingList value = it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("mailingList", element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateMailingList(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateNotifier(Counter counter, Element parent, Collection<Notifier> list) {
        boolean shouldExist = list != null && !list.isEmpty();
        Element element = this.updateElement(counter, parent, "notifiers", shouldExist);
        if (shouldExist) {
            Iterator<Notifier> it = list.iterator();
            Iterator<Element> elIt = element.getChildren("notifier", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Notifier value = it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("notifier", element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateNotifier(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iteratePlugin(Counter counter, Element parent, Collection<Plugin> list) {
        boolean shouldExist = list != null && !list.isEmpty();
        Element element = this.updateElement(counter, parent, "plugins", shouldExist);
        if (shouldExist) {
            Iterator<Plugin> it = list.iterator();
            Iterator<Element> elIt = element.getChildren("plugin", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Plugin value = it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("plugin", element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updatePlugin(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iteratePluginExecution(Counter counter, Element parent, Collection<PluginExecution> list) {
        boolean shouldExist = list != null && !list.isEmpty();
        Element element = this.updateElement(counter, parent, "executions", shouldExist);
        if (shouldExist) {
            Iterator<PluginExecution> it = list.iterator();
            Iterator<Element> elIt = element.getChildren("execution", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                PluginExecution value = it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("execution", element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updatePluginExecution(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateProfile(Counter counter, Element parent, Collection<Profile> list) {
        boolean shouldExist = list != null && !list.isEmpty();
        Element element = this.updateElement(counter, parent, "profiles", shouldExist);
        if (shouldExist) {
            Iterator<Profile> it = list.iterator();
            Iterator<Element> elIt = element.getChildren("profile", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Profile value = it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("profile", element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateProfile(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateReportPlugin(Counter counter, Element parent, Collection<ReportPlugin> list) {
        boolean shouldExist = list != null && !list.isEmpty();
        Element element = this.updateElement(counter, parent, "plugins", shouldExist);
        if (shouldExist) {
            Iterator<ReportPlugin> it = list.iterator();
            Iterator<Element> elIt = element.getChildren("plugin", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                ReportPlugin value = it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("plugin", element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateReportPlugin(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateReportSet(Counter counter, Element parent, Collection<ReportSet> list) {
        boolean shouldExist = list != null && !list.isEmpty();
        Element element = this.updateElement(counter, parent, "reportSets", shouldExist);
        if (shouldExist) {
            Iterator<ReportSet> it = list.iterator();
            Iterator<Element> elIt = element.getChildren("reportSet", element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                ReportSet value = it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element("reportSet", element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateReportSet(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateRepository(Counter counter, Element parent, Collection<Repository> list, String parentTag, String childTag) {
        boolean shouldExist = list != null && !list.isEmpty();
        Element element = this.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator<Repository> it = list.iterator();
            Iterator<Element> elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Repository value = it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateRepository(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void iterateResource(Counter counter, Element parent, Collection<Resource> list, String parentTag, String childTag) {
        boolean shouldExist = list != null && !list.isEmpty();
        Element element = this.updateElement(counter, parent, parentTag, shouldExist);
        if (shouldExist) {
            Iterator<Resource> it = list.iterator();
            Iterator<Element> elIt = element.getChildren(childTag, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            Counter innerCount = new Counter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                Resource value = it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = this.factory.element(childTag, element.getNamespace());
                    this.insertAtPreferredLocation(element, el, innerCount);
                }
                this.updateResource(value, innerCount, el);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
    }

    protected void replaceXpp3DOM(Element parent, Xpp3Dom parentDom, Counter counter) {
        if (parentDom.getChildCount() > 0) {
            Xpp3Dom[] children = parentDom.getChildren();
            ArrayList<Xpp3Dom> domChildren = new ArrayList<Xpp3Dom>(Arrays.asList(children));
            ListIterator<Element> it = parent.getChildren().listIterator();
            while (it.hasNext()) {
                Element elem = it.next();
                Iterator it2 = domChildren.iterator();
                Xpp3Dom corrDom = null;
                while (it2.hasNext()) {
                    Xpp3Dom dm = (Xpp3Dom)it2.next();
                    if (!dm.getName().equals(elem.getName())) continue;
                    corrDom = dm;
                    break;
                }
                if (corrDom != null) {
                    domChildren.remove(corrDom);
                    this.replaceXpp3DOM(elem, corrDom, new Counter(counter.getDepth() + 1));
                    counter.increaseCount();
                    continue;
                }
                it.remove();
            }
            for (Xpp3Dom dm : domChildren) {
                Element elem = this.factory.element(dm.getName(), parent.getNamespace());
                for (String attName : dm.getAttributeNames()) {
                    elem.setAttribute(attName, dm.getAttribute(attName));
                }
                this.insertAtPreferredLocation(parent, elem, counter);
                counter.increaseCount();
                this.replaceXpp3DOM(elem, dm, new Counter(counter.getDepth() + 1));
            }
        } else if (parentDom.getValue() != null) {
            parent.setText(parentDom.getValue());
        }
    }

    protected void updateActivation(Activation value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "activation", shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "activeByDefault", !value.isActiveByDefault() ? null : String.valueOf(value.isActiveByDefault()), "false");
            this.findAndReplaceSimpleElement(innerCount, root, "jdk", value.getJdk(), null);
            this.updateActivationOS(value.getOs(), innerCount, root);
            this.updateActivationProperty(value.getProperty(), innerCount, root);
            this.updateActivationFile(value.getFile(), innerCount, root);
        }
    }

    protected void updateActivationFile(ActivationFile value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "file", shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "missing", value.getMissing(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "exists", value.getExists(), null);
        }
    }

    protected void updateActivationOS(ActivationOS value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "os", shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "family", value.getFamily(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "arch", value.getArch(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "version", value.getVersion(), null);
        }
    }

    protected void updateActivationProperty(ActivationProperty value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "property", shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "value", value.getValue(), null);
        }
    }

    protected void updateBuild(Build value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "build", shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "sourceDirectory", value.getSourceDirectory(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "scriptSourceDirectory", value.getScriptSourceDirectory(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "testSourceDirectory", value.getTestSourceDirectory(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "outputDirectory", value.getOutputDirectory(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "testOutputDirectory", value.getTestOutputDirectory(), null);
            this.iterateExtension(innerCount, root, value.getExtensions());
            this.findAndReplaceSimpleElement(innerCount, root, "defaultGoal", value.getDefaultGoal(), null);
            this.iterateResource(innerCount, root, value.getResources(), "resources", "resource");
            this.iterateResource(innerCount, root, value.getTestResources(), "testResources", "testResource");
            this.findAndReplaceSimpleElement(innerCount, root, "directory", value.getDirectory(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "finalName", value.getFinalName(), null);
            this.findAndReplaceSimpleLists(innerCount, root, value.getFilters(), "filters", "filter");
            this.updatePluginManagement(value.getPluginManagement(), innerCount, root);
            this.iteratePlugin(innerCount, root, value.getPlugins());
        }
    }

    protected void updateBuildBase(BuildBase value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "build", shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "defaultGoal", value.getDefaultGoal(), null);
            this.iterateResource(innerCount, root, value.getResources(), "resources", "resource");
            this.iterateResource(innerCount, root, value.getTestResources(), "testResources", "testResource");
            this.findAndReplaceSimpleElement(innerCount, root, "directory", value.getDirectory(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "finalName", value.getFinalName(), null);
            this.findAndReplaceSimpleLists(innerCount, root, value.getFilters(), "filters", "filter");
            this.updatePluginManagement(value.getPluginManagement(), innerCount, root);
            this.iteratePlugin(innerCount, root, value.getPlugins());
        }
    }

    protected void updateCiManagement(CiManagement value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "ciManagement", shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "system", value.getSystem(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null);
            this.iterateNotifier(innerCount, root, value.getNotifiers());
        }
    }

    protected void updateConfigurationContainer(ConfigurationContainer value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "inherited", value.getInherited(), null);
            this.findAndReplaceXpp3DOM(innerCount, root, "configuration", (Xpp3Dom)value.getConfiguration());
        }
    }

    protected void updateContributor(Contributor value, Counter counter, Element root) {
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "email", value.getEmail(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "organization", value.getOrganization(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "organizationUrl", value.getOrganizationUrl(), null);
        this.findAndReplaceSimpleLists(innerCount, root, value.getRoles(), "roles", "role");
        this.findAndReplaceSimpleElement(innerCount, root, "timezone", value.getTimezone(), null);
        this.findAndReplaceProperties(innerCount, root, "properties", value.getProperties());
    }

    protected void updateDependency(Dependency value, Counter counter, Element root) {
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(innerCount, root, "groupId", value.getGroupId(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "artifactId", value.getArtifactId(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "version", value.getVersion(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "type", value.getType(), "jar");
        this.findAndReplaceSimpleElement(innerCount, root, "classifier", value.getClassifier(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "scope", value.getScope(), "compile");
        this.findAndReplaceSimpleElement(innerCount, root, "systemPath", value.getSystemPath(), null);
        this.iterateExclusion(innerCount, root, value.getExclusions());
        this.findAndReplaceSimpleElement(innerCount, root, "optional", !value.isOptional() ? null : String.valueOf(value.isOptional()), "false");
    }

    protected void updateDependencyManagement(DependencyManagement value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "dependencyManagement", shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.iterateDependency(innerCount, root, value.getDependencies());
        }
    }

    protected void updateDeploymentRepository(DeploymentRepository value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.updateRepositoryPolicy(value.getReleases(), "releases", innerCount, root);
            this.updateRepositoryPolicy(value.getSnapshots(), "snapshots", innerCount, root);
            this.findAndReplaceSimpleElement(innerCount, root, "uniqueVersion", value.isUniqueVersion() ? null : String.valueOf(value.isUniqueVersion()), "true");
            this.findAndReplaceSimpleElement(innerCount, root, "id", value.getId(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "layout", value.getLayout(), "default");
        }
    }

    protected void updateDeveloper(Developer value, Counter counter, Element root) {
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(innerCount, root, "id", value.getId(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "email", value.getEmail(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "organization", value.getOrganization(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "organizationUrl", value.getOrganizationUrl(), null);
        this.findAndReplaceSimpleLists(innerCount, root, value.getRoles(), "roles", "role");
        this.findAndReplaceSimpleElement(innerCount, root, "timezone", value.getTimezone(), null);
        this.findAndReplaceProperties(innerCount, root, "properties", value.getProperties());
    }

    protected void updateDistributionManagement(DistributionManagement value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "distributionManagement", shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.updateDeploymentRepository(value.getRepository(), "repository", innerCount, root);
            this.updateDeploymentRepository(value.getSnapshotRepository(), "snapshotRepository", innerCount, root);
            this.updateSite(value.getSite(), innerCount, root);
            this.findAndReplaceSimpleElement(innerCount, root, "downloadUrl", value.getDownloadUrl(), null);
            this.updateRelocation(value.getRelocation(), innerCount, root);
            this.findAndReplaceSimpleElement(innerCount, root, "status", value.getStatus(), null);
        }
    }

    protected Element updateElement(Counter counter, Element parent, String name, boolean shouldExist) {
        Element element = parent.getChild(name, parent.getNamespace());
        if (element != null && shouldExist) {
            counter.increaseCount();
        }
        if (element == null && shouldExist) {
            element = this.factory.element(name, parent.getNamespace());
            this.insertAtPreferredLocation(parent, element, counter);
            counter.increaseCount();
        }
        if (!shouldExist && element != null) {
            Text txt;
            Content previous;
            int index = parent.indexOf(element);
            if (index > 0 && (previous = parent.getContent(index - 1)) instanceof Text && (txt = (Text)previous).getTextTrim().isEmpty()) {
                parent.removeContent(txt);
            }
            parent.removeContent(element);
        }
        return element;
    }

    protected void updateExclusion(Exclusion value, Counter counter, Element root) {
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(innerCount, root, "groupId", value.getGroupId(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "artifactId", value.getArtifactId(), null);
    }

    protected void updateExtension(Extension value, Counter counter, Element root) {
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(innerCount, root, "groupId", value.getGroupId(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "artifactId", value.getArtifactId(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "version", value.getVersion(), null);
    }

    protected void updateFileSet(FileSet value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "directory", value.getDirectory(), null);
            this.findAndReplaceSimpleLists(innerCount, root, value.getIncludes(), "includes", "include");
            this.findAndReplaceSimpleLists(innerCount, root, value.getExcludes(), "excludes", "exclude");
        }
    }

    protected void updateIssueManagement(IssueManagement value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "issueManagement", shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "system", value.getSystem(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null);
        }
    }

    protected void updateLicense(License value, Counter counter, Element root) {
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "distribution", value.getDistribution(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "comments", value.getComments(), null);
    }

    protected void updateMailingList(MailingList value, Counter counter, Element root) {
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "subscribe", value.getSubscribe(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "unsubscribe", value.getUnsubscribe(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "post", value.getPost(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "archive", value.getArchive(), null);
        this.findAndReplaceSimpleLists(innerCount, root, value.getOtherArchives(), "otherArchives", "otherArchive");
    }

    protected void updateModel(Model value, Counter counter, Element root) {
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(innerCount, root, "modelVersion", value.getModelVersion(), null);
        this.updateParent(value.getParent(), innerCount, root);
        this.findAndReplaceSimpleElement(innerCount, root, "groupId", value.getGroupId(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "artifactId", value.getArtifactId(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "version", value.getVersion(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "packaging", value.getPackaging(), "jar");
        this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "description", value.getDescription(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "inceptionYear", value.getInceptionYear(), null);
        this.updateOrganization(value.getOrganization(), innerCount, root);
        this.iterateLicense(innerCount, root, value.getLicenses());
        this.iterateDeveloper(innerCount, root, value.getDevelopers());
        this.iterateContributor(innerCount, root, value.getContributors());
        this.iterateMailingList(innerCount, root, value.getMailingLists());
        this.updatePrerequisites(value.getPrerequisites(), innerCount, root);
        this.findAndReplaceSimpleLists(innerCount, root, value.getModules(), "modules", "module");
        this.updateScm(value.getScm(), innerCount, root);
        this.updateIssueManagement(value.getIssueManagement(), innerCount, root);
        this.updateCiManagement(value.getCiManagement(), innerCount, root);
        this.updateDistributionManagement(value.getDistributionManagement(), innerCount, root);
        this.findAndReplaceProperties(innerCount, root, "properties", value.getProperties());
        this.updateDependencyManagement(value.getDependencyManagement(), innerCount, root);
        this.iterateDependency(innerCount, root, value.getDependencies());
        this.iterateRepository(innerCount, root, value.getRepositories(), "repositories", "repository");
        this.iterateRepository(innerCount, root, value.getPluginRepositories(), "pluginRepositories", "pluginRepository");
        this.updateBuild(value.getBuild(), innerCount, root);
        this.findAndReplaceXpp3DOM(innerCount, root, "reports", (Xpp3Dom)value.getReports());
        this.updateReporting(value.getReporting(), innerCount, root);
        this.iterateProfile(innerCount, root, value.getProfiles());
    }

    protected void updateModelBase(ModelBase value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleLists(innerCount, root, value.getModules(), "modules", "module");
            this.iterateRepository(innerCount, root, value.getRepositories(), "repositories", "repository");
            this.iterateRepository(innerCount, root, value.getPluginRepositories(), "pluginRepositories", "pluginRepository");
            this.iterateDependency(innerCount, root, value.getDependencies());
            this.findAndReplaceXpp3DOM(innerCount, root, "reports", (Xpp3Dom)value.getReports());
            this.updateReporting(value.getReporting(), innerCount, root);
            this.updateDependencyManagement(value.getDependencyManagement(), innerCount, root);
            this.updateDistributionManagement(value.getDistributionManagement(), innerCount, root);
            this.findAndReplaceProperties(innerCount, root, "properties", value.getProperties());
        }
    }

    protected void updateNotifier(Notifier value, Counter counter, Element root) {
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(innerCount, root, "type", value.getType(), "mail");
        this.findAndReplaceSimpleElement(innerCount, root, "sendOnError", value.isSendOnError() ? null : String.valueOf(value.isSendOnError()), "true");
        this.findAndReplaceSimpleElement(innerCount, root, "sendOnFailure", value.isSendOnFailure() ? null : String.valueOf(value.isSendOnFailure()), "true");
        this.findAndReplaceSimpleElement(innerCount, root, "sendOnSuccess", value.isSendOnSuccess() ? null : String.valueOf(value.isSendOnSuccess()), "true");
        this.findAndReplaceSimpleElement(innerCount, root, "sendOnWarning", value.isSendOnWarning() ? null : String.valueOf(value.isSendOnWarning()), "true");
        this.findAndReplaceSimpleElement(innerCount, root, "address", value.getAddress(), null);
        this.findAndReplaceProperties(innerCount, root, "configuration", value.getConfiguration());
    }

    protected void updateOrganization(Organization value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "organization", shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null);
        }
    }

    protected void updateParent(Parent value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "parent", shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "groupId", value.getGroupId(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "artifactId", value.getArtifactId(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "version", value.getVersion(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "relativePath", value.getRelativePath(), "../pom.xml");
        }
    }

    protected void updatePatternSet(PatternSet value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleLists(innerCount, root, value.getIncludes(), "includes", "include");
            this.findAndReplaceSimpleLists(innerCount, root, value.getExcludes(), "excludes", "exclude");
        }
    }

    protected void updatePlugin(Plugin value, Counter counter, Element root) {
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(innerCount, root, "groupId", value.getGroupId(), "org.apache.maven.plugins");
        this.findAndReplaceSimpleElement(innerCount, root, "artifactId", value.getArtifactId(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "version", value.getVersion(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "extensions", !value.isExtensions() ? null : String.valueOf(value.isExtensions()), "false");
        this.iteratePluginExecution(innerCount, root, value.getExecutions());
        this.iterateDependency(innerCount, root, value.getDependencies());
        this.findAndReplaceXpp3DOM(innerCount, root, "goals", (Xpp3Dom)value.getGoals());
        this.findAndReplaceSimpleElement(innerCount, root, "inherited", value.getInherited(), null);
        this.findAndReplaceXpp3DOM(innerCount, root, "configuration", (Xpp3Dom)value.getConfiguration());
    }

    protected void updatePluginConfiguration(PluginConfiguration value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.updatePluginManagement(value.getPluginManagement(), innerCount, root);
            this.iteratePlugin(innerCount, root, value.getPlugins());
        }
    }

    protected void updatePluginContainer(PluginContainer value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.iteratePlugin(innerCount, root, value.getPlugins());
        }
    }

    protected void updatePluginExecution(PluginExecution value, Counter counter, Element root) {
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(innerCount, root, "id", value.getId(), "default");
        this.findAndReplaceSimpleElement(innerCount, root, "phase", value.getPhase(), null);
        this.findAndReplaceSimpleLists(innerCount, root, value.getGoals(), "goals", "goal");
        this.findAndReplaceSimpleElement(innerCount, root, "inherited", value.getInherited(), null);
        this.findAndReplaceXpp3DOM(innerCount, root, "configuration", (Xpp3Dom)value.getConfiguration());
    }

    protected void updatePluginManagement(PluginManagement value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "pluginManagement", shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.iteratePlugin(innerCount, root, value.getPlugins());
        }
    }

    protected void updatePrerequisites(Prerequisites value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "prerequisites", shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "maven", value.getMaven(), "2.0");
        }
    }

    protected void updateProfile(Profile value, Counter counter, Element root) {
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(innerCount, root, "id", value.getId(), null);
        this.updateActivation(value.getActivation(), innerCount, root);
        this.updateBuildBase(value.getBuild(), innerCount, root);
        this.findAndReplaceSimpleLists(innerCount, root, value.getModules(), "modules", "module");
        this.updateDistributionManagement(value.getDistributionManagement(), innerCount, root);
        this.findAndReplaceProperties(innerCount, root, "properties", value.getProperties());
        this.updateDependencyManagement(value.getDependencyManagement(), innerCount, root);
        this.iterateDependency(innerCount, root, value.getDependencies());
        this.iterateRepository(innerCount, root, value.getRepositories(), "repositories", "repository");
        this.iterateRepository(innerCount, root, value.getPluginRepositories(), "pluginRepositories", "pluginRepository");
        this.findAndReplaceXpp3DOM(innerCount, root, "reports", (Xpp3Dom)value.getReports());
        this.updateReporting(value.getReporting(), innerCount, root);
    }

    protected void updateRelocation(Relocation value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "relocation", shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "groupId", value.getGroupId(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "artifactId", value.getArtifactId(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "version", value.getVersion(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "message", value.getMessage(), null);
        }
    }

    protected void updateReporting(Reporting value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "reporting", shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "excludeDefaults", !value.isExcludeDefaults() ? null : String.valueOf(value.isExcludeDefaults()), "false");
            this.findAndReplaceSimpleElement(innerCount, root, "outputDirectory", value.getOutputDirectory(), null);
            this.iterateReportPlugin(innerCount, root, value.getPlugins());
        }
    }

    protected void updateReportPlugin(ReportPlugin value, Counter counter, Element root) {
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(innerCount, root, "groupId", value.getGroupId(), "org.apache.maven.plugins");
        this.findAndReplaceSimpleElement(innerCount, root, "artifactId", value.getArtifactId(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "version", value.getVersion(), null);
        this.iterateReportSet(innerCount, root, value.getReportSets());
        this.findAndReplaceSimpleElement(innerCount, root, "inherited", value.getInherited(), null);
        this.findAndReplaceXpp3DOM(innerCount, root, "configuration", (Xpp3Dom)value.getConfiguration());
    }

    protected void updateReportSet(ReportSet value, Counter counter, Element root) {
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(innerCount, root, "id", value.getId(), "default");
        this.findAndReplaceSimpleLists(innerCount, root, value.getReports(), "reports", "report");
        this.findAndReplaceSimpleElement(innerCount, root, "inherited", value.getInherited(), null);
        this.findAndReplaceXpp3DOM(innerCount, root, "configuration", (Xpp3Dom)value.getConfiguration());
    }

    protected void updateRepository(Repository value, Counter counter, Element root) {
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.updateRepositoryPolicy(value.getReleases(), "releases", innerCount, root);
        this.updateRepositoryPolicy(value.getSnapshots(), "snapshots", innerCount, root);
        this.findAndReplaceSimpleElement(innerCount, root, "id", value.getId(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "layout", value.getLayout(), "default");
    }

    protected void updateRepositoryBase(RepositoryBase value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "id", value.getId(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "layout", value.getLayout(), "default");
        }
    }

    protected void updateRepositoryPolicy(RepositoryPolicy value, String xmlTag, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "enabled", value.isEnabled() ? null : String.valueOf(value.isEnabled()), "true");
            this.findAndReplaceSimpleElement(innerCount, root, "updatePolicy", value.getUpdatePolicy(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "checksumPolicy", value.getChecksumPolicy(), null);
        }
    }

    protected void updateResource(Resource value, Counter counter, Element root) {
        Counter innerCount = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(innerCount, root, "targetPath", value.getTargetPath(), null);
        this.findAndReplaceSimpleElement(innerCount, root, "filtering", !value.isFiltering() ? null : String.valueOf(value.isFiltering()), "false");
        this.findAndReplaceSimpleElement(innerCount, root, "directory", value.getDirectory(), null);
        this.findAndReplaceSimpleLists(innerCount, root, value.getIncludes(), "includes", "include");
        this.findAndReplaceSimpleLists(innerCount, root, value.getExcludes(), "excludes", "exclude");
    }

    protected void updateScm(Scm value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "scm", shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "connection", value.getConnection(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "developerConnection", value.getDeveloperConnection(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "tag", value.getTag(), "HEAD");
            this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null);
        }
    }

    protected void updateSite(Site value, Counter counter, Element element) {
        boolean shouldExist = value != null;
        Element root = this.updateElement(counter, element, "site", shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(innerCount, root, "id", value.getId(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "name", value.getName(), null);
            this.findAndReplaceSimpleElement(innerCount, root, "url", value.getUrl(), null);
        }
    }

    static final class Counter {
        private int currentIndex = 0;
        private final int level;

        public Counter(int depthLevel) {
            this.level = depthLevel;
        }

        public int getCurrentIndex() {
            return this.currentIndex;
        }

        public int getDepth() {
            return this.level;
        }

        public void increaseCount() {
            ++this.currentIndex;
        }

        public void setCurrentIndex(int currentIndex) {
            this.currentIndex = currentIndex;
        }
    }
}

