/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.merge;

import io.fabric8.maven.merge.SortedProperties;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Profile;
import org.apache.maven.model.merge.ModelMerger;

public class SmartModelMerger
extends ModelMerger {
    @Override
    protected Object getDependencyKey(Dependency dependency) {
        return dependency.getGroupId() + ":" + dependency.getArtifactId();
    }

    @Override
    protected void mergeModelBase_Properties(ModelBase target, ModelBase source, boolean sourceDominant, Map<Object, Object> context) {
        SortedProperties merged = new SortedProperties();
        if (sourceDominant) {
            merged.putAll((Map<?, ?>)target.getProperties());
            merged.putAll((Map<?, ?>)source.getProperties());
        } else {
            merged.putAll((Map<?, ?>)source.getProperties());
            merged.putAll((Map<?, ?>)target.getProperties());
        }
        target.setProperties(merged);
        target.setLocation("properties", InputLocation.merge(target.getLocation("properties"), source.getLocation("properties"), sourceDominant));
    }

    @Override
    protected Object getProfileKey(Profile profile) {
        return profile.getId();
    }

    @Override
    protected void mergeModelBase_Modules(ModelBase target, ModelBase source, boolean sourceDominant, Map<Object, Object> context) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.addAll(source.getModules());
        set.addAll(target.getModules());
        target.setModules(new ArrayList<String>(set));
    }

    @Override
    protected void mergeModel_Profiles(Model target, Model source, boolean sourceDominant, Map<Object, Object> context) {
        List<Profile> src = source.getProfiles();
        if (!src.isEmpty()) {
            Object key;
            List<Profile> tgt = target.getProfiles();
            LinkedHashMap<Object, Profile> merged = new LinkedHashMap<Object, Profile>((src.size() + tgt.size()) * 2);
            for (Profile element : tgt) {
                key = this.getProfileKey(element);
                merged.put(key, element);
            }
            for (Profile element : src) {
                key = this.getProfileKey(element);
                if (!sourceDominant && merged.containsKey(key)) continue;
                Profile targetProfile = (Profile)merged.get(key);
                if (targetProfile != null) {
                    this.mergeProfile(targetProfile, element, sourceDominant, context);
                    merged.put(key, targetProfile);
                    continue;
                }
                merged.put(key, element);
            }
            target.setProfiles(new ArrayList<Profile>(merged.values()));
        }
    }
}

