/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.template;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.ContainerManifestFluent;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.KubernetesListFluent;
import io.fabric8.kubernetes.api.model.PodStateFluent;
import io.fabric8.kubernetes.api.model.PodTemplateFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerStateFluent;
import io.fabric8.kubernetes.template.GenerateDTO;
import io.fabric8.utils.Files;
import io.fabric8.utils.Objects;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;

public class TemplateGenerator {
    private final GenerateDTO config;

    public TemplateGenerator(GenerateDTO config) {
        this.config = config;
    }

    public void generate(File kubernetesJson) throws IllegalArgumentException {
        String dockerImage = this.config.getDockerImage();
        String name = this.config.getName();
        Map<String, String> labels = this.config.getLabels();
        String replicationControllerName = KubernetesHelper.validateKubernetesId((String)this.config.getReplicationControllerName(), (String)"replicationControllerName");
        String serviceName = this.config.getServiceName();
        if (Strings.isNotBlank((String)serviceName)) {
            serviceName = KubernetesHelper.validateKubernetesId((String)serviceName, (String)"serviceName");
        }
        if (Strings.notEmpty((String)serviceName) && Objects.equal((Object)serviceName, (Object)replicationControllerName)) {
            throw new IllegalArgumentException("replicationControllerName and serviceName are the same! (" + serviceName + ")");
        }
        KubernetesListBuilder builder = (KubernetesListBuilder)((KubernetesListFluent.ReplicationControllersNested)((KubernetesListFluent.ReplicationControllersNested)((ReplicationControllerFluent.DesiredStateNested)((ReplicationControllerStateFluent.PodTemplateNested)((PodTemplateFluent.DesiredStateNested)((PodStateFluent.ManifestNested)((ContainerManifestFluent.ContainersNested)((ContainerManifestFluent.ContainersNested)((ContainerManifestFluent.ContainersNested)((ContainerManifestFluent.ContainersNested)((ReplicationControllerFluent.DesiredStateNested)((ReplicationControllerFluent.DesiredStateNested)((KubernetesListFluent.ReplicationControllersNested)((KubernetesListFluent.ReplicationControllersNested)((KubernetesListBuilder)((KubernetesListBuilder)new KubernetesListBuilder().withKind("Config")).withId(name)).addNewReplicationController().withKind("ReplicationController")).withId(replicationControllerName)).withNewDesiredState().withReplicas(this.config.getReplicaCount())).withReplicaSelector(this.config.getLabels())).withNewPodTemplate().withNewDesiredState().withNewManifest().addNewContainer().withName(this.config.getContainerName())).withImage(dockerImage)).withImagePullPolicy(this.config.getImagePullPolicy())).withEnv(this.config.getEnvironmentVariables())).endContainer()).endManifest()).endDesiredState()).endPodTemplate()).endDesiredState()).withLabels(labels)).endReplicationController();
        if (serviceName != null) {
            builder = (KubernetesListBuilder)((KubernetesListFluent.ServicesNested)((KubernetesListFluent.ServicesNested)((KubernetesListFluent.ServicesNested)((KubernetesListFluent.ServicesNested)((KubernetesListFluent.ServicesNested)builder.addNewService().withId(serviceName)).withKind("Service")).withContainerPort(this.config.getServiceContainerPort())).withPort(this.config.getServicePort())).withSelector(labels)).endService();
        }
        KubernetesList kubernetesList = builder.build();
        try {
            ObjectMapper mapper = new ObjectMapper();
            String generated = mapper.writeValueAsString((Object)kubernetesList);
            Files.writeToFile((File)kubernetesJson, (String)generated, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to generate Kubernetes JSON.", e);
        }
    }
}

