/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.template;

import io.fabric8.utils.Closeables;
import io.fabric8.utils.Strings;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;

public class Apps {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse postFileToGit(File file, String user, String password, String consoleUrl, String branch, String path, Logger logger) throws URISyntaxException, IOException {
        HttpClientBuilder builder = HttpClients.custom();
        if (Strings.isNotBlank((String)user) && Strings.isNotBlank((String)password)) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope("localhost", 443), (Credentials)new UsernamePasswordCredentials(user, password));
            builder = builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        }
        CloseableHttpClient client = builder.build();
        try {
            int statusCode;
            String url = consoleUrl;
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            url = url + "git/";
            url = url + branch;
            if (!path.startsWith("/")) {
                url = url + "/";
            }
            url = url + path;
            logger.info("Posting App Zip " + file.getName() + " to " + url);
            URI buildUrl = new URI(url);
            HttpPost post = new HttpPost(buildUrl);
            FileBody zip = new FileBody(file);
            HttpEntity entity = MultipartEntityBuilder.create().addPart(file.getName(), (ContentBody)zip).build();
            post.setEntity(entity);
            CloseableHttpResponse response = client.execute(URIUtils.extractHost((URI)buildUrl), (HttpRequest)post);
            logger.info("Response: " + response);
            if (response != null && ((statusCode = response.getStatusLine().getStatusCode()) < 200 || statusCode >= 300)) {
                throw new IllegalStateException("Failed to post App Zip to: " + url + " " + response);
            }
            CloseableHttpResponse closeableHttpResponse = response;
            return closeableHttpResponse;
        }
        finally {
            Closeables.closeQuietly((Closeable)client);
        }
    }
}

