/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v6_9.dsl.internal.apps;

import io.fabric8.kubernetes.api.model.v6_9.autoscaling.v1.Scale;
import io.fabric8.kubernetes.clnt.v6_9.Client;
import io.fabric8.kubernetes.clnt.v6_9.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v6_9.OperationInfo;
import io.fabric8.kubernetes.clnt.v6_9.dsl.BytesLimitTerminateTimeTailPrettyLoggable;
import io.fabric8.kubernetes.clnt.v6_9.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v6_9.dsl.Loggable;
import io.fabric8.kubernetes.clnt.v6_9.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v6_9.dsl.PrettyLoggable;
import io.fabric8.kubernetes.clnt.v6_9.dsl.TailPrettyLoggable;
import io.fabric8.kubernetes.clnt.v6_9.dsl.TimeTailPrettyLoggable;
import io.fabric8.kubernetes.clnt.v6_9.dsl.internal.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v6_9.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.clnt.v6_9.dsl.internal.LogWatchCallback;
import io.fabric8.kubernetes.clnt.v6_9.dsl.internal.OperationContext;
import io.fabric8.kubernetes.clnt.v6_9.dsl.internal.PodOperationContext;
import io.fabric8.kubernetes.clnt.v6_9.dsl.internal.extensions.v1beta1.LegacyRollableScalableResourceOperation;
import io.fabric8.kubernetes.clnt.v6_9.utils.URLUtils;
import io.fabric8.kubernetes.clnt.v6_9.utils.internal.PodOperationUtil;
import io.fabric8.openshift.api.model.v6_9.DeploymentConfig;
import io.fabric8.openshift.api.model.v6_9.DeploymentConfigList;
import io.fabric8.openshift.clnt.v6_9.dsl.DeployableScalableResource;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DeploymentConfigOperationsImpl
extends HasMetadataOperation<DeploymentConfig, DeploymentConfigList, DeployableScalableResource<DeploymentConfig>>
implements DeployableScalableResource<DeploymentConfig> {
    public static final String OPENSHIFT_IO_DEPLOYMENT_CONFIG_NAME = "openshift.io/deployment-config.name";
    private final PodOperationContext rollingOperationContext;

    public DeploymentConfigOperationsImpl(Client client) {
        this(new PodOperationContext(), HasMetadataOperationsImpl.defaultContext(client));
    }

    public DeploymentConfigOperationsImpl(PodOperationContext context, OperationContext superContext) {
        super(superContext.withApiGroupName("apps.openshift.io").withPlural("deploymentconfigs"), DeploymentConfig.class, DeploymentConfigList.class);
        this.rollingOperationContext = context;
    }

    @Override
    public DeploymentConfigOperationsImpl newInstance(OperationContext context) {
        return new DeploymentConfigOperationsImpl(this.rollingOperationContext, context);
    }

    @Override
    public Scale scale(Scale scaleParam) {
        return LegacyRollableScalableResourceOperation.scale(scaleParam, this);
    }

    public DeploymentConfig deployLatest(boolean wait) {
        DeploymentConfigOperationsImpl deployable = this;
        if (wait) {
            deployable = this.withTimeoutInMillis(this.getRequestConfig().getScaleTimeout());
        }
        return deployable.deployLatest();
    }

    public DeploymentConfig deployLatest() {
        Long currentVersion = ((DeploymentConfig)this.getItemOrRequireFromServer()).getStatus().getLatestVersion();
        if (currentVersion == null) {
            currentVersion = 1L;
        }
        Long latestVersion = currentVersion + 1L;
        DeploymentConfig deployment = (DeploymentConfig)this.accept(d -> d.getStatus().setLatestVersion(latestVersion));
        if (this.context.getTimeout() > 0L) {
            this.waitUntilScaled(deployment.getSpec().getReplicas());
            deployment = (DeploymentConfig)this.getItemOrRequireFromServer();
        }
        return deployment;
    }

    public String getLog() {
        return this.getLog(this.rollingOperationContext.isPrettyOutput());
    }

    public String getLog(boolean isPretty) {
        return new DeploymentConfigOperationsImpl(this.rollingOperationContext.withPrettyOutput(isPretty), this.context).doGetLog(String.class);
    }

    private <T> T doGetLog(Class<T> type) {
        try {
            URL url = this.getResourceLogUrl(false);
            return this.handleRawGet(url, type);
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("doGetLog"), (Throwable)t);
        }
    }

    public Reader getLogReader() {
        return this.doGetLog(Reader.class);
    }

    public InputStream getLogInputStream() {
        return this.doGetLog(InputStream.class);
    }

    public LogWatch watchLog() {
        return this.watchLog(null);
    }

    public LogWatch watchLog(OutputStream out) {
        try {
            this.waitUntilDeploymentConfigPodBecomesReady((DeploymentConfig)this.get());
            URL url = this.getResourceLogUrl(true);
            LogWatchCallback callback = new LogWatchCallback(out, this.context);
            return callback.callAndWait(this.httpClient, url);
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("watchLog"), (Throwable)t);
        }
    }

    private URL getResourceLogUrl(Boolean follow) throws MalformedURLException {
        if (Boolean.TRUE.equals(follow)) {
            return new URL(URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), this.rollingOperationContext.getLogParameters() + "&follow=true"}));
        }
        return new URL(URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), this.rollingOperationContext.getLogParameters()}));
    }

    public Loggable withLogWaitTimeout(Integer logWaitTimeout) {
        return this.withReadyWaitTimeout(logWaitTimeout);
    }

    public Loggable withReadyWaitTimeout(Integer timeout) {
        return new DeploymentConfigOperationsImpl(this.rollingOperationContext.withReadyWaitTimeout(timeout), this.context);
    }

    private void waitUntilDeploymentConfigPodBecomesReady(DeploymentConfig deploymentConfig) {
        Integer podLogWaitTimeout = this.rollingOperationContext.getReadyWaitTimeout();
        List<PodResource> podOps = PodOperationUtil.getPodOperationsForController(this.context, this.rollingOperationContext, deploymentConfig.getMetadata().getUid(), DeploymentConfigOperationsImpl.getDeploymentConfigPodLabels(deploymentConfig));
        DeploymentConfigOperationsImpl.waitForBuildPodToBecomeReady(podOps, podLogWaitTimeout != null ? podLogWaitTimeout : 5000);
    }

    private static void waitForBuildPodToBecomeReady(List<PodResource> podOps, Integer podLogWaitTimeout) {
        for (PodResource podOp : podOps) {
            PodOperationUtil.waitUntilReadyOrTerminal(podOp, podLogWaitTimeout);
        }
    }

    static Map<String, String> getDeploymentConfigPodLabels(DeploymentConfig deploymentConfig) {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (deploymentConfig != null && deploymentConfig.getMetadata() != null) {
            labels.put(OPENSHIFT_IO_DEPLOYMENT_CONFIG_NAME, deploymentConfig.getMetadata().getName());
        }
        return labels;
    }

    public Loggable inContainer(String id) {
        return new DeploymentConfigOperationsImpl(this.rollingOperationContext.withContainerId(id), this.context);
    }

    public TimeTailPrettyLoggable limitBytes(int limitBytes) {
        return new DeploymentConfigOperationsImpl(this.rollingOperationContext.withLimitBytes(limitBytes), this.context);
    }

    public TimeTailPrettyLoggable terminated() {
        return new DeploymentConfigOperationsImpl(this.rollingOperationContext.withTerminatedStatus(true), this.context);
    }

    public Loggable withPrettyOutput() {
        return new DeploymentConfigOperationsImpl(this.rollingOperationContext.withPrettyOutput(true), this.context);
    }

    public PrettyLoggable tailingLines(int lines) {
        return new DeploymentConfigOperationsImpl(this.rollingOperationContext.withTailingLines(lines), this.context);
    }

    public TailPrettyLoggable sinceTime(String timestamp) {
        return new DeploymentConfigOperationsImpl(this.rollingOperationContext.withSinceTimestamp(timestamp), this.context);
    }

    public TailPrettyLoggable sinceSeconds(int seconds) {
        return new DeploymentConfigOperationsImpl(this.rollingOperationContext.withSinceSeconds(seconds), this.context);
    }

    public BytesLimitTerminateTimeTailPrettyLoggable usingTimestamps() {
        return new DeploymentConfigOperationsImpl(this.rollingOperationContext.withTimestamps(true), this.context);
    }

    @Override
    public DeploymentConfigOperationsImpl withTimeout(long timeout, TimeUnit unit) {
        return new DeploymentConfigOperationsImpl(this.rollingOperationContext, this.context.withTimeout(timeout, unit));
    }

    public DeploymentConfigOperationsImpl withTimeoutInMillis(long timeoutInMillis) {
        return this.withTimeout(timeoutInMillis, TimeUnit.MILLISECONDS);
    }
}

