/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_9.whereabouts.v1alpha1;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.openshift.api.model.v6_9.whereabouts.v1alpha1.IPAllocation;
import io.fabric8.openshift.api.model.v6_9.whereabouts.v1alpha1.IPPoolSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class IPPoolSpecFluent<A extends IPPoolSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, IPAllocation> allocations;
    private String range;
    private Map<String, Object> additionalProperties;

    public IPPoolSpecFluent() {
    }

    public IPPoolSpecFluent(IPPoolSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(IPPoolSpec instance) {
        IPPoolSpec iPPoolSpec = instance = instance != null ? instance : new IPPoolSpec();
        if (instance != null) {
            this.withAllocations(instance.getAllocations());
            this.withRange(instance.getRange());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAllocations(String key, IPAllocation value) {
        if (this.allocations == null && key != null && value != null) {
            this.allocations = new LinkedHashMap<String, IPAllocation>();
        }
        if (key != null && value != null) {
            this.allocations.put(key, value);
        }
        return (A)this;
    }

    public A addToAllocations(Map<String, IPAllocation> map) {
        if (this.allocations == null && map != null) {
            this.allocations = new LinkedHashMap<String, IPAllocation>();
        }
        if (map != null) {
            this.allocations.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAllocations(String key) {
        if (this.allocations == null) {
            return (A)this;
        }
        if (key != null && this.allocations != null) {
            this.allocations.remove(key);
        }
        return (A)this;
    }

    public A removeFromAllocations(Map<String, IPAllocation> map) {
        if (this.allocations == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.allocations == null) continue;
                this.allocations.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, IPAllocation> getAllocations() {
        return this.allocations;
    }

    public <K, V> A withAllocations(Map<String, IPAllocation> allocations) {
        this.allocations = allocations == null ? null : new LinkedHashMap<String, IPAllocation>(allocations);
        return (A)this;
    }

    public boolean hasAllocations() {
        return this.allocations != null;
    }

    public String getRange() {
        return this.range;
    }

    public A withRange(String range) {
        this.range = range;
        return (A)this;
    }

    public boolean hasRange() {
        return this.range != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IPPoolSpecFluent that = (IPPoolSpecFluent)o;
        if (!Objects.equals(this.allocations, that.allocations)) {
            return false;
        }
        if (!Objects.equals(this.range, that.range)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allocations, this.range, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allocations != null && !this.allocations.isEmpty()) {
            sb.append("allocations:");
            sb.append(this.allocations + ",");
        }
        if (this.range != null) {
            sb.append("range:");
            sb.append(this.range + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

