/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_9.tuned.v1;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.openshift.api.model.v6_9.tuned.v1.TunedMatch;
import io.fabric8.openshift.api.model.v6_9.tuned.v1.TunedMatchBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class TunedMatchFluent<A extends TunedMatchFluent<A>>
extends BaseFluent<A> {
    private String label;
    private ArrayList<TunedMatchBuilder> match = new ArrayList();
    private String type;
    private String value;
    private Map<String, Object> additionalProperties;

    public TunedMatchFluent() {
    }

    public TunedMatchFluent(TunedMatch instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(TunedMatch instance) {
        TunedMatch tunedMatch = instance = instance != null ? instance : new TunedMatch();
        if (instance != null) {
            this.withLabel(instance.getLabel());
            this.withMatch(instance.getMatch());
            this.withType(instance.getType());
            this.withValue(instance.getValue());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getLabel() {
        return this.label;
    }

    public A withLabel(String label) {
        this.label = label;
        return (A)this;
    }

    public boolean hasLabel() {
        return this.label != null;
    }

    public A addToMatch(int index, TunedMatch item) {
        if (this.match == null) {
            this.match = new ArrayList();
        }
        TunedMatchBuilder builder = new TunedMatchBuilder(item);
        if (index < 0 || index >= this.match.size()) {
            this._visitables.get("match").add(builder);
            this.match.add(builder);
        } else {
            this._visitables.get("match").add(index, builder);
            this.match.add(index, builder);
        }
        return (A)this;
    }

    public A setToMatch(int index, TunedMatch item) {
        if (this.match == null) {
            this.match = new ArrayList();
        }
        TunedMatchBuilder builder = new TunedMatchBuilder(item);
        if (index < 0 || index >= this.match.size()) {
            this._visitables.get("match").add(builder);
            this.match.add(builder);
        } else {
            this._visitables.get("match").set(index, builder);
            this.match.set(index, builder);
        }
        return (A)this;
    }

    public A addToMatch(TunedMatch ... items) {
        if (this.match == null) {
            this.match = new ArrayList();
        }
        for (TunedMatch item : items) {
            TunedMatchBuilder builder = new TunedMatchBuilder(item);
            this._visitables.get("match").add(builder);
            this.match.add(builder);
        }
        return (A)this;
    }

    public A addAllToMatch(Collection<TunedMatch> items) {
        if (this.match == null) {
            this.match = new ArrayList();
        }
        for (TunedMatch item : items) {
            TunedMatchBuilder builder = new TunedMatchBuilder(item);
            this._visitables.get("match").add(builder);
            this.match.add(builder);
        }
        return (A)this;
    }

    public A removeFromMatch(TunedMatch ... items) {
        if (this.match == null) {
            return (A)this;
        }
        for (TunedMatch item : items) {
            TunedMatchBuilder builder = new TunedMatchBuilder(item);
            this._visitables.get("match").remove(builder);
            this.match.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromMatch(Collection<TunedMatch> items) {
        if (this.match == null) {
            return (A)this;
        }
        for (TunedMatch item : items) {
            TunedMatchBuilder builder = new TunedMatchBuilder(item);
            this._visitables.get("match").remove(builder);
            this.match.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromMatch(Predicate<TunedMatchBuilder> predicate) {
        if (this.match == null) {
            return (A)this;
        }
        Iterator<TunedMatchBuilder> each = this.match.iterator();
        Object visitables = this._visitables.get("match");
        while (each.hasNext()) {
            TunedMatchBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<TunedMatch> buildMatch() {
        return this.match != null ? TunedMatchFluent.build(this.match) : null;
    }

    public TunedMatch buildMatch(int index) {
        return this.match.get(index).build();
    }

    public TunedMatch buildFirstMatch() {
        return this.match.get(0).build();
    }

    public TunedMatch buildLastMatch() {
        return this.match.get(this.match.size() - 1).build();
    }

    public TunedMatch buildMatchingMatch(Predicate<TunedMatchBuilder> predicate) {
        for (TunedMatchBuilder item : this.match) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMatch(Predicate<TunedMatchBuilder> predicate) {
        for (TunedMatchBuilder item : this.match) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMatch(List<TunedMatch> match) {
        if (this.match != null) {
            this._visitables.get("match").clear();
        }
        if (match != null) {
            this.match = new ArrayList();
            for (TunedMatch item : match) {
                this.addToMatch(item);
            }
        } else {
            this.match = null;
        }
        return (A)this;
    }

    public A withMatch(TunedMatch ... match) {
        if (this.match != null) {
            this.match.clear();
            this._visitables.remove("match");
        }
        if (match != null) {
            for (TunedMatch item : match) {
                this.addToMatch(item);
            }
        }
        return (A)this;
    }

    public boolean hasMatch() {
        return this.match != null && !this.match.isEmpty();
    }

    public MatchNested<A> addNewMatch() {
        return new MatchNested(-1, null);
    }

    public MatchNested<A> addNewMatchLike(TunedMatch item) {
        return new MatchNested(-1, item);
    }

    public MatchNested<A> setNewMatchLike(int index, TunedMatch item) {
        return new MatchNested(index, item);
    }

    public MatchNested<A> editMatch(int index) {
        if (this.match.size() <= index) {
            throw new RuntimeException("Can't edit match. Index exceeds size.");
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    public MatchNested<A> editFirstMatch() {
        if (this.match.size() == 0) {
            throw new RuntimeException("Can't edit first match. The list is empty.");
        }
        return this.setNewMatchLike(0, this.buildMatch(0));
    }

    public MatchNested<A> editLastMatch() {
        int index = this.match.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last match. The list is empty.");
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    public MatchNested<A> editMatchingMatch(Predicate<TunedMatchBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.match.size(); ++i) {
            if (!predicate.test(this.match.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching match. No match found.");
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public String getValue() {
        return this.value;
    }

    public A withValue(String value) {
        this.value = value;
        return (A)this;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TunedMatchFluent that = (TunedMatchFluent)o;
        if (!Objects.equals(this.label, that.label)) {
            return false;
        }
        if (!Objects.equals(this.match, that.match)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!Objects.equals(this.value, that.value)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.label, this.match, this.type, this.value, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.label != null) {
            sb.append("label:");
            sb.append(this.label + ",");
        }
        if (this.match != null && !this.match.isEmpty()) {
            sb.append("match:");
            sb.append(this.match + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.value != null) {
            sb.append("value:");
            sb.append(this.value + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MatchNested<N>
    extends TunedMatchFluent<MatchNested<N>>
    implements Nested<N> {
        TunedMatchBuilder builder;
        int index;

        MatchNested(int index, TunedMatch item) {
            this.index = index;
            this.builder = new TunedMatchBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)TunedMatchFluent.this.setToMatch(this.index, this.builder.build());
        }

        public N endMatch() {
            return this.and();
        }
    }
}

