/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_9.operatorhub.lifecyclemanager.v1;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.openshift.api.model.v6_9.operatorhub.lifecyclemanager.v1.AppLink;
import io.fabric8.openshift.api.model.v6_9.operatorhub.lifecyclemanager.v1.AppLinkBuilder;
import io.fabric8.openshift.api.model.v6_9.operatorhub.lifecyclemanager.v1.AppLinkFluent;
import io.fabric8.openshift.api.model.v6_9.operatorhub.lifecyclemanager.v1.PackageChannel;
import io.fabric8.openshift.api.model.v6_9.operatorhub.lifecyclemanager.v1.PackageChannelBuilder;
import io.fabric8.openshift.api.model.v6_9.operatorhub.lifecyclemanager.v1.PackageChannelFluent;
import io.fabric8.openshift.api.model.v6_9.operatorhub.lifecyclemanager.v1.PackageManifestStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PackageManifestStatusFluent<A extends PackageManifestStatusFluent<A>>
extends BaseFluent<A> {
    private String catalogSource;
    private String catalogSourceDisplayName;
    private String catalogSourceNamespace;
    private String catalogSourcePublisher;
    private ArrayList<PackageChannelBuilder> channels = new ArrayList();
    private String defaultChannel;
    private String packageName;
    private AppLinkBuilder provider;
    private Map<String, Object> additionalProperties;

    public PackageManifestStatusFluent() {
    }

    public PackageManifestStatusFluent(PackageManifestStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PackageManifestStatus instance) {
        PackageManifestStatus packageManifestStatus = instance = instance != null ? instance : new PackageManifestStatus();
        if (instance != null) {
            this.withCatalogSource(instance.getCatalogSource());
            this.withCatalogSourceDisplayName(instance.getCatalogSourceDisplayName());
            this.withCatalogSourceNamespace(instance.getCatalogSourceNamespace());
            this.withCatalogSourcePublisher(instance.getCatalogSourcePublisher());
            this.withChannels(instance.getChannels());
            this.withDefaultChannel(instance.getDefaultChannel());
            this.withPackageName(instance.getPackageName());
            this.withProvider(instance.getProvider());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getCatalogSource() {
        return this.catalogSource;
    }

    public A withCatalogSource(String catalogSource) {
        this.catalogSource = catalogSource;
        return (A)this;
    }

    public boolean hasCatalogSource() {
        return this.catalogSource != null;
    }

    public String getCatalogSourceDisplayName() {
        return this.catalogSourceDisplayName;
    }

    public A withCatalogSourceDisplayName(String catalogSourceDisplayName) {
        this.catalogSourceDisplayName = catalogSourceDisplayName;
        return (A)this;
    }

    public boolean hasCatalogSourceDisplayName() {
        return this.catalogSourceDisplayName != null;
    }

    public String getCatalogSourceNamespace() {
        return this.catalogSourceNamespace;
    }

    public A withCatalogSourceNamespace(String catalogSourceNamespace) {
        this.catalogSourceNamespace = catalogSourceNamespace;
        return (A)this;
    }

    public boolean hasCatalogSourceNamespace() {
        return this.catalogSourceNamespace != null;
    }

    public String getCatalogSourcePublisher() {
        return this.catalogSourcePublisher;
    }

    public A withCatalogSourcePublisher(String catalogSourcePublisher) {
        this.catalogSourcePublisher = catalogSourcePublisher;
        return (A)this;
    }

    public boolean hasCatalogSourcePublisher() {
        return this.catalogSourcePublisher != null;
    }

    public A addToChannels(int index, PackageChannel item) {
        if (this.channels == null) {
            this.channels = new ArrayList();
        }
        PackageChannelBuilder builder = new PackageChannelBuilder(item);
        if (index < 0 || index >= this.channels.size()) {
            this._visitables.get("channels").add(builder);
            this.channels.add(builder);
        } else {
            this._visitables.get("channels").add(index, builder);
            this.channels.add(index, builder);
        }
        return (A)this;
    }

    public A setToChannels(int index, PackageChannel item) {
        if (this.channels == null) {
            this.channels = new ArrayList();
        }
        PackageChannelBuilder builder = new PackageChannelBuilder(item);
        if (index < 0 || index >= this.channels.size()) {
            this._visitables.get("channels").add(builder);
            this.channels.add(builder);
        } else {
            this._visitables.get("channels").set(index, builder);
            this.channels.set(index, builder);
        }
        return (A)this;
    }

    public A addToChannels(PackageChannel ... items) {
        if (this.channels == null) {
            this.channels = new ArrayList();
        }
        for (PackageChannel item : items) {
            PackageChannelBuilder builder = new PackageChannelBuilder(item);
            this._visitables.get("channels").add(builder);
            this.channels.add(builder);
        }
        return (A)this;
    }

    public A addAllToChannels(Collection<PackageChannel> items) {
        if (this.channels == null) {
            this.channels = new ArrayList();
        }
        for (PackageChannel item : items) {
            PackageChannelBuilder builder = new PackageChannelBuilder(item);
            this._visitables.get("channels").add(builder);
            this.channels.add(builder);
        }
        return (A)this;
    }

    public A removeFromChannels(PackageChannel ... items) {
        if (this.channels == null) {
            return (A)this;
        }
        for (PackageChannel item : items) {
            PackageChannelBuilder builder = new PackageChannelBuilder(item);
            this._visitables.get("channels").remove(builder);
            this.channels.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromChannels(Collection<PackageChannel> items) {
        if (this.channels == null) {
            return (A)this;
        }
        for (PackageChannel item : items) {
            PackageChannelBuilder builder = new PackageChannelBuilder(item);
            this._visitables.get("channels").remove(builder);
            this.channels.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromChannels(Predicate<PackageChannelBuilder> predicate) {
        if (this.channels == null) {
            return (A)this;
        }
        Iterator<PackageChannelBuilder> each = this.channels.iterator();
        Object visitables = this._visitables.get("channels");
        while (each.hasNext()) {
            PackageChannelBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<PackageChannel> buildChannels() {
        return this.channels != null ? PackageManifestStatusFluent.build(this.channels) : null;
    }

    public PackageChannel buildChannel(int index) {
        return this.channels.get(index).build();
    }

    public PackageChannel buildFirstChannel() {
        return this.channels.get(0).build();
    }

    public PackageChannel buildLastChannel() {
        return this.channels.get(this.channels.size() - 1).build();
    }

    public PackageChannel buildMatchingChannel(Predicate<PackageChannelBuilder> predicate) {
        for (PackageChannelBuilder item : this.channels) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingChannel(Predicate<PackageChannelBuilder> predicate) {
        for (PackageChannelBuilder item : this.channels) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withChannels(List<PackageChannel> channels) {
        if (this.channels != null) {
            this._visitables.get("channels").clear();
        }
        if (channels != null) {
            this.channels = new ArrayList();
            for (PackageChannel item : channels) {
                this.addToChannels(item);
            }
        } else {
            this.channels = null;
        }
        return (A)this;
    }

    public A withChannels(PackageChannel ... channels) {
        if (this.channels != null) {
            this.channels.clear();
            this._visitables.remove("channels");
        }
        if (channels != null) {
            for (PackageChannel item : channels) {
                this.addToChannels(item);
            }
        }
        return (A)this;
    }

    public boolean hasChannels() {
        return this.channels != null && !this.channels.isEmpty();
    }

    public ChannelsNested<A> addNewChannel() {
        return new ChannelsNested(-1, null);
    }

    public ChannelsNested<A> addNewChannelLike(PackageChannel item) {
        return new ChannelsNested(-1, item);
    }

    public ChannelsNested<A> setNewChannelLike(int index, PackageChannel item) {
        return new ChannelsNested(index, item);
    }

    public ChannelsNested<A> editChannel(int index) {
        if (this.channels.size() <= index) {
            throw new RuntimeException("Can't edit channels. Index exceeds size.");
        }
        return this.setNewChannelLike(index, this.buildChannel(index));
    }

    public ChannelsNested<A> editFirstChannel() {
        if (this.channels.size() == 0) {
            throw new RuntimeException("Can't edit first channels. The list is empty.");
        }
        return this.setNewChannelLike(0, this.buildChannel(0));
    }

    public ChannelsNested<A> editLastChannel() {
        int index = this.channels.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last channels. The list is empty.");
        }
        return this.setNewChannelLike(index, this.buildChannel(index));
    }

    public ChannelsNested<A> editMatchingChannel(Predicate<PackageChannelBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.channels.size(); ++i) {
            if (!predicate.test(this.channels.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching channels. No match found.");
        }
        return this.setNewChannelLike(index, this.buildChannel(index));
    }

    public String getDefaultChannel() {
        return this.defaultChannel;
    }

    public A withDefaultChannel(String defaultChannel) {
        this.defaultChannel = defaultChannel;
        return (A)this;
    }

    public boolean hasDefaultChannel() {
        return this.defaultChannel != null;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public A withPackageName(String packageName) {
        this.packageName = packageName;
        return (A)this;
    }

    public boolean hasPackageName() {
        return this.packageName != null;
    }

    public AppLink buildProvider() {
        return this.provider != null ? this.provider.build() : null;
    }

    public A withProvider(AppLink provider) {
        this._visitables.remove("provider");
        if (provider != null) {
            this.provider = new AppLinkBuilder(provider);
            this._visitables.get("provider").add(this.provider);
        } else {
            this.provider = null;
            this._visitables.get("provider").remove(this.provider);
        }
        return (A)this;
    }

    public boolean hasProvider() {
        return this.provider != null;
    }

    public A withNewProvider(String name, String url) {
        return this.withProvider(new AppLink(name, url));
    }

    public ProviderNested<A> withNewProvider() {
        return new ProviderNested(null);
    }

    public ProviderNested<A> withNewProviderLike(AppLink item) {
        return new ProviderNested(item);
    }

    public ProviderNested<A> editProvider() {
        return this.withNewProviderLike(Optional.ofNullable(this.buildProvider()).orElse(null));
    }

    public ProviderNested<A> editOrNewProvider() {
        return this.withNewProviderLike(Optional.ofNullable(this.buildProvider()).orElse(new AppLinkBuilder().build()));
    }

    public ProviderNested<A> editOrNewProviderLike(AppLink item) {
        return this.withNewProviderLike(Optional.ofNullable(this.buildProvider()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PackageManifestStatusFluent that = (PackageManifestStatusFluent)o;
        if (!Objects.equals(this.catalogSource, that.catalogSource)) {
            return false;
        }
        if (!Objects.equals(this.catalogSourceDisplayName, that.catalogSourceDisplayName)) {
            return false;
        }
        if (!Objects.equals(this.catalogSourceNamespace, that.catalogSourceNamespace)) {
            return false;
        }
        if (!Objects.equals(this.catalogSourcePublisher, that.catalogSourcePublisher)) {
            return false;
        }
        if (!Objects.equals(this.channels, that.channels)) {
            return false;
        }
        if (!Objects.equals(this.defaultChannel, that.defaultChannel)) {
            return false;
        }
        if (!Objects.equals(this.packageName, that.packageName)) {
            return false;
        }
        if (!Objects.equals(this.provider, that.provider)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.catalogSource, this.catalogSourceDisplayName, this.catalogSourceNamespace, this.catalogSourcePublisher, this.channels, this.defaultChannel, this.packageName, this.provider, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.catalogSource != null) {
            sb.append("catalogSource:");
            sb.append(this.catalogSource + ",");
        }
        if (this.catalogSourceDisplayName != null) {
            sb.append("catalogSourceDisplayName:");
            sb.append(this.catalogSourceDisplayName + ",");
        }
        if (this.catalogSourceNamespace != null) {
            sb.append("catalogSourceNamespace:");
            sb.append(this.catalogSourceNamespace + ",");
        }
        if (this.catalogSourcePublisher != null) {
            sb.append("catalogSourcePublisher:");
            sb.append(this.catalogSourcePublisher + ",");
        }
        if (this.channels != null && !this.channels.isEmpty()) {
            sb.append("channels:");
            sb.append(this.channels + ",");
        }
        if (this.defaultChannel != null) {
            sb.append("defaultChannel:");
            sb.append(this.defaultChannel + ",");
        }
        if (this.packageName != null) {
            sb.append("packageName:");
            sb.append(this.packageName + ",");
        }
        if (this.provider != null) {
            sb.append("provider:");
            sb.append(this.provider + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ProviderNested<N>
    extends AppLinkFluent<ProviderNested<N>>
    implements Nested<N> {
        AppLinkBuilder builder;

        ProviderNested(AppLink item) {
            this.builder = new AppLinkBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PackageManifestStatusFluent.this.withProvider(this.builder.build());
        }

        public N endProvider() {
            return this.and();
        }
    }

    public class ChannelsNested<N>
    extends PackageChannelFluent<ChannelsNested<N>>
    implements Nested<N> {
        PackageChannelBuilder builder;
        int index;

        ChannelsNested(int index, PackageChannel item) {
            this.index = index;
            this.builder = new PackageChannelBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PackageManifestStatusFluent.this.setToChannels(this.index, this.builder.build());
        }

        public N endChannel() {
            return this.and();
        }
    }
}

