/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_9.operator.v1;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.openshift.api.model.v6_9.operator.v1.Perspective;
import io.fabric8.openshift.api.model.v6_9.operator.v1.PerspectiveVisibility;
import io.fabric8.openshift.api.model.v6_9.operator.v1.PerspectiveVisibilityBuilder;
import io.fabric8.openshift.api.model.v6_9.operator.v1.PerspectiveVisibilityFluent;
import io.fabric8.openshift.api.model.v6_9.operator.v1.PinnedResourceReference;
import io.fabric8.openshift.api.model.v6_9.operator.v1.PinnedResourceReferenceBuilder;
import io.fabric8.openshift.api.model.v6_9.operator.v1.PinnedResourceReferenceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PerspectiveFluent<A extends PerspectiveFluent<A>>
extends BaseFluent<A> {
    private String id;
    private ArrayList<PinnedResourceReferenceBuilder> pinnedResources = new ArrayList();
    private PerspectiveVisibilityBuilder visibility;
    private Map<String, Object> additionalProperties;

    public PerspectiveFluent() {
    }

    public PerspectiveFluent(Perspective instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Perspective instance) {
        Perspective perspective = instance = instance != null ? instance : new Perspective();
        if (instance != null) {
            this.withId(instance.getId());
            this.withPinnedResources(instance.getPinnedResources());
            this.withVisibility(instance.getVisibility());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getId() {
        return this.id;
    }

    public A withId(String id) {
        this.id = id;
        return (A)this;
    }

    public boolean hasId() {
        return this.id != null;
    }

    public A addToPinnedResources(int index, PinnedResourceReference item) {
        if (this.pinnedResources == null) {
            this.pinnedResources = new ArrayList();
        }
        PinnedResourceReferenceBuilder builder = new PinnedResourceReferenceBuilder(item);
        if (index < 0 || index >= this.pinnedResources.size()) {
            this._visitables.get("pinnedResources").add(builder);
            this.pinnedResources.add(builder);
        } else {
            this._visitables.get("pinnedResources").add(index, builder);
            this.pinnedResources.add(index, builder);
        }
        return (A)this;
    }

    public A setToPinnedResources(int index, PinnedResourceReference item) {
        if (this.pinnedResources == null) {
            this.pinnedResources = new ArrayList();
        }
        PinnedResourceReferenceBuilder builder = new PinnedResourceReferenceBuilder(item);
        if (index < 0 || index >= this.pinnedResources.size()) {
            this._visitables.get("pinnedResources").add(builder);
            this.pinnedResources.add(builder);
        } else {
            this._visitables.get("pinnedResources").set(index, builder);
            this.pinnedResources.set(index, builder);
        }
        return (A)this;
    }

    public A addToPinnedResources(PinnedResourceReference ... items) {
        if (this.pinnedResources == null) {
            this.pinnedResources = new ArrayList();
        }
        for (PinnedResourceReference item : items) {
            PinnedResourceReferenceBuilder builder = new PinnedResourceReferenceBuilder(item);
            this._visitables.get("pinnedResources").add(builder);
            this.pinnedResources.add(builder);
        }
        return (A)this;
    }

    public A addAllToPinnedResources(Collection<PinnedResourceReference> items) {
        if (this.pinnedResources == null) {
            this.pinnedResources = new ArrayList();
        }
        for (PinnedResourceReference item : items) {
            PinnedResourceReferenceBuilder builder = new PinnedResourceReferenceBuilder(item);
            this._visitables.get("pinnedResources").add(builder);
            this.pinnedResources.add(builder);
        }
        return (A)this;
    }

    public A removeFromPinnedResources(PinnedResourceReference ... items) {
        if (this.pinnedResources == null) {
            return (A)this;
        }
        for (PinnedResourceReference item : items) {
            PinnedResourceReferenceBuilder builder = new PinnedResourceReferenceBuilder(item);
            this._visitables.get("pinnedResources").remove(builder);
            this.pinnedResources.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromPinnedResources(Collection<PinnedResourceReference> items) {
        if (this.pinnedResources == null) {
            return (A)this;
        }
        for (PinnedResourceReference item : items) {
            PinnedResourceReferenceBuilder builder = new PinnedResourceReferenceBuilder(item);
            this._visitables.get("pinnedResources").remove(builder);
            this.pinnedResources.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromPinnedResources(Predicate<PinnedResourceReferenceBuilder> predicate) {
        if (this.pinnedResources == null) {
            return (A)this;
        }
        Iterator<PinnedResourceReferenceBuilder> each = this.pinnedResources.iterator();
        Object visitables = this._visitables.get("pinnedResources");
        while (each.hasNext()) {
            PinnedResourceReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<PinnedResourceReference> buildPinnedResources() {
        return this.pinnedResources != null ? PerspectiveFluent.build(this.pinnedResources) : null;
    }

    public PinnedResourceReference buildPinnedResource(int index) {
        return this.pinnedResources.get(index).build();
    }

    public PinnedResourceReference buildFirstPinnedResource() {
        return this.pinnedResources.get(0).build();
    }

    public PinnedResourceReference buildLastPinnedResource() {
        return this.pinnedResources.get(this.pinnedResources.size() - 1).build();
    }

    public PinnedResourceReference buildMatchingPinnedResource(Predicate<PinnedResourceReferenceBuilder> predicate) {
        for (PinnedResourceReferenceBuilder item : this.pinnedResources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPinnedResource(Predicate<PinnedResourceReferenceBuilder> predicate) {
        for (PinnedResourceReferenceBuilder item : this.pinnedResources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPinnedResources(List<PinnedResourceReference> pinnedResources) {
        if (this.pinnedResources != null) {
            this._visitables.get("pinnedResources").clear();
        }
        if (pinnedResources != null) {
            this.pinnedResources = new ArrayList();
            for (PinnedResourceReference item : pinnedResources) {
                this.addToPinnedResources(item);
            }
        } else {
            this.pinnedResources = null;
        }
        return (A)this;
    }

    public A withPinnedResources(PinnedResourceReference ... pinnedResources) {
        if (this.pinnedResources != null) {
            this.pinnedResources.clear();
            this._visitables.remove("pinnedResources");
        }
        if (pinnedResources != null) {
            for (PinnedResourceReference item : pinnedResources) {
                this.addToPinnedResources(item);
            }
        }
        return (A)this;
    }

    public boolean hasPinnedResources() {
        return this.pinnedResources != null && !this.pinnedResources.isEmpty();
    }

    public A addNewPinnedResource(String group, String resource, String version) {
        return this.addToPinnedResources(new PinnedResourceReference(group, resource, version));
    }

    public PinnedResourcesNested<A> addNewPinnedResource() {
        return new PinnedResourcesNested(-1, null);
    }

    public PinnedResourcesNested<A> addNewPinnedResourceLike(PinnedResourceReference item) {
        return new PinnedResourcesNested(-1, item);
    }

    public PinnedResourcesNested<A> setNewPinnedResourceLike(int index, PinnedResourceReference item) {
        return new PinnedResourcesNested(index, item);
    }

    public PinnedResourcesNested<A> editPinnedResource(int index) {
        if (this.pinnedResources.size() <= index) {
            throw new RuntimeException("Can't edit pinnedResources. Index exceeds size.");
        }
        return this.setNewPinnedResourceLike(index, this.buildPinnedResource(index));
    }

    public PinnedResourcesNested<A> editFirstPinnedResource() {
        if (this.pinnedResources.size() == 0) {
            throw new RuntimeException("Can't edit first pinnedResources. The list is empty.");
        }
        return this.setNewPinnedResourceLike(0, this.buildPinnedResource(0));
    }

    public PinnedResourcesNested<A> editLastPinnedResource() {
        int index = this.pinnedResources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last pinnedResources. The list is empty.");
        }
        return this.setNewPinnedResourceLike(index, this.buildPinnedResource(index));
    }

    public PinnedResourcesNested<A> editMatchingPinnedResource(Predicate<PinnedResourceReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.pinnedResources.size(); ++i) {
            if (!predicate.test(this.pinnedResources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching pinnedResources. No match found.");
        }
        return this.setNewPinnedResourceLike(index, this.buildPinnedResource(index));
    }

    public PerspectiveVisibility buildVisibility() {
        return this.visibility != null ? this.visibility.build() : null;
    }

    public A withVisibility(PerspectiveVisibility visibility) {
        this._visitables.remove("visibility");
        if (visibility != null) {
            this.visibility = new PerspectiveVisibilityBuilder(visibility);
            this._visitables.get("visibility").add(this.visibility);
        } else {
            this.visibility = null;
            this._visitables.get("visibility").remove(this.visibility);
        }
        return (A)this;
    }

    public boolean hasVisibility() {
        return this.visibility != null;
    }

    public VisibilityNested<A> withNewVisibility() {
        return new VisibilityNested(null);
    }

    public VisibilityNested<A> withNewVisibilityLike(PerspectiveVisibility item) {
        return new VisibilityNested(item);
    }

    public VisibilityNested<A> editVisibility() {
        return this.withNewVisibilityLike(Optional.ofNullable(this.buildVisibility()).orElse(null));
    }

    public VisibilityNested<A> editOrNewVisibility() {
        return this.withNewVisibilityLike(Optional.ofNullable(this.buildVisibility()).orElse(new PerspectiveVisibilityBuilder().build()));
    }

    public VisibilityNested<A> editOrNewVisibilityLike(PerspectiveVisibility item) {
        return this.withNewVisibilityLike(Optional.ofNullable(this.buildVisibility()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PerspectiveFluent that = (PerspectiveFluent)o;
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!Objects.equals(this.pinnedResources, that.pinnedResources)) {
            return false;
        }
        if (!Objects.equals(this.visibility, that.visibility)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.pinnedResources, this.visibility, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id != null) {
            sb.append("id:");
            sb.append(this.id + ",");
        }
        if (this.pinnedResources != null && !this.pinnedResources.isEmpty()) {
            sb.append("pinnedResources:");
            sb.append(this.pinnedResources + ",");
        }
        if (this.visibility != null) {
            sb.append("visibility:");
            sb.append(this.visibility + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class VisibilityNested<N>
    extends PerspectiveVisibilityFluent<VisibilityNested<N>>
    implements Nested<N> {
        PerspectiveVisibilityBuilder builder;

        VisibilityNested(PerspectiveVisibility item) {
            this.builder = new PerspectiveVisibilityBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PerspectiveFluent.this.withVisibility(this.builder.build());
        }

        public N endVisibility() {
            return this.and();
        }
    }

    public class PinnedResourcesNested<N>
    extends PinnedResourceReferenceFluent<PinnedResourcesNested<N>>
    implements Nested<N> {
        PinnedResourceReferenceBuilder builder;
        int index;

        PinnedResourcesNested(int index, PinnedResourceReference item) {
            this.index = index;
            this.builder = new PinnedResourceReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PerspectiveFluent.this.setToPinnedResources(this.index, this.builder.build());
        }

        public N endPinnedResource() {
            return this.and();
        }
    }
}

