/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_9.operator.v1;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.openshift.api.model.v6_9.operator.v1.LoadBalancerStrategy;
import io.fabric8.openshift.api.model.v6_9.operator.v1.ProviderLoadBalancerParameters;
import io.fabric8.openshift.api.model.v6_9.operator.v1.ProviderLoadBalancerParametersBuilder;
import io.fabric8.openshift.api.model.v6_9.operator.v1.ProviderLoadBalancerParametersFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class LoadBalancerStrategyFluent<A extends LoadBalancerStrategyFluent<A>>
extends BaseFluent<A> {
    private List<String> allowedSourceRanges = new ArrayList<String>();
    private String dnsManagementPolicy;
    private ProviderLoadBalancerParametersBuilder providerParameters;
    private String scope;
    private Map<String, Object> additionalProperties;

    public LoadBalancerStrategyFluent() {
    }

    public LoadBalancerStrategyFluent(LoadBalancerStrategy instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(LoadBalancerStrategy instance) {
        LoadBalancerStrategy loadBalancerStrategy = instance = instance != null ? instance : new LoadBalancerStrategy();
        if (instance != null) {
            this.withAllowedSourceRanges(instance.getAllowedSourceRanges());
            this.withDnsManagementPolicy(instance.getDnsManagementPolicy());
            this.withProviderParameters(instance.getProviderParameters());
            this.withScope(instance.getScope());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAllowedSourceRanges(int index, String item) {
        if (this.allowedSourceRanges == null) {
            this.allowedSourceRanges = new ArrayList<String>();
        }
        this.allowedSourceRanges.add(index, item);
        return (A)this;
    }

    public A setToAllowedSourceRanges(int index, String item) {
        if (this.allowedSourceRanges == null) {
            this.allowedSourceRanges = new ArrayList<String>();
        }
        this.allowedSourceRanges.set(index, item);
        return (A)this;
    }

    public A addToAllowedSourceRanges(String ... items) {
        if (this.allowedSourceRanges == null) {
            this.allowedSourceRanges = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedSourceRanges.add(item);
        }
        return (A)this;
    }

    public A addAllToAllowedSourceRanges(Collection<String> items) {
        if (this.allowedSourceRanges == null) {
            this.allowedSourceRanges = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedSourceRanges.add(item);
        }
        return (A)this;
    }

    public A removeFromAllowedSourceRanges(String ... items) {
        if (this.allowedSourceRanges == null) {
            return (A)this;
        }
        for (String item : items) {
            this.allowedSourceRanges.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromAllowedSourceRanges(Collection<String> items) {
        if (this.allowedSourceRanges == null) {
            return (A)this;
        }
        for (String item : items) {
            this.allowedSourceRanges.remove(item);
        }
        return (A)this;
    }

    public List<String> getAllowedSourceRanges() {
        return this.allowedSourceRanges;
    }

    public String getAllowedSourceRange(int index) {
        return this.allowedSourceRanges.get(index);
    }

    public String getFirstAllowedSourceRange() {
        return this.allowedSourceRanges.get(0);
    }

    public String getLastAllowedSourceRange() {
        return this.allowedSourceRanges.get(this.allowedSourceRanges.size() - 1);
    }

    public String getMatchingAllowedSourceRange(Predicate<String> predicate) {
        for (String item : this.allowedSourceRanges) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAllowedSourceRange(Predicate<String> predicate) {
        for (String item : this.allowedSourceRanges) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAllowedSourceRanges(List<String> allowedSourceRanges) {
        if (allowedSourceRanges != null) {
            this.allowedSourceRanges = new ArrayList<String>();
            for (String item : allowedSourceRanges) {
                this.addToAllowedSourceRanges(item);
            }
        } else {
            this.allowedSourceRanges = null;
        }
        return (A)this;
    }

    public A withAllowedSourceRanges(String ... allowedSourceRanges) {
        if (this.allowedSourceRanges != null) {
            this.allowedSourceRanges.clear();
            this._visitables.remove("allowedSourceRanges");
        }
        if (allowedSourceRanges != null) {
            for (String item : allowedSourceRanges) {
                this.addToAllowedSourceRanges(item);
            }
        }
        return (A)this;
    }

    public boolean hasAllowedSourceRanges() {
        return this.allowedSourceRanges != null && !this.allowedSourceRanges.isEmpty();
    }

    public String getDnsManagementPolicy() {
        return this.dnsManagementPolicy;
    }

    public A withDnsManagementPolicy(String dnsManagementPolicy) {
        this.dnsManagementPolicy = dnsManagementPolicy;
        return (A)this;
    }

    public boolean hasDnsManagementPolicy() {
        return this.dnsManagementPolicy != null;
    }

    public ProviderLoadBalancerParameters buildProviderParameters() {
        return this.providerParameters != null ? this.providerParameters.build() : null;
    }

    public A withProviderParameters(ProviderLoadBalancerParameters providerParameters) {
        this._visitables.remove("providerParameters");
        if (providerParameters != null) {
            this.providerParameters = new ProviderLoadBalancerParametersBuilder(providerParameters);
            this._visitables.get("providerParameters").add(this.providerParameters);
        } else {
            this.providerParameters = null;
            this._visitables.get("providerParameters").remove(this.providerParameters);
        }
        return (A)this;
    }

    public boolean hasProviderParameters() {
        return this.providerParameters != null;
    }

    public ProviderParametersNested<A> withNewProviderParameters() {
        return new ProviderParametersNested(null);
    }

    public ProviderParametersNested<A> withNewProviderParametersLike(ProviderLoadBalancerParameters item) {
        return new ProviderParametersNested(item);
    }

    public ProviderParametersNested<A> editProviderParameters() {
        return this.withNewProviderParametersLike(Optional.ofNullable(this.buildProviderParameters()).orElse(null));
    }

    public ProviderParametersNested<A> editOrNewProviderParameters() {
        return this.withNewProviderParametersLike(Optional.ofNullable(this.buildProviderParameters()).orElse(new ProviderLoadBalancerParametersBuilder().build()));
    }

    public ProviderParametersNested<A> editOrNewProviderParametersLike(ProviderLoadBalancerParameters item) {
        return this.withNewProviderParametersLike(Optional.ofNullable(this.buildProviderParameters()).orElse(item));
    }

    public String getScope() {
        return this.scope;
    }

    public A withScope(String scope) {
        this.scope = scope;
        return (A)this;
    }

    public boolean hasScope() {
        return this.scope != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LoadBalancerStrategyFluent that = (LoadBalancerStrategyFluent)o;
        if (!Objects.equals(this.allowedSourceRanges, that.allowedSourceRanges)) {
            return false;
        }
        if (!Objects.equals(this.dnsManagementPolicy, that.dnsManagementPolicy)) {
            return false;
        }
        if (!Objects.equals(this.providerParameters, that.providerParameters)) {
            return false;
        }
        if (!Objects.equals(this.scope, that.scope)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allowedSourceRanges, this.dnsManagementPolicy, this.providerParameters, this.scope, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowedSourceRanges != null && !this.allowedSourceRanges.isEmpty()) {
            sb.append("allowedSourceRanges:");
            sb.append(this.allowedSourceRanges + ",");
        }
        if (this.dnsManagementPolicy != null) {
            sb.append("dnsManagementPolicy:");
            sb.append(this.dnsManagementPolicy + ",");
        }
        if (this.providerParameters != null) {
            sb.append("providerParameters:");
            sb.append(this.providerParameters + ",");
        }
        if (this.scope != null) {
            sb.append("scope:");
            sb.append(this.scope + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ProviderParametersNested<N>
    extends ProviderLoadBalancerParametersFluent<ProviderParametersNested<N>>
    implements Nested<N> {
        ProviderLoadBalancerParametersBuilder builder;

        ProviderParametersNested(ProviderLoadBalancerParameters item) {
            this.builder = new ProviderLoadBalancerParametersBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)LoadBalancerStrategyFluent.this.withProviderParameters(this.builder.build());
        }

        public N endProviderParameters() {
            return this.and();
        }
    }
}

