/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_9.monitoring.v1;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.kubernetes.api.model.v6_9.SecretKeySelector;
import io.fabric8.openshift.api.model.v6_9.monitoring.v1.AlertmanagerGlobalConfig;
import io.fabric8.openshift.api.model.v6_9.monitoring.v1.GlobalSMTPConfig;
import io.fabric8.openshift.api.model.v6_9.monitoring.v1.GlobalSMTPConfigBuilder;
import io.fabric8.openshift.api.model.v6_9.monitoring.v1.GlobalSMTPConfigFluent;
import io.fabric8.openshift.api.model.v6_9.monitoring.v1.HTTPConfig;
import io.fabric8.openshift.api.model.v6_9.monitoring.v1.HTTPConfigBuilder;
import io.fabric8.openshift.api.model.v6_9.monitoring.v1.HTTPConfigFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AlertmanagerGlobalConfigFluent<A extends AlertmanagerGlobalConfigFluent<A>>
extends BaseFluent<A> {
    private HTTPConfigBuilder httpConfig;
    private SecretKeySelector opsGenieApiKey;
    private SecretKeySelector opsGenieApiUrl;
    private String pagerdutyUrl;
    private String resolveTimeout;
    private SecretKeySelector slackApiUrl;
    private GlobalSMTPConfigBuilder smtp;
    private Map<String, Object> additionalProperties;

    public AlertmanagerGlobalConfigFluent() {
    }

    public AlertmanagerGlobalConfigFluent(AlertmanagerGlobalConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AlertmanagerGlobalConfig instance) {
        AlertmanagerGlobalConfig alertmanagerGlobalConfig = instance = instance != null ? instance : new AlertmanagerGlobalConfig();
        if (instance != null) {
            this.withHttpConfig(instance.getHttpConfig());
            this.withOpsGenieApiKey(instance.getOpsGenieApiKey());
            this.withOpsGenieApiUrl(instance.getOpsGenieApiUrl());
            this.withPagerdutyUrl(instance.getPagerdutyUrl());
            this.withResolveTimeout(instance.getResolveTimeout());
            this.withSlackApiUrl(instance.getSlackApiUrl());
            this.withSmtp(instance.getSmtp());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public HTTPConfig buildHttpConfig() {
        return this.httpConfig != null ? this.httpConfig.build() : null;
    }

    public A withHttpConfig(HTTPConfig httpConfig) {
        this._visitables.remove("httpConfig");
        if (httpConfig != null) {
            this.httpConfig = new HTTPConfigBuilder(httpConfig);
            this._visitables.get("httpConfig").add(this.httpConfig);
        } else {
            this.httpConfig = null;
            this._visitables.get("httpConfig").remove(this.httpConfig);
        }
        return (A)this;
    }

    public boolean hasHttpConfig() {
        return this.httpConfig != null;
    }

    public HttpConfigNested<A> withNewHttpConfig() {
        return new HttpConfigNested(null);
    }

    public HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
        return new HttpConfigNested(item);
    }

    public HttpConfigNested<A> editHttpConfig() {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(null));
    }

    public HttpConfigNested<A> editOrNewHttpConfig() {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(new HTTPConfigBuilder().build()));
    }

    public HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(item));
    }

    public SecretKeySelector getOpsGenieApiKey() {
        return this.opsGenieApiKey;
    }

    public A withOpsGenieApiKey(SecretKeySelector opsGenieApiKey) {
        this.opsGenieApiKey = opsGenieApiKey;
        return (A)this;
    }

    public boolean hasOpsGenieApiKey() {
        return this.opsGenieApiKey != null;
    }

    public A withNewOpsGenieApiKey(String key, String name, Boolean optional) {
        return this.withOpsGenieApiKey(new SecretKeySelector(key, name, optional));
    }

    public SecretKeySelector getOpsGenieApiUrl() {
        return this.opsGenieApiUrl;
    }

    public A withOpsGenieApiUrl(SecretKeySelector opsGenieApiUrl) {
        this.opsGenieApiUrl = opsGenieApiUrl;
        return (A)this;
    }

    public boolean hasOpsGenieApiUrl() {
        return this.opsGenieApiUrl != null;
    }

    public A withNewOpsGenieApiUrl(String key, String name, Boolean optional) {
        return this.withOpsGenieApiUrl(new SecretKeySelector(key, name, optional));
    }

    public String getPagerdutyUrl() {
        return this.pagerdutyUrl;
    }

    public A withPagerdutyUrl(String pagerdutyUrl) {
        this.pagerdutyUrl = pagerdutyUrl;
        return (A)this;
    }

    public boolean hasPagerdutyUrl() {
        return this.pagerdutyUrl != null;
    }

    public String getResolveTimeout() {
        return this.resolveTimeout;
    }

    public A withResolveTimeout(String resolveTimeout) {
        this.resolveTimeout = resolveTimeout;
        return (A)this;
    }

    public boolean hasResolveTimeout() {
        return this.resolveTimeout != null;
    }

    public SecretKeySelector getSlackApiUrl() {
        return this.slackApiUrl;
    }

    public A withSlackApiUrl(SecretKeySelector slackApiUrl) {
        this.slackApiUrl = slackApiUrl;
        return (A)this;
    }

    public boolean hasSlackApiUrl() {
        return this.slackApiUrl != null;
    }

    public A withNewSlackApiUrl(String key, String name, Boolean optional) {
        return this.withSlackApiUrl(new SecretKeySelector(key, name, optional));
    }

    public GlobalSMTPConfig buildSmtp() {
        return this.smtp != null ? this.smtp.build() : null;
    }

    public A withSmtp(GlobalSMTPConfig smtp) {
        this._visitables.remove("smtp");
        if (smtp != null) {
            this.smtp = new GlobalSMTPConfigBuilder(smtp);
            this._visitables.get("smtp").add(this.smtp);
        } else {
            this.smtp = null;
            this._visitables.get("smtp").remove(this.smtp);
        }
        return (A)this;
    }

    public boolean hasSmtp() {
        return this.smtp != null;
    }

    public SmtpNested<A> withNewSmtp() {
        return new SmtpNested(null);
    }

    public SmtpNested<A> withNewSmtpLike(GlobalSMTPConfig item) {
        return new SmtpNested(item);
    }

    public SmtpNested<A> editSmtp() {
        return this.withNewSmtpLike(Optional.ofNullable(this.buildSmtp()).orElse(null));
    }

    public SmtpNested<A> editOrNewSmtp() {
        return this.withNewSmtpLike(Optional.ofNullable(this.buildSmtp()).orElse(new GlobalSMTPConfigBuilder().build()));
    }

    public SmtpNested<A> editOrNewSmtpLike(GlobalSMTPConfig item) {
        return this.withNewSmtpLike(Optional.ofNullable(this.buildSmtp()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AlertmanagerGlobalConfigFluent that = (AlertmanagerGlobalConfigFluent)o;
        if (!Objects.equals(this.httpConfig, that.httpConfig)) {
            return false;
        }
        if (!Objects.equals(this.opsGenieApiKey, that.opsGenieApiKey)) {
            return false;
        }
        if (!Objects.equals(this.opsGenieApiUrl, that.opsGenieApiUrl)) {
            return false;
        }
        if (!Objects.equals(this.pagerdutyUrl, that.pagerdutyUrl)) {
            return false;
        }
        if (!Objects.equals(this.resolveTimeout, that.resolveTimeout)) {
            return false;
        }
        if (!Objects.equals(this.slackApiUrl, that.slackApiUrl)) {
            return false;
        }
        if (!Objects.equals(this.smtp, that.smtp)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.httpConfig, this.opsGenieApiKey, this.opsGenieApiUrl, this.pagerdutyUrl, this.resolveTimeout, this.slackApiUrl, this.smtp, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.httpConfig != null) {
            sb.append("httpConfig:");
            sb.append(this.httpConfig + ",");
        }
        if (this.opsGenieApiKey != null) {
            sb.append("opsGenieApiKey:");
            sb.append(this.opsGenieApiKey + ",");
        }
        if (this.opsGenieApiUrl != null) {
            sb.append("opsGenieApiUrl:");
            sb.append(this.opsGenieApiUrl + ",");
        }
        if (this.pagerdutyUrl != null) {
            sb.append("pagerdutyUrl:");
            sb.append(this.pagerdutyUrl + ",");
        }
        if (this.resolveTimeout != null) {
            sb.append("resolveTimeout:");
            sb.append(this.resolveTimeout + ",");
        }
        if (this.slackApiUrl != null) {
            sb.append("slackApiUrl:");
            sb.append(this.slackApiUrl + ",");
        }
        if (this.smtp != null) {
            sb.append("smtp:");
            sb.append(this.smtp + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SmtpNested<N>
    extends GlobalSMTPConfigFluent<SmtpNested<N>>
    implements Nested<N> {
        GlobalSMTPConfigBuilder builder;

        SmtpNested(GlobalSMTPConfig item) {
            this.builder = new GlobalSMTPConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlertmanagerGlobalConfigFluent.this.withSmtp(this.builder.build());
        }

        public N endSmtp() {
            return this.and();
        }
    }

    public class HttpConfigNested<N>
    extends HTTPConfigFluent<HttpConfigNested<N>>
    implements Nested<N> {
        HTTPConfigBuilder builder;

        HttpConfigNested(HTTPConfig item) {
            this.builder = new HTTPConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlertmanagerGlobalConfigFluent.this.withHttpConfig(this.builder.build());
        }

        public N endHttpConfig() {
            return this.and();
        }
    }
}

