/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_9.installer.azure.v1;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.openshift.api.model.v6_9.installer.azure.v1.DiskEncryptionSet;
import io.fabric8.openshift.api.model.v6_9.installer.azure.v1.DiskEncryptionSetBuilder;
import io.fabric8.openshift.api.model.v6_9.installer.azure.v1.DiskEncryptionSetFluent;
import io.fabric8.openshift.api.model.v6_9.installer.azure.v1.OSDisk;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class OSDiskFluent<A extends OSDiskFluent<A>>
extends BaseFluent<A> {
    private DiskEncryptionSetBuilder diskEncryptionSet;
    private Integer diskSizeGB;
    private String diskType;
    private Map<String, Object> additionalProperties;

    public OSDiskFluent() {
    }

    public OSDiskFluent(OSDisk instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(OSDisk instance) {
        OSDisk oSDisk = instance = instance != null ? instance : new OSDisk();
        if (instance != null) {
            this.withDiskEncryptionSet(instance.getDiskEncryptionSet());
            this.withDiskSizeGB(instance.getDiskSizeGB());
            this.withDiskType(instance.getDiskType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public DiskEncryptionSet buildDiskEncryptionSet() {
        return this.diskEncryptionSet != null ? this.diskEncryptionSet.build() : null;
    }

    public A withDiskEncryptionSet(DiskEncryptionSet diskEncryptionSet) {
        this._visitables.remove("diskEncryptionSet");
        if (diskEncryptionSet != null) {
            this.diskEncryptionSet = new DiskEncryptionSetBuilder(diskEncryptionSet);
            this._visitables.get("diskEncryptionSet").add(this.diskEncryptionSet);
        } else {
            this.diskEncryptionSet = null;
            this._visitables.get("diskEncryptionSet").remove(this.diskEncryptionSet);
        }
        return (A)this;
    }

    public boolean hasDiskEncryptionSet() {
        return this.diskEncryptionSet != null;
    }

    public A withNewDiskEncryptionSet(String name, String resourceGroup, String subscriptionId) {
        return this.withDiskEncryptionSet(new DiskEncryptionSet(name, resourceGroup, subscriptionId));
    }

    public DiskEncryptionSetNested<A> withNewDiskEncryptionSet() {
        return new DiskEncryptionSetNested(null);
    }

    public DiskEncryptionSetNested<A> withNewDiskEncryptionSetLike(DiskEncryptionSet item) {
        return new DiskEncryptionSetNested(item);
    }

    public DiskEncryptionSetNested<A> editDiskEncryptionSet() {
        return this.withNewDiskEncryptionSetLike(Optional.ofNullable(this.buildDiskEncryptionSet()).orElse(null));
    }

    public DiskEncryptionSetNested<A> editOrNewDiskEncryptionSet() {
        return this.withNewDiskEncryptionSetLike(Optional.ofNullable(this.buildDiskEncryptionSet()).orElse(new DiskEncryptionSetBuilder().build()));
    }

    public DiskEncryptionSetNested<A> editOrNewDiskEncryptionSetLike(DiskEncryptionSet item) {
        return this.withNewDiskEncryptionSetLike(Optional.ofNullable(this.buildDiskEncryptionSet()).orElse(item));
    }

    public Integer getDiskSizeGB() {
        return this.diskSizeGB;
    }

    public A withDiskSizeGB(Integer diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return (A)this;
    }

    public boolean hasDiskSizeGB() {
        return this.diskSizeGB != null;
    }

    public String getDiskType() {
        return this.diskType;
    }

    public A withDiskType(String diskType) {
        this.diskType = diskType;
        return (A)this;
    }

    public boolean hasDiskType() {
        return this.diskType != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OSDiskFluent that = (OSDiskFluent)o;
        if (!Objects.equals(this.diskEncryptionSet, that.diskEncryptionSet)) {
            return false;
        }
        if (!Objects.equals(this.diskSizeGB, that.diskSizeGB)) {
            return false;
        }
        if (!Objects.equals(this.diskType, that.diskType)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.diskEncryptionSet, this.diskSizeGB, this.diskType, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.diskEncryptionSet != null) {
            sb.append("diskEncryptionSet:");
            sb.append(this.diskEncryptionSet + ",");
        }
        if (this.diskSizeGB != null) {
            sb.append("diskSizeGB:");
            sb.append(this.diskSizeGB + ",");
        }
        if (this.diskType != null) {
            sb.append("diskType:");
            sb.append(this.diskType + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DiskEncryptionSetNested<N>
    extends DiskEncryptionSetFluent<DiskEncryptionSetNested<N>>
    implements Nested<N> {
        DiskEncryptionSetBuilder builder;

        DiskEncryptionSetNested(DiskEncryptionSet item) {
            this.builder = new DiskEncryptionSetBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)OSDiskFluent.this.withDiskEncryptionSet(this.builder.build());
        }

        public N endDiskEncryptionSet() {
            return this.and();
        }
    }
}

