/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_9.config.v1;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.openshift.api.model.v6_9.config.v1.VSpherePlatformVCenterSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class VSpherePlatformVCenterSpecFluent<A extends VSpherePlatformVCenterSpecFluent<A>>
extends BaseFluent<A> {
    private List<String> datacenters = new ArrayList<String>();
    private Integer port;
    private String server;
    private Map<String, Object> additionalProperties;

    public VSpherePlatformVCenterSpecFluent() {
    }

    public VSpherePlatformVCenterSpecFluent(VSpherePlatformVCenterSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(VSpherePlatformVCenterSpec instance) {
        VSpherePlatformVCenterSpec vSpherePlatformVCenterSpec = instance = instance != null ? instance : new VSpherePlatformVCenterSpec();
        if (instance != null) {
            this.withDatacenters(instance.getDatacenters());
            this.withPort(instance.getPort());
            this.withServer(instance.getServer());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToDatacenters(int index, String item) {
        if (this.datacenters == null) {
            this.datacenters = new ArrayList<String>();
        }
        this.datacenters.add(index, item);
        return (A)this;
    }

    public A setToDatacenters(int index, String item) {
        if (this.datacenters == null) {
            this.datacenters = new ArrayList<String>();
        }
        this.datacenters.set(index, item);
        return (A)this;
    }

    public A addToDatacenters(String ... items) {
        if (this.datacenters == null) {
            this.datacenters = new ArrayList<String>();
        }
        for (String item : items) {
            this.datacenters.add(item);
        }
        return (A)this;
    }

    public A addAllToDatacenters(Collection<String> items) {
        if (this.datacenters == null) {
            this.datacenters = new ArrayList<String>();
        }
        for (String item : items) {
            this.datacenters.add(item);
        }
        return (A)this;
    }

    public A removeFromDatacenters(String ... items) {
        if (this.datacenters == null) {
            return (A)this;
        }
        for (String item : items) {
            this.datacenters.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromDatacenters(Collection<String> items) {
        if (this.datacenters == null) {
            return (A)this;
        }
        for (String item : items) {
            this.datacenters.remove(item);
        }
        return (A)this;
    }

    public List<String> getDatacenters() {
        return this.datacenters;
    }

    public String getDatacenter(int index) {
        return this.datacenters.get(index);
    }

    public String getFirstDatacenter() {
        return this.datacenters.get(0);
    }

    public String getLastDatacenter() {
        return this.datacenters.get(this.datacenters.size() - 1);
    }

    public String getMatchingDatacenter(Predicate<String> predicate) {
        for (String item : this.datacenters) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingDatacenter(Predicate<String> predicate) {
        for (String item : this.datacenters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDatacenters(List<String> datacenters) {
        if (datacenters != null) {
            this.datacenters = new ArrayList<String>();
            for (String item : datacenters) {
                this.addToDatacenters(item);
            }
        } else {
            this.datacenters = null;
        }
        return (A)this;
    }

    public A withDatacenters(String ... datacenters) {
        if (this.datacenters != null) {
            this.datacenters.clear();
            this._visitables.remove("datacenters");
        }
        if (datacenters != null) {
            for (String item : datacenters) {
                this.addToDatacenters(item);
            }
        }
        return (A)this;
    }

    public boolean hasDatacenters() {
        return this.datacenters != null && !this.datacenters.isEmpty();
    }

    public Integer getPort() {
        return this.port;
    }

    public A withPort(Integer port) {
        this.port = port;
        return (A)this;
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public String getServer() {
        return this.server;
    }

    public A withServer(String server) {
        this.server = server;
        return (A)this;
    }

    public boolean hasServer() {
        return this.server != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VSpherePlatformVCenterSpecFluent that = (VSpherePlatformVCenterSpecFluent)o;
        if (!Objects.equals(this.datacenters, that.datacenters)) {
            return false;
        }
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        if (!Objects.equals(this.server, that.server)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.datacenters, this.port, this.server, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.datacenters != null && !this.datacenters.isEmpty()) {
            sb.append("datacenters:");
            sb.append(this.datacenters + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port + ",");
        }
        if (this.server != null) {
            sb.append("server:");
            sb.append(this.server + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

