/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_9.config.v1;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.openshift.api.model.v6_9.config.v1.ImageStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ImageStatusFluent<A extends ImageStatusFluent<A>>
extends BaseFluent<A> {
    private List<String> externalRegistryHostnames = new ArrayList<String>();
    private String internalRegistryHostname;
    private Map<String, Object> additionalProperties;

    public ImageStatusFluent() {
    }

    public ImageStatusFluent(ImageStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ImageStatus instance) {
        ImageStatus imageStatus = instance = instance != null ? instance : new ImageStatus();
        if (instance != null) {
            this.withExternalRegistryHostnames(instance.getExternalRegistryHostnames());
            this.withInternalRegistryHostname(instance.getInternalRegistryHostname());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToExternalRegistryHostnames(int index, String item) {
        if (this.externalRegistryHostnames == null) {
            this.externalRegistryHostnames = new ArrayList<String>();
        }
        this.externalRegistryHostnames.add(index, item);
        return (A)this;
    }

    public A setToExternalRegistryHostnames(int index, String item) {
        if (this.externalRegistryHostnames == null) {
            this.externalRegistryHostnames = new ArrayList<String>();
        }
        this.externalRegistryHostnames.set(index, item);
        return (A)this;
    }

    public A addToExternalRegistryHostnames(String ... items) {
        if (this.externalRegistryHostnames == null) {
            this.externalRegistryHostnames = new ArrayList<String>();
        }
        for (String item : items) {
            this.externalRegistryHostnames.add(item);
        }
        return (A)this;
    }

    public A addAllToExternalRegistryHostnames(Collection<String> items) {
        if (this.externalRegistryHostnames == null) {
            this.externalRegistryHostnames = new ArrayList<String>();
        }
        for (String item : items) {
            this.externalRegistryHostnames.add(item);
        }
        return (A)this;
    }

    public A removeFromExternalRegistryHostnames(String ... items) {
        if (this.externalRegistryHostnames == null) {
            return (A)this;
        }
        for (String item : items) {
            this.externalRegistryHostnames.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromExternalRegistryHostnames(Collection<String> items) {
        if (this.externalRegistryHostnames == null) {
            return (A)this;
        }
        for (String item : items) {
            this.externalRegistryHostnames.remove(item);
        }
        return (A)this;
    }

    public List<String> getExternalRegistryHostnames() {
        return this.externalRegistryHostnames;
    }

    public String getExternalRegistryHostname(int index) {
        return this.externalRegistryHostnames.get(index);
    }

    public String getFirstExternalRegistryHostname() {
        return this.externalRegistryHostnames.get(0);
    }

    public String getLastExternalRegistryHostname() {
        return this.externalRegistryHostnames.get(this.externalRegistryHostnames.size() - 1);
    }

    public String getMatchingExternalRegistryHostname(Predicate<String> predicate) {
        for (String item : this.externalRegistryHostnames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingExternalRegistryHostname(Predicate<String> predicate) {
        for (String item : this.externalRegistryHostnames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withExternalRegistryHostnames(List<String> externalRegistryHostnames) {
        if (externalRegistryHostnames != null) {
            this.externalRegistryHostnames = new ArrayList<String>();
            for (String item : externalRegistryHostnames) {
                this.addToExternalRegistryHostnames(item);
            }
        } else {
            this.externalRegistryHostnames = null;
        }
        return (A)this;
    }

    public A withExternalRegistryHostnames(String ... externalRegistryHostnames) {
        if (this.externalRegistryHostnames != null) {
            this.externalRegistryHostnames.clear();
            this._visitables.remove("externalRegistryHostnames");
        }
        if (externalRegistryHostnames != null) {
            for (String item : externalRegistryHostnames) {
                this.addToExternalRegistryHostnames(item);
            }
        }
        return (A)this;
    }

    public boolean hasExternalRegistryHostnames() {
        return this.externalRegistryHostnames != null && !this.externalRegistryHostnames.isEmpty();
    }

    public String getInternalRegistryHostname() {
        return this.internalRegistryHostname;
    }

    public A withInternalRegistryHostname(String internalRegistryHostname) {
        this.internalRegistryHostname = internalRegistryHostname;
        return (A)this;
    }

    public boolean hasInternalRegistryHostname() {
        return this.internalRegistryHostname != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageStatusFluent that = (ImageStatusFluent)o;
        if (!Objects.equals(this.externalRegistryHostnames, that.externalRegistryHostnames)) {
            return false;
        }
        if (!Objects.equals(this.internalRegistryHostname, that.internalRegistryHostname)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.externalRegistryHostnames, this.internalRegistryHostname, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.externalRegistryHostnames != null && !this.externalRegistryHostnames.isEmpty()) {
            sb.append("externalRegistryHostnames:");
            sb.append(this.externalRegistryHostnames + ",");
        }
        if (this.internalRegistryHostname != null) {
            sb.append("internalRegistryHostname:");
            sb.append(this.internalRegistryHostname + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

