/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_9.config.v1;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.openshift.api.model.v6_9.config.v1.ConfigMapNameReference;
import io.fabric8.openshift.api.model.v6_9.config.v1.ConfigMapNameReferenceBuilder;
import io.fabric8.openshift.api.model.v6_9.config.v1.ConfigMapNameReferenceFluent;
import io.fabric8.openshift.api.model.v6_9.config.v1.ImageSpec;
import io.fabric8.openshift.api.model.v6_9.config.v1.RegistryLocation;
import io.fabric8.openshift.api.model.v6_9.config.v1.RegistryLocationBuilder;
import io.fabric8.openshift.api.model.v6_9.config.v1.RegistryLocationFluent;
import io.fabric8.openshift.api.model.v6_9.config.v1.RegistrySources;
import io.fabric8.openshift.api.model.v6_9.config.v1.RegistrySourcesBuilder;
import io.fabric8.openshift.api.model.v6_9.config.v1.RegistrySourcesFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ImageSpecFluent<A extends ImageSpecFluent<A>>
extends BaseFluent<A> {
    private ConfigMapNameReferenceBuilder additionalTrustedCA;
    private ArrayList<RegistryLocationBuilder> allowedRegistriesForImport = new ArrayList();
    private List<String> externalRegistryHostnames = new ArrayList<String>();
    private RegistrySourcesBuilder registrySources;
    private Map<String, Object> additionalProperties;

    public ImageSpecFluent() {
    }

    public ImageSpecFluent(ImageSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ImageSpec instance) {
        ImageSpec imageSpec = instance = instance != null ? instance : new ImageSpec();
        if (instance != null) {
            this.withAdditionalTrustedCA(instance.getAdditionalTrustedCA());
            this.withAllowedRegistriesForImport(instance.getAllowedRegistriesForImport());
            this.withExternalRegistryHostnames(instance.getExternalRegistryHostnames());
            this.withRegistrySources(instance.getRegistrySources());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ConfigMapNameReference buildAdditionalTrustedCA() {
        return this.additionalTrustedCA != null ? this.additionalTrustedCA.build() : null;
    }

    public A withAdditionalTrustedCA(ConfigMapNameReference additionalTrustedCA) {
        this._visitables.remove("additionalTrustedCA");
        if (additionalTrustedCA != null) {
            this.additionalTrustedCA = new ConfigMapNameReferenceBuilder(additionalTrustedCA);
            this._visitables.get("additionalTrustedCA").add(this.additionalTrustedCA);
        } else {
            this.additionalTrustedCA = null;
            this._visitables.get("additionalTrustedCA").remove(this.additionalTrustedCA);
        }
        return (A)this;
    }

    public boolean hasAdditionalTrustedCA() {
        return this.additionalTrustedCA != null;
    }

    public A withNewAdditionalTrustedCA(String name) {
        return this.withAdditionalTrustedCA(new ConfigMapNameReference(name));
    }

    public AdditionalTrustedCANested<A> withNewAdditionalTrustedCA() {
        return new AdditionalTrustedCANested(null);
    }

    public AdditionalTrustedCANested<A> withNewAdditionalTrustedCALike(ConfigMapNameReference item) {
        return new AdditionalTrustedCANested(item);
    }

    public AdditionalTrustedCANested<A> editAdditionalTrustedCA() {
        return this.withNewAdditionalTrustedCALike(Optional.ofNullable(this.buildAdditionalTrustedCA()).orElse(null));
    }

    public AdditionalTrustedCANested<A> editOrNewAdditionalTrustedCA() {
        return this.withNewAdditionalTrustedCALike(Optional.ofNullable(this.buildAdditionalTrustedCA()).orElse(new ConfigMapNameReferenceBuilder().build()));
    }

    public AdditionalTrustedCANested<A> editOrNewAdditionalTrustedCALike(ConfigMapNameReference item) {
        return this.withNewAdditionalTrustedCALike(Optional.ofNullable(this.buildAdditionalTrustedCA()).orElse(item));
    }

    public A addToAllowedRegistriesForImport(int index, RegistryLocation item) {
        if (this.allowedRegistriesForImport == null) {
            this.allowedRegistriesForImport = new ArrayList();
        }
        RegistryLocationBuilder builder = new RegistryLocationBuilder(item);
        if (index < 0 || index >= this.allowedRegistriesForImport.size()) {
            this._visitables.get("allowedRegistriesForImport").add(builder);
            this.allowedRegistriesForImport.add(builder);
        } else {
            this._visitables.get("allowedRegistriesForImport").add(index, builder);
            this.allowedRegistriesForImport.add(index, builder);
        }
        return (A)this;
    }

    public A setToAllowedRegistriesForImport(int index, RegistryLocation item) {
        if (this.allowedRegistriesForImport == null) {
            this.allowedRegistriesForImport = new ArrayList();
        }
        RegistryLocationBuilder builder = new RegistryLocationBuilder(item);
        if (index < 0 || index >= this.allowedRegistriesForImport.size()) {
            this._visitables.get("allowedRegistriesForImport").add(builder);
            this.allowedRegistriesForImport.add(builder);
        } else {
            this._visitables.get("allowedRegistriesForImport").set(index, builder);
            this.allowedRegistriesForImport.set(index, builder);
        }
        return (A)this;
    }

    public A addToAllowedRegistriesForImport(RegistryLocation ... items) {
        if (this.allowedRegistriesForImport == null) {
            this.allowedRegistriesForImport = new ArrayList();
        }
        for (RegistryLocation item : items) {
            RegistryLocationBuilder builder = new RegistryLocationBuilder(item);
            this._visitables.get("allowedRegistriesForImport").add(builder);
            this.allowedRegistriesForImport.add(builder);
        }
        return (A)this;
    }

    public A addAllToAllowedRegistriesForImport(Collection<RegistryLocation> items) {
        if (this.allowedRegistriesForImport == null) {
            this.allowedRegistriesForImport = new ArrayList();
        }
        for (RegistryLocation item : items) {
            RegistryLocationBuilder builder = new RegistryLocationBuilder(item);
            this._visitables.get("allowedRegistriesForImport").add(builder);
            this.allowedRegistriesForImport.add(builder);
        }
        return (A)this;
    }

    public A removeFromAllowedRegistriesForImport(RegistryLocation ... items) {
        if (this.allowedRegistriesForImport == null) {
            return (A)this;
        }
        for (RegistryLocation item : items) {
            RegistryLocationBuilder builder = new RegistryLocationBuilder(item);
            this._visitables.get("allowedRegistriesForImport").remove(builder);
            this.allowedRegistriesForImport.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromAllowedRegistriesForImport(Collection<RegistryLocation> items) {
        if (this.allowedRegistriesForImport == null) {
            return (A)this;
        }
        for (RegistryLocation item : items) {
            RegistryLocationBuilder builder = new RegistryLocationBuilder(item);
            this._visitables.get("allowedRegistriesForImport").remove(builder);
            this.allowedRegistriesForImport.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromAllowedRegistriesForImport(Predicate<RegistryLocationBuilder> predicate) {
        if (this.allowedRegistriesForImport == null) {
            return (A)this;
        }
        Iterator<RegistryLocationBuilder> each = this.allowedRegistriesForImport.iterator();
        Object visitables = this._visitables.get("allowedRegistriesForImport");
        while (each.hasNext()) {
            RegistryLocationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<RegistryLocation> buildAllowedRegistriesForImport() {
        return this.allowedRegistriesForImport != null ? ImageSpecFluent.build(this.allowedRegistriesForImport) : null;
    }

    public RegistryLocation buildAllowedRegistriesForImport(int index) {
        return this.allowedRegistriesForImport.get(index).build();
    }

    public RegistryLocation buildFirstAllowedRegistriesForImport() {
        return this.allowedRegistriesForImport.get(0).build();
    }

    public RegistryLocation buildLastAllowedRegistriesForImport() {
        return this.allowedRegistriesForImport.get(this.allowedRegistriesForImport.size() - 1).build();
    }

    public RegistryLocation buildMatchingAllowedRegistriesForImport(Predicate<RegistryLocationBuilder> predicate) {
        for (RegistryLocationBuilder item : this.allowedRegistriesForImport) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAllowedRegistriesForImport(Predicate<RegistryLocationBuilder> predicate) {
        for (RegistryLocationBuilder item : this.allowedRegistriesForImport) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAllowedRegistriesForImport(List<RegistryLocation> allowedRegistriesForImport) {
        if (this.allowedRegistriesForImport != null) {
            this._visitables.get("allowedRegistriesForImport").clear();
        }
        if (allowedRegistriesForImport != null) {
            this.allowedRegistriesForImport = new ArrayList();
            for (RegistryLocation item : allowedRegistriesForImport) {
                this.addToAllowedRegistriesForImport(item);
            }
        } else {
            this.allowedRegistriesForImport = null;
        }
        return (A)this;
    }

    public A withAllowedRegistriesForImport(RegistryLocation ... allowedRegistriesForImport) {
        if (this.allowedRegistriesForImport != null) {
            this.allowedRegistriesForImport.clear();
            this._visitables.remove("allowedRegistriesForImport");
        }
        if (allowedRegistriesForImport != null) {
            for (RegistryLocation item : allowedRegistriesForImport) {
                this.addToAllowedRegistriesForImport(item);
            }
        }
        return (A)this;
    }

    public boolean hasAllowedRegistriesForImport() {
        return this.allowedRegistriesForImport != null && !this.allowedRegistriesForImport.isEmpty();
    }

    public A addNewAllowedRegistriesForImport(String domainName, Boolean insecure) {
        return this.addToAllowedRegistriesForImport(new RegistryLocation(domainName, insecure));
    }

    public AllowedRegistriesForImportNested<A> addNewAllowedRegistriesForImport() {
        return new AllowedRegistriesForImportNested(-1, null);
    }

    public AllowedRegistriesForImportNested<A> addNewAllowedRegistriesForImportLike(RegistryLocation item) {
        return new AllowedRegistriesForImportNested(-1, item);
    }

    public AllowedRegistriesForImportNested<A> setNewAllowedRegistriesForImportLike(int index, RegistryLocation item) {
        return new AllowedRegistriesForImportNested(index, item);
    }

    public AllowedRegistriesForImportNested<A> editAllowedRegistriesForImport(int index) {
        if (this.allowedRegistriesForImport.size() <= index) {
            throw new RuntimeException("Can't edit allowedRegistriesForImport. Index exceeds size.");
        }
        return this.setNewAllowedRegistriesForImportLike(index, this.buildAllowedRegistriesForImport(index));
    }

    public AllowedRegistriesForImportNested<A> editFirstAllowedRegistriesForImport() {
        if (this.allowedRegistriesForImport.size() == 0) {
            throw new RuntimeException("Can't edit first allowedRegistriesForImport. The list is empty.");
        }
        return this.setNewAllowedRegistriesForImportLike(0, this.buildAllowedRegistriesForImport(0));
    }

    public AllowedRegistriesForImportNested<A> editLastAllowedRegistriesForImport() {
        int index = this.allowedRegistriesForImport.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last allowedRegistriesForImport. The list is empty.");
        }
        return this.setNewAllowedRegistriesForImportLike(index, this.buildAllowedRegistriesForImport(index));
    }

    public AllowedRegistriesForImportNested<A> editMatchingAllowedRegistriesForImport(Predicate<RegistryLocationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.allowedRegistriesForImport.size(); ++i) {
            if (!predicate.test(this.allowedRegistriesForImport.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching allowedRegistriesForImport. No match found.");
        }
        return this.setNewAllowedRegistriesForImportLike(index, this.buildAllowedRegistriesForImport(index));
    }

    public A addToExternalRegistryHostnames(int index, String item) {
        if (this.externalRegistryHostnames == null) {
            this.externalRegistryHostnames = new ArrayList<String>();
        }
        this.externalRegistryHostnames.add(index, item);
        return (A)this;
    }

    public A setToExternalRegistryHostnames(int index, String item) {
        if (this.externalRegistryHostnames == null) {
            this.externalRegistryHostnames = new ArrayList<String>();
        }
        this.externalRegistryHostnames.set(index, item);
        return (A)this;
    }

    public A addToExternalRegistryHostnames(String ... items) {
        if (this.externalRegistryHostnames == null) {
            this.externalRegistryHostnames = new ArrayList<String>();
        }
        for (String item : items) {
            this.externalRegistryHostnames.add(item);
        }
        return (A)this;
    }

    public A addAllToExternalRegistryHostnames(Collection<String> items) {
        if (this.externalRegistryHostnames == null) {
            this.externalRegistryHostnames = new ArrayList<String>();
        }
        for (String item : items) {
            this.externalRegistryHostnames.add(item);
        }
        return (A)this;
    }

    public A removeFromExternalRegistryHostnames(String ... items) {
        if (this.externalRegistryHostnames == null) {
            return (A)this;
        }
        for (String item : items) {
            this.externalRegistryHostnames.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromExternalRegistryHostnames(Collection<String> items) {
        if (this.externalRegistryHostnames == null) {
            return (A)this;
        }
        for (String item : items) {
            this.externalRegistryHostnames.remove(item);
        }
        return (A)this;
    }

    public List<String> getExternalRegistryHostnames() {
        return this.externalRegistryHostnames;
    }

    public String getExternalRegistryHostname(int index) {
        return this.externalRegistryHostnames.get(index);
    }

    public String getFirstExternalRegistryHostname() {
        return this.externalRegistryHostnames.get(0);
    }

    public String getLastExternalRegistryHostname() {
        return this.externalRegistryHostnames.get(this.externalRegistryHostnames.size() - 1);
    }

    public String getMatchingExternalRegistryHostname(Predicate<String> predicate) {
        for (String item : this.externalRegistryHostnames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingExternalRegistryHostname(Predicate<String> predicate) {
        for (String item : this.externalRegistryHostnames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withExternalRegistryHostnames(List<String> externalRegistryHostnames) {
        if (externalRegistryHostnames != null) {
            this.externalRegistryHostnames = new ArrayList<String>();
            for (String item : externalRegistryHostnames) {
                this.addToExternalRegistryHostnames(item);
            }
        } else {
            this.externalRegistryHostnames = null;
        }
        return (A)this;
    }

    public A withExternalRegistryHostnames(String ... externalRegistryHostnames) {
        if (this.externalRegistryHostnames != null) {
            this.externalRegistryHostnames.clear();
            this._visitables.remove("externalRegistryHostnames");
        }
        if (externalRegistryHostnames != null) {
            for (String item : externalRegistryHostnames) {
                this.addToExternalRegistryHostnames(item);
            }
        }
        return (A)this;
    }

    public boolean hasExternalRegistryHostnames() {
        return this.externalRegistryHostnames != null && !this.externalRegistryHostnames.isEmpty();
    }

    public RegistrySources buildRegistrySources() {
        return this.registrySources != null ? this.registrySources.build() : null;
    }

    public A withRegistrySources(RegistrySources registrySources) {
        this._visitables.remove("registrySources");
        if (registrySources != null) {
            this.registrySources = new RegistrySourcesBuilder(registrySources);
            this._visitables.get("registrySources").add(this.registrySources);
        } else {
            this.registrySources = null;
            this._visitables.get("registrySources").remove(this.registrySources);
        }
        return (A)this;
    }

    public boolean hasRegistrySources() {
        return this.registrySources != null;
    }

    public RegistrySourcesNested<A> withNewRegistrySources() {
        return new RegistrySourcesNested(null);
    }

    public RegistrySourcesNested<A> withNewRegistrySourcesLike(RegistrySources item) {
        return new RegistrySourcesNested(item);
    }

    public RegistrySourcesNested<A> editRegistrySources() {
        return this.withNewRegistrySourcesLike(Optional.ofNullable(this.buildRegistrySources()).orElse(null));
    }

    public RegistrySourcesNested<A> editOrNewRegistrySources() {
        return this.withNewRegistrySourcesLike(Optional.ofNullable(this.buildRegistrySources()).orElse(new RegistrySourcesBuilder().build()));
    }

    public RegistrySourcesNested<A> editOrNewRegistrySourcesLike(RegistrySources item) {
        return this.withNewRegistrySourcesLike(Optional.ofNullable(this.buildRegistrySources()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageSpecFluent that = (ImageSpecFluent)o;
        if (!Objects.equals(this.additionalTrustedCA, that.additionalTrustedCA)) {
            return false;
        }
        if (!Objects.equals(this.allowedRegistriesForImport, that.allowedRegistriesForImport)) {
            return false;
        }
        if (!Objects.equals(this.externalRegistryHostnames, that.externalRegistryHostnames)) {
            return false;
        }
        if (!Objects.equals(this.registrySources, that.registrySources)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.additionalTrustedCA, this.allowedRegistriesForImport, this.externalRegistryHostnames, this.registrySources, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.additionalTrustedCA != null) {
            sb.append("additionalTrustedCA:");
            sb.append(this.additionalTrustedCA + ",");
        }
        if (this.allowedRegistriesForImport != null && !this.allowedRegistriesForImport.isEmpty()) {
            sb.append("allowedRegistriesForImport:");
            sb.append(this.allowedRegistriesForImport + ",");
        }
        if (this.externalRegistryHostnames != null && !this.externalRegistryHostnames.isEmpty()) {
            sb.append("externalRegistryHostnames:");
            sb.append(this.externalRegistryHostnames + ",");
        }
        if (this.registrySources != null) {
            sb.append("registrySources:");
            sb.append(this.registrySources + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RegistrySourcesNested<N>
    extends RegistrySourcesFluent<RegistrySourcesNested<N>>
    implements Nested<N> {
        RegistrySourcesBuilder builder;

        RegistrySourcesNested(RegistrySources item) {
            this.builder = new RegistrySourcesBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageSpecFluent.this.withRegistrySources(this.builder.build());
        }

        public N endRegistrySources() {
            return this.and();
        }
    }

    public class AllowedRegistriesForImportNested<N>
    extends RegistryLocationFluent<AllowedRegistriesForImportNested<N>>
    implements Nested<N> {
        RegistryLocationBuilder builder;
        int index;

        AllowedRegistriesForImportNested(int index, RegistryLocation item) {
            this.index = index;
            this.builder = new RegistryLocationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageSpecFluent.this.setToAllowedRegistriesForImport(this.index, this.builder.build());
        }

        public N endAllowedRegistriesForImport() {
            return this.and();
        }
    }

    public class AdditionalTrustedCANested<N>
    extends ConfigMapNameReferenceFluent<AdditionalTrustedCANested<N>>
    implements Nested<N> {
        ConfigMapNameReferenceBuilder builder;

        AdditionalTrustedCANested(ConfigMapNameReference item) {
            this.builder = new ConfigMapNameReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageSpecFluent.this.withAdditionalTrustedCA(this.builder.build());
        }

        public N endAdditionalTrustedCA() {
            return this.and();
        }
    }
}

