/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_9;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.kubernetes.api.model.v6_9.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.v6_9.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.v6_9.PodTemplateSpecFluent;
import io.fabric8.openshift.api.model.v6_9.PodSecurityPolicyReviewSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PodSecurityPolicyReviewSpecFluent<A extends PodSecurityPolicyReviewSpecFluent<A>>
extends BaseFluent<A> {
    private List<String> serviceAccountNames = new ArrayList<String>();
    private PodTemplateSpecBuilder template;
    private Map<String, Object> additionalProperties;

    public PodSecurityPolicyReviewSpecFluent() {
    }

    public PodSecurityPolicyReviewSpecFluent(PodSecurityPolicyReviewSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PodSecurityPolicyReviewSpec instance) {
        PodSecurityPolicyReviewSpec podSecurityPolicyReviewSpec = instance = instance != null ? instance : new PodSecurityPolicyReviewSpec();
        if (instance != null) {
            this.withServiceAccountNames(instance.getServiceAccountNames());
            this.withTemplate(instance.getTemplate());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToServiceAccountNames(int index, String item) {
        if (this.serviceAccountNames == null) {
            this.serviceAccountNames = new ArrayList<String>();
        }
        this.serviceAccountNames.add(index, item);
        return (A)this;
    }

    public A setToServiceAccountNames(int index, String item) {
        if (this.serviceAccountNames == null) {
            this.serviceAccountNames = new ArrayList<String>();
        }
        this.serviceAccountNames.set(index, item);
        return (A)this;
    }

    public A addToServiceAccountNames(String ... items) {
        if (this.serviceAccountNames == null) {
            this.serviceAccountNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.serviceAccountNames.add(item);
        }
        return (A)this;
    }

    public A addAllToServiceAccountNames(Collection<String> items) {
        if (this.serviceAccountNames == null) {
            this.serviceAccountNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.serviceAccountNames.add(item);
        }
        return (A)this;
    }

    public A removeFromServiceAccountNames(String ... items) {
        if (this.serviceAccountNames == null) {
            return (A)this;
        }
        for (String item : items) {
            this.serviceAccountNames.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromServiceAccountNames(Collection<String> items) {
        if (this.serviceAccountNames == null) {
            return (A)this;
        }
        for (String item : items) {
            this.serviceAccountNames.remove(item);
        }
        return (A)this;
    }

    public List<String> getServiceAccountNames() {
        return this.serviceAccountNames;
    }

    public String getServiceAccountName(int index) {
        return this.serviceAccountNames.get(index);
    }

    public String getFirstServiceAccountName() {
        return this.serviceAccountNames.get(0);
    }

    public String getLastServiceAccountName() {
        return this.serviceAccountNames.get(this.serviceAccountNames.size() - 1);
    }

    public String getMatchingServiceAccountName(Predicate<String> predicate) {
        for (String item : this.serviceAccountNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingServiceAccountName(Predicate<String> predicate) {
        for (String item : this.serviceAccountNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withServiceAccountNames(List<String> serviceAccountNames) {
        if (serviceAccountNames != null) {
            this.serviceAccountNames = new ArrayList<String>();
            for (String item : serviceAccountNames) {
                this.addToServiceAccountNames(item);
            }
        } else {
            this.serviceAccountNames = null;
        }
        return (A)this;
    }

    public A withServiceAccountNames(String ... serviceAccountNames) {
        if (this.serviceAccountNames != null) {
            this.serviceAccountNames.clear();
            this._visitables.remove("serviceAccountNames");
        }
        if (serviceAccountNames != null) {
            for (String item : serviceAccountNames) {
                this.addToServiceAccountNames(item);
            }
        }
        return (A)this;
    }

    public boolean hasServiceAccountNames() {
        return this.serviceAccountNames != null && !this.serviceAccountNames.isEmpty();
    }

    public PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    public A withTemplate(PodTemplateSpec template) {
        this._visitables.remove("template");
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.get("template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get("template").remove(this.template);
        }
        return (A)this;
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public TemplateNested<A> withNewTemplate() {
        return new TemplateNested(null);
    }

    public TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNested(item);
    }

    public TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(null));
    }

    public TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(new PodTemplateSpecBuilder().build()));
    }

    public TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodSecurityPolicyReviewSpecFluent that = (PodSecurityPolicyReviewSpecFluent)o;
        if (!Objects.equals(this.serviceAccountNames, that.serviceAccountNames)) {
            return false;
        }
        if (!Objects.equals(this.template, that.template)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.serviceAccountNames, this.template, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.serviceAccountNames != null && !this.serviceAccountNames.isEmpty()) {
            sb.append("serviceAccountNames:");
            sb.append(this.serviceAccountNames + ",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append(this.template + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TemplateNested<N>
    extends PodTemplateSpecFluent<TemplateNested<N>>
    implements Nested<N> {
        PodTemplateSpecBuilder builder;

        TemplateNested(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodSecurityPolicyReviewSpecFluent.this.withTemplate(this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }
}

