/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_9;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.kubernetes.api.model.v6_9.ObjectMeta;
import io.fabric8.kubernetes.api.model.v6_9.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v6_9.ObjectMetaFluent;
import io.fabric8.openshift.api.model.v6_9.Image;
import io.fabric8.openshift.api.model.v6_9.ImageBuilder;
import io.fabric8.openshift.api.model.v6_9.ImageFluent;
import io.fabric8.openshift.api.model.v6_9.ImageLookupPolicy;
import io.fabric8.openshift.api.model.v6_9.ImageLookupPolicyBuilder;
import io.fabric8.openshift.api.model.v6_9.ImageLookupPolicyFluent;
import io.fabric8.openshift.api.model.v6_9.ImageStreamTag;
import io.fabric8.openshift.api.model.v6_9.TagEventCondition;
import io.fabric8.openshift.api.model.v6_9.TagEventConditionBuilder;
import io.fabric8.openshift.api.model.v6_9.TagEventConditionFluent;
import io.fabric8.openshift.api.model.v6_9.TagReference;
import io.fabric8.openshift.api.model.v6_9.TagReferenceBuilder;
import io.fabric8.openshift.api.model.v6_9.TagReferenceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ImageStreamTagFluent<A extends ImageStreamTagFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private ArrayList<TagEventConditionBuilder> conditions = new ArrayList();
    private Long generation;
    private ImageBuilder image;
    private String kind;
    private ImageLookupPolicyBuilder lookupPolicy;
    private ObjectMetaBuilder metadata;
    private TagReferenceBuilder tag;
    private Map<String, Object> additionalProperties;

    public ImageStreamTagFluent() {
    }

    public ImageStreamTagFluent(ImageStreamTag instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ImageStreamTag instance) {
        ImageStreamTag imageStreamTag = instance = instance != null ? instance : new ImageStreamTag();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withConditions(instance.getConditions());
            this.withGeneration(instance.getGeneration());
            this.withImage(instance.getImage());
            this.withKind(instance.getKind());
            this.withLookupPolicy(instance.getLookupPolicy());
            this.withMetadata(instance.getMetadata());
            this.withTag(instance.getTag());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A addToConditions(int index, TagEventCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, TagEventCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(TagEventCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (TagEventCondition item : items) {
            TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<TagEventCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (TagEventCondition item : items) {
            TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(TagEventCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (TagEventCondition item : items) {
            TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<TagEventCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (TagEventCondition item : items) {
            TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<TagEventConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<TagEventConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            TagEventConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<TagEventCondition> buildConditions() {
        return this.conditions != null ? ImageStreamTagFluent.build(this.conditions) : null;
    }

    public TagEventCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public TagEventCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public TagEventCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public TagEventCondition buildMatchingCondition(Predicate<TagEventConditionBuilder> predicate) {
        for (TagEventConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<TagEventConditionBuilder> predicate) {
        for (TagEventConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<TagEventCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (TagEventCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(TagEventCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (TagEventCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(TagEventCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, TagEventCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<TagEventConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public Long getGeneration() {
        return this.generation;
    }

    public A withGeneration(Long generation) {
        this.generation = generation;
        return (A)this;
    }

    public boolean hasGeneration() {
        return this.generation != null;
    }

    public Image buildImage() {
        return this.image != null ? this.image.build() : null;
    }

    public A withImage(Image image) {
        this._visitables.remove("image");
        if (image != null) {
            this.image = new ImageBuilder(image);
            this._visitables.get("image").add(this.image);
        } else {
            this.image = null;
            this._visitables.get("image").remove(this.image);
        }
        return (A)this;
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public ImageNested<A> withNewImage() {
        return new ImageNested(null);
    }

    public ImageNested<A> withNewImageLike(Image item) {
        return new ImageNested(item);
    }

    public ImageNested<A> editImage() {
        return this.withNewImageLike(Optional.ofNullable(this.buildImage()).orElse(null));
    }

    public ImageNested<A> editOrNewImage() {
        return this.withNewImageLike(Optional.ofNullable(this.buildImage()).orElse(new ImageBuilder().build()));
    }

    public ImageNested<A> editOrNewImageLike(Image item) {
        return this.withNewImageLike(Optional.ofNullable(this.buildImage()).orElse(item));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ImageLookupPolicy buildLookupPolicy() {
        return this.lookupPolicy != null ? this.lookupPolicy.build() : null;
    }

    public A withLookupPolicy(ImageLookupPolicy lookupPolicy) {
        this._visitables.remove("lookupPolicy");
        if (lookupPolicy != null) {
            this.lookupPolicy = new ImageLookupPolicyBuilder(lookupPolicy);
            this._visitables.get("lookupPolicy").add(this.lookupPolicy);
        } else {
            this.lookupPolicy = null;
            this._visitables.get("lookupPolicy").remove(this.lookupPolicy);
        }
        return (A)this;
    }

    public boolean hasLookupPolicy() {
        return this.lookupPolicy != null;
    }

    public A withNewLookupPolicy(Boolean local) {
        return this.withLookupPolicy(new ImageLookupPolicy(local));
    }

    public LookupPolicyNested<A> withNewLookupPolicy() {
        return new LookupPolicyNested(null);
    }

    public LookupPolicyNested<A> withNewLookupPolicyLike(ImageLookupPolicy item) {
        return new LookupPolicyNested(item);
    }

    public LookupPolicyNested<A> editLookupPolicy() {
        return this.withNewLookupPolicyLike(Optional.ofNullable(this.buildLookupPolicy()).orElse(null));
    }

    public LookupPolicyNested<A> editOrNewLookupPolicy() {
        return this.withNewLookupPolicyLike(Optional.ofNullable(this.buildLookupPolicy()).orElse(new ImageLookupPolicyBuilder().build()));
    }

    public LookupPolicyNested<A> editOrNewLookupPolicyLike(ImageLookupPolicy item) {
        return this.withNewLookupPolicyLike(Optional.ofNullable(this.buildLookupPolicy()).orElse(item));
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public TagReference buildTag() {
        return this.tag != null ? this.tag.build() : null;
    }

    public A withTag(TagReference tag) {
        this._visitables.remove("tag");
        if (tag != null) {
            this.tag = new TagReferenceBuilder(tag);
            this._visitables.get("tag").add(this.tag);
        } else {
            this.tag = null;
            this._visitables.get("tag").remove(this.tag);
        }
        return (A)this;
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    public TagNested<A> withNewTag() {
        return new TagNested(null);
    }

    public TagNested<A> withNewTagLike(TagReference item) {
        return new TagNested(item);
    }

    public TagNested<A> editTag() {
        return this.withNewTagLike(Optional.ofNullable(this.buildTag()).orElse(null));
    }

    public TagNested<A> editOrNewTag() {
        return this.withNewTagLike(Optional.ofNullable(this.buildTag()).orElse(new TagReferenceBuilder().build()));
    }

    public TagNested<A> editOrNewTagLike(TagReference item) {
        return this.withNewTagLike(Optional.ofNullable(this.buildTag()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageStreamTagFluent that = (ImageStreamTagFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.generation, that.generation)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.lookupPolicy, that.lookupPolicy)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.tag, that.tag)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.conditions, this.generation, this.image, this.kind, this.lookupPolicy, this.metadata, this.tag, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.generation != null) {
            sb.append("generation:");
            sb.append(this.generation + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.lookupPolicy != null) {
            sb.append("lookupPolicy:");
            sb.append(this.lookupPolicy + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.tag != null) {
            sb.append("tag:");
            sb.append(this.tag + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TagNested<N>
    extends TagReferenceFluent<TagNested<N>>
    implements Nested<N> {
        TagReferenceBuilder builder;

        TagNested(TagReference item) {
            this.builder = new TagReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageStreamTagFluent.this.withTag(this.builder.build());
        }

        public N endTag() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageStreamTagFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class LookupPolicyNested<N>
    extends ImageLookupPolicyFluent<LookupPolicyNested<N>>
    implements Nested<N> {
        ImageLookupPolicyBuilder builder;

        LookupPolicyNested(ImageLookupPolicy item) {
            this.builder = new ImageLookupPolicyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageStreamTagFluent.this.withLookupPolicy(this.builder.build());
        }

        public N endLookupPolicy() {
            return this.and();
        }
    }

    public class ImageNested<N>
    extends ImageFluent<ImageNested<N>>
    implements Nested<N> {
        ImageBuilder builder;

        ImageNested(Image item) {
            this.builder = new ImageBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageStreamTagFluent.this.withImage(this.builder.build());
        }

        public N endImage() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends TagEventConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        TagEventConditionBuilder builder;
        int index;

        ConditionsNested(int index, TagEventCondition item) {
            this.index = index;
            this.builder = new TagEventConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageStreamTagFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

