/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_9;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.model.v6_9.EnvVar;
import io.fabric8.openshift.api.model.v6_9.DockerStrategyOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DockerStrategyOptionsFluent<A extends DockerStrategyOptionsFluent<A>>
extends BaseFluent<A> {
    private List<EnvVar> buildArgs = new ArrayList<EnvVar>();
    private Boolean noCache;
    private Map<String, Object> additionalProperties;

    public DockerStrategyOptionsFluent() {
    }

    public DockerStrategyOptionsFluent(DockerStrategyOptions instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DockerStrategyOptions instance) {
        DockerStrategyOptions dockerStrategyOptions = instance = instance != null ? instance : new DockerStrategyOptions();
        if (instance != null) {
            this.withBuildArgs(instance.getBuildArgs());
            this.withNoCache(instance.getNoCache());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToBuildArgs(int index, EnvVar item) {
        if (this.buildArgs == null) {
            this.buildArgs = new ArrayList<EnvVar>();
        }
        this.buildArgs.add(index, item);
        return (A)this;
    }

    public A setToBuildArgs(int index, EnvVar item) {
        if (this.buildArgs == null) {
            this.buildArgs = new ArrayList<EnvVar>();
        }
        this.buildArgs.set(index, item);
        return (A)this;
    }

    public A addToBuildArgs(EnvVar ... items) {
        if (this.buildArgs == null) {
            this.buildArgs = new ArrayList<EnvVar>();
        }
        for (EnvVar item : items) {
            this.buildArgs.add(item);
        }
        return (A)this;
    }

    public A addAllToBuildArgs(Collection<EnvVar> items) {
        if (this.buildArgs == null) {
            this.buildArgs = new ArrayList<EnvVar>();
        }
        for (EnvVar item : items) {
            this.buildArgs.add(item);
        }
        return (A)this;
    }

    public A removeFromBuildArgs(EnvVar ... items) {
        if (this.buildArgs == null) {
            return (A)this;
        }
        for (EnvVar item : items) {
            this.buildArgs.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromBuildArgs(Collection<EnvVar> items) {
        if (this.buildArgs == null) {
            return (A)this;
        }
        for (EnvVar item : items) {
            this.buildArgs.remove(item);
        }
        return (A)this;
    }

    public List<EnvVar> getBuildArgs() {
        return this.buildArgs;
    }

    public EnvVar getBuildArg(int index) {
        return this.buildArgs.get(index);
    }

    public EnvVar getFirstBuildArg() {
        return this.buildArgs.get(0);
    }

    public EnvVar getLastBuildArg() {
        return this.buildArgs.get(this.buildArgs.size() - 1);
    }

    public EnvVar getMatchingBuildArg(Predicate<EnvVar> predicate) {
        for (EnvVar item : this.buildArgs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingBuildArg(Predicate<EnvVar> predicate) {
        for (EnvVar item : this.buildArgs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withBuildArgs(List<EnvVar> buildArgs) {
        if (buildArgs != null) {
            this.buildArgs = new ArrayList<EnvVar>();
            for (EnvVar item : buildArgs) {
                this.addToBuildArgs(item);
            }
        } else {
            this.buildArgs = null;
        }
        return (A)this;
    }

    public A withBuildArgs(EnvVar ... buildArgs) {
        if (this.buildArgs != null) {
            this.buildArgs.clear();
            this._visitables.remove("buildArgs");
        }
        if (buildArgs != null) {
            for (EnvVar item : buildArgs) {
                this.addToBuildArgs(item);
            }
        }
        return (A)this;
    }

    public boolean hasBuildArgs() {
        return this.buildArgs != null && !this.buildArgs.isEmpty();
    }

    public Boolean getNoCache() {
        return this.noCache;
    }

    public A withNoCache(Boolean noCache) {
        this.noCache = noCache;
        return (A)this;
    }

    public boolean hasNoCache() {
        return this.noCache != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DockerStrategyOptionsFluent that = (DockerStrategyOptionsFluent)o;
        if (!Objects.equals(this.buildArgs, that.buildArgs)) {
            return false;
        }
        if (!Objects.equals(this.noCache, that.noCache)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.buildArgs, this.noCache, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.buildArgs != null && !this.buildArgs.isEmpty()) {
            sb.append("buildArgs:");
            sb.append(this.buildArgs + ",");
        }
        if (this.noCache != null) {
            sb.append("noCache:");
            sb.append(this.noCache + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withNoCache() {
        return this.withNoCache(true);
    }
}

