/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_9.dsl.internal.core.v1;

import io.fabric8.kubernetes.api.model.v6_9.ServiceAccount;
import io.fabric8.kubernetes.api.model.v6_9.ServiceAccountList;
import io.fabric8.kubernetes.api.model.v6_9.authentication.TokenRequest;
import io.fabric8.kubernetes.clnt.v6_9.Client;
import io.fabric8.kubernetes.clnt.v6_9.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v6_9.OperationInfo;
import io.fabric8.kubernetes.clnt.v6_9.dsl.ServiceAccountResource;
import io.fabric8.kubernetes.clnt.v6_9.dsl.internal.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v6_9.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.clnt.v6_9.dsl.internal.OperationContext;
import io.fabric8.kubernetes.clnt.v6_9.http.HttpRequest;
import io.fabric8.kubernetes.clnt.v6_9.utils.URLUtils;
import java.io.IOException;
import java.net.URL;

public class ServiceAccountOperationsImpl
extends HasMetadataOperation<ServiceAccount, ServiceAccountList, ServiceAccountResource>
implements ServiceAccountResource {
    public ServiceAccountOperationsImpl(Client client) {
        this(HasMetadataOperationsImpl.defaultContext(client));
    }

    private ServiceAccountOperationsImpl(OperationContext context) {
        super(context.withPlural("serviceaccounts"), ServiceAccount.class, ServiceAccountList.class);
    }

    @Override
    public ServiceAccountOperationsImpl newInstance(OperationContext context) {
        return new ServiceAccountOperationsImpl(context);
    }

    public TokenRequest tokenRequest(TokenRequest tokenRequest) {
        return this.handleTokenRequest(tokenRequest);
    }

    private TokenRequest handleTokenRequest(TokenRequest tokenRequest) {
        try {
            URL requestUrl = new URL(URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), "token"}));
            HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().post("application/json", this.getKubernetesSerialization().asJson((Object)tokenRequest)).url(requestUrl);
            return this.handleResponse(requestBuilder, TokenRequest.class);
        }
        catch (IOException exception) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("token request"), (Throwable)exception);
        }
    }
}

