/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_9.dsl.internal.apps.v1;

import io.fabric8.kubernetes.api.model.v6_9.Pod;
import io.fabric8.kubernetes.api.model.v6_9.PodList;
import io.fabric8.kubernetes.api.model.v6_9.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.v6_9.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.v6_9.apps.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.v6_9.apps.ReplicaSetFluent;
import io.fabric8.kubernetes.api.model.v6_9.apps.ReplicaSetList;
import io.fabric8.kubernetes.api.model.v6_9.apps.ReplicaSetSpecFluent;
import io.fabric8.kubernetes.clnt.v6_9.Client;
import io.fabric8.kubernetes.clnt.v6_9.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.clnt.v6_9.dsl.MixedOperation;
import io.fabric8.kubernetes.clnt.v6_9.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v6_9.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v6_9.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v6_9.dsl.internal.apps.v1.ReplicaSetOperationsImpl;
import io.fabric8.kubernetes.clnt.v6_9.dsl.internal.apps.v1.RollingUpdater;

class ReplicaSetRollingUpdater
extends RollingUpdater<ReplicaSet, ReplicaSetList> {
    ReplicaSetRollingUpdater(Client client, String namespace, long rollingTimeoutMillis, long loggingIntervalMillis) {
        super(client, namespace, rollingTimeoutMillis, loggingIntervalMillis);
    }

    @Override
    protected ReplicaSet createClone(ReplicaSet obj, String newName, String newDeploymentHash) {
        return ((ReplicaSetBuilder)((ReplicaSetFluent.SpecNested)((ReplicaSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((ReplicaSetFluent.SpecNested)((ReplicaSetSpecFluent.SelectorNested)((ReplicaSetFluent.SpecNested)((ReplicaSetBuilder)((ReplicaSetFluent.MetadataNested)((ReplicaSetFluent.MetadataNested)new ReplicaSetBuilder(obj).editMetadata().withResourceVersion(null)).withName(newName)).endMetadata()).editSpec().withReplicas(0)).editSelector().addToMatchLabels("deployment", newDeploymentHash)).endSelector()).editTemplate().editMetadata().addToLabels("deployment", newDeploymentHash)).endMetadata()).endTemplate()).endSpec()).build();
    }

    @Override
    protected FilterWatchListDeletable<Pod, PodList, PodResource> selectedPodLister(ReplicaSet obj) {
        return this.selectedPodLister(obj.getSpec().getSelector());
    }

    @Override
    protected ReplicaSet updateDeploymentKey(String name, String hash) {
        return (ReplicaSet)((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(this.namespace)).withName(name)).edit(old -> ((ReplicaSetBuilder)((ReplicaSetFluent.SpecNested)((ReplicaSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((ReplicaSetFluent.SpecNested)((ReplicaSetSpecFluent.SelectorNested)new ReplicaSetBuilder((ReplicaSet)old).editSpec().editSelector().addToMatchLabels("deployment", hash)).endSelector()).editTemplate().editMetadata().addToLabels("deployment", hash)).endMetadata()).endTemplate()).endSpec()).build());
    }

    @Override
    protected ReplicaSet removeDeploymentKey(String name) {
        return (ReplicaSet)((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(this.namespace)).withName(name)).edit(old -> ((ReplicaSetBuilder)((ReplicaSetFluent.SpecNested)((ReplicaSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((ReplicaSetFluent.SpecNested)((ReplicaSetSpecFluent.SelectorNested)new ReplicaSetBuilder((ReplicaSet)old).editSpec().editSelector().removeFromMatchLabels("deployment")).endSelector()).editTemplate().editMetadata().removeFromLabels("deployment")).endMetadata()).endTemplate()).endSpec()).build());
    }

    @Override
    protected int getReplicas(ReplicaSet obj) {
        return obj.getSpec().getReplicas();
    }

    @Override
    protected ReplicaSet setReplicas(ReplicaSet obj, int replicas) {
        return ((ReplicaSetBuilder)((ReplicaSetFluent.SpecNested)new ReplicaSetBuilder(obj).editSpec().withReplicas(replicas)).endSpec()).build();
    }

    @Override
    protected MixedOperation<ReplicaSet, ReplicaSetList, RollableScalableResource<ReplicaSet>> resources() {
        return new ReplicaSetOperationsImpl(this.client);
    }
}

