/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_9.internal.apiserver.v1alpha1;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.model.v6_9.internal.apiserver.v1alpha1.ServerStorageVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ServerStorageVersionFluent<A extends ServerStorageVersionFluent<A>>
extends BaseFluent<A> {
    private String apiServerID;
    private List<String> decodableVersions = new ArrayList<String>();
    private String encodingVersion;
    private List<String> servedVersions = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public ServerStorageVersionFluent() {
    }

    public ServerStorageVersionFluent(ServerStorageVersion instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ServerStorageVersion instance) {
        ServerStorageVersion serverStorageVersion = instance = instance != null ? instance : new ServerStorageVersion();
        if (instance != null) {
            this.withApiServerID(instance.getApiServerID());
            this.withDecodableVersions(instance.getDecodableVersions());
            this.withEncodingVersion(instance.getEncodingVersion());
            this.withServedVersions(instance.getServedVersions());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiServerID() {
        return this.apiServerID;
    }

    public A withApiServerID(String apiServerID) {
        this.apiServerID = apiServerID;
        return (A)this;
    }

    public boolean hasApiServerID() {
        return this.apiServerID != null;
    }

    public A addToDecodableVersions(int index, String item) {
        if (this.decodableVersions == null) {
            this.decodableVersions = new ArrayList<String>();
        }
        this.decodableVersions.add(index, item);
        return (A)this;
    }

    public A setToDecodableVersions(int index, String item) {
        if (this.decodableVersions == null) {
            this.decodableVersions = new ArrayList<String>();
        }
        this.decodableVersions.set(index, item);
        return (A)this;
    }

    public A addToDecodableVersions(String ... items) {
        if (this.decodableVersions == null) {
            this.decodableVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.decodableVersions.add(item);
        }
        return (A)this;
    }

    public A addAllToDecodableVersions(Collection<String> items) {
        if (this.decodableVersions == null) {
            this.decodableVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.decodableVersions.add(item);
        }
        return (A)this;
    }

    public A removeFromDecodableVersions(String ... items) {
        if (this.decodableVersions == null) {
            return (A)this;
        }
        for (String item : items) {
            this.decodableVersions.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromDecodableVersions(Collection<String> items) {
        if (this.decodableVersions == null) {
            return (A)this;
        }
        for (String item : items) {
            this.decodableVersions.remove(item);
        }
        return (A)this;
    }

    public List<String> getDecodableVersions() {
        return this.decodableVersions;
    }

    public String getDecodableVersion(int index) {
        return this.decodableVersions.get(index);
    }

    public String getFirstDecodableVersion() {
        return this.decodableVersions.get(0);
    }

    public String getLastDecodableVersion() {
        return this.decodableVersions.get(this.decodableVersions.size() - 1);
    }

    public String getMatchingDecodableVersion(Predicate<String> predicate) {
        for (String item : this.decodableVersions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingDecodableVersion(Predicate<String> predicate) {
        for (String item : this.decodableVersions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDecodableVersions(List<String> decodableVersions) {
        if (decodableVersions != null) {
            this.decodableVersions = new ArrayList<String>();
            for (String item : decodableVersions) {
                this.addToDecodableVersions(item);
            }
        } else {
            this.decodableVersions = null;
        }
        return (A)this;
    }

    public A withDecodableVersions(String ... decodableVersions) {
        if (this.decodableVersions != null) {
            this.decodableVersions.clear();
            this._visitables.remove("decodableVersions");
        }
        if (decodableVersions != null) {
            for (String item : decodableVersions) {
                this.addToDecodableVersions(item);
            }
        }
        return (A)this;
    }

    public boolean hasDecodableVersions() {
        return this.decodableVersions != null && !this.decodableVersions.isEmpty();
    }

    public String getEncodingVersion() {
        return this.encodingVersion;
    }

    public A withEncodingVersion(String encodingVersion) {
        this.encodingVersion = encodingVersion;
        return (A)this;
    }

    public boolean hasEncodingVersion() {
        return this.encodingVersion != null;
    }

    public A addToServedVersions(int index, String item) {
        if (this.servedVersions == null) {
            this.servedVersions = new ArrayList<String>();
        }
        this.servedVersions.add(index, item);
        return (A)this;
    }

    public A setToServedVersions(int index, String item) {
        if (this.servedVersions == null) {
            this.servedVersions = new ArrayList<String>();
        }
        this.servedVersions.set(index, item);
        return (A)this;
    }

    public A addToServedVersions(String ... items) {
        if (this.servedVersions == null) {
            this.servedVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.servedVersions.add(item);
        }
        return (A)this;
    }

    public A addAllToServedVersions(Collection<String> items) {
        if (this.servedVersions == null) {
            this.servedVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.servedVersions.add(item);
        }
        return (A)this;
    }

    public A removeFromServedVersions(String ... items) {
        if (this.servedVersions == null) {
            return (A)this;
        }
        for (String item : items) {
            this.servedVersions.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromServedVersions(Collection<String> items) {
        if (this.servedVersions == null) {
            return (A)this;
        }
        for (String item : items) {
            this.servedVersions.remove(item);
        }
        return (A)this;
    }

    public List<String> getServedVersions() {
        return this.servedVersions;
    }

    public String getServedVersion(int index) {
        return this.servedVersions.get(index);
    }

    public String getFirstServedVersion() {
        return this.servedVersions.get(0);
    }

    public String getLastServedVersion() {
        return this.servedVersions.get(this.servedVersions.size() - 1);
    }

    public String getMatchingServedVersion(Predicate<String> predicate) {
        for (String item : this.servedVersions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingServedVersion(Predicate<String> predicate) {
        for (String item : this.servedVersions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withServedVersions(List<String> servedVersions) {
        if (servedVersions != null) {
            this.servedVersions = new ArrayList<String>();
            for (String item : servedVersions) {
                this.addToServedVersions(item);
            }
        } else {
            this.servedVersions = null;
        }
        return (A)this;
    }

    public A withServedVersions(String ... servedVersions) {
        if (this.servedVersions != null) {
            this.servedVersions.clear();
            this._visitables.remove("servedVersions");
        }
        if (servedVersions != null) {
            for (String item : servedVersions) {
                this.addToServedVersions(item);
            }
        }
        return (A)this;
    }

    public boolean hasServedVersions() {
        return this.servedVersions != null && !this.servedVersions.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServerStorageVersionFluent that = (ServerStorageVersionFluent)o;
        if (!Objects.equals(this.apiServerID, that.apiServerID)) {
            return false;
        }
        if (!Objects.equals(this.decodableVersions, that.decodableVersions)) {
            return false;
        }
        if (!Objects.equals(this.encodingVersion, that.encodingVersion)) {
            return false;
        }
        if (!Objects.equals(this.servedVersions, that.servedVersions)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiServerID, this.decodableVersions, this.encodingVersion, this.servedVersions, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiServerID != null) {
            sb.append("apiServerID:");
            sb.append(this.apiServerID + ",");
        }
        if (this.decodableVersions != null && !this.decodableVersions.isEmpty()) {
            sb.append("decodableVersions:");
            sb.append(this.decodableVersions + ",");
        }
        if (this.encodingVersion != null) {
            sb.append("encodingVersion:");
            sb.append(this.encodingVersion + ",");
        }
        if (this.servedVersions != null && !this.servedVersions.isEmpty()) {
            sb.append("servedVersions:");
            sb.append(this.servedVersions + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

