/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_9.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.kubernetes.api.model.v6_9.gatewayapi.v1beta1.HTTPBackendRef;
import io.fabric8.kubernetes.api.model.v6_9.gatewayapi.v1beta1.HTTPBackendRefBuilder;
import io.fabric8.kubernetes.api.model.v6_9.gatewayapi.v1beta1.HTTPBackendRefFluent;
import io.fabric8.kubernetes.api.model.v6_9.gatewayapi.v1beta1.HTTPRouteFilter;
import io.fabric8.kubernetes.api.model.v6_9.gatewayapi.v1beta1.HTTPRouteFilterBuilder;
import io.fabric8.kubernetes.api.model.v6_9.gatewayapi.v1beta1.HTTPRouteFilterFluent;
import io.fabric8.kubernetes.api.model.v6_9.gatewayapi.v1beta1.HTTPRouteMatch;
import io.fabric8.kubernetes.api.model.v6_9.gatewayapi.v1beta1.HTTPRouteMatchBuilder;
import io.fabric8.kubernetes.api.model.v6_9.gatewayapi.v1beta1.HTTPRouteMatchFluent;
import io.fabric8.kubernetes.api.model.v6_9.gatewayapi.v1beta1.HTTPRouteRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class HTTPRouteRuleFluent<A extends HTTPRouteRuleFluent<A>>
extends BaseFluent<A> {
    private ArrayList<HTTPBackendRefBuilder> backendRefs = new ArrayList();
    private ArrayList<HTTPRouteFilterBuilder> filters = new ArrayList();
    private ArrayList<HTTPRouteMatchBuilder> matches = new ArrayList();
    private Map<String, Object> additionalProperties;

    public HTTPRouteRuleFluent() {
    }

    public HTTPRouteRuleFluent(HTTPRouteRule instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(HTTPRouteRule instance) {
        HTTPRouteRule hTTPRouteRule = instance = instance != null ? instance : new HTTPRouteRule();
        if (instance != null) {
            this.withBackendRefs(instance.getBackendRefs());
            this.withFilters(instance.getFilters());
            this.withMatches(instance.getMatches());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToBackendRefs(int index, HTTPBackendRef item) {
        if (this.backendRefs == null) {
            this.backendRefs = new ArrayList();
        }
        HTTPBackendRefBuilder builder = new HTTPBackendRefBuilder(item);
        if (index < 0 || index >= this.backendRefs.size()) {
            this._visitables.get("backendRefs").add(builder);
            this.backendRefs.add(builder);
        } else {
            this._visitables.get("backendRefs").add(index, builder);
            this.backendRefs.add(index, builder);
        }
        return (A)this;
    }

    public A setToBackendRefs(int index, HTTPBackendRef item) {
        if (this.backendRefs == null) {
            this.backendRefs = new ArrayList();
        }
        HTTPBackendRefBuilder builder = new HTTPBackendRefBuilder(item);
        if (index < 0 || index >= this.backendRefs.size()) {
            this._visitables.get("backendRefs").add(builder);
            this.backendRefs.add(builder);
        } else {
            this._visitables.get("backendRefs").set(index, builder);
            this.backendRefs.set(index, builder);
        }
        return (A)this;
    }

    public A addToBackendRefs(HTTPBackendRef ... items) {
        if (this.backendRefs == null) {
            this.backendRefs = new ArrayList();
        }
        for (HTTPBackendRef item : items) {
            HTTPBackendRefBuilder builder = new HTTPBackendRefBuilder(item);
            this._visitables.get("backendRefs").add(builder);
            this.backendRefs.add(builder);
        }
        return (A)this;
    }

    public A addAllToBackendRefs(Collection<HTTPBackendRef> items) {
        if (this.backendRefs == null) {
            this.backendRefs = new ArrayList();
        }
        for (HTTPBackendRef item : items) {
            HTTPBackendRefBuilder builder = new HTTPBackendRefBuilder(item);
            this._visitables.get("backendRefs").add(builder);
            this.backendRefs.add(builder);
        }
        return (A)this;
    }

    public A removeFromBackendRefs(HTTPBackendRef ... items) {
        if (this.backendRefs == null) {
            return (A)this;
        }
        for (HTTPBackendRef item : items) {
            HTTPBackendRefBuilder builder = new HTTPBackendRefBuilder(item);
            this._visitables.get("backendRefs").remove(builder);
            this.backendRefs.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromBackendRefs(Collection<HTTPBackendRef> items) {
        if (this.backendRefs == null) {
            return (A)this;
        }
        for (HTTPBackendRef item : items) {
            HTTPBackendRefBuilder builder = new HTTPBackendRefBuilder(item);
            this._visitables.get("backendRefs").remove(builder);
            this.backendRefs.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromBackendRefs(Predicate<HTTPBackendRefBuilder> predicate) {
        if (this.backendRefs == null) {
            return (A)this;
        }
        Iterator<HTTPBackendRefBuilder> each = this.backendRefs.iterator();
        Object visitables = this._visitables.get("backendRefs");
        while (each.hasNext()) {
            HTTPBackendRefBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<HTTPBackendRef> buildBackendRefs() {
        return this.backendRefs != null ? HTTPRouteRuleFluent.build(this.backendRefs) : null;
    }

    public HTTPBackendRef buildBackendRef(int index) {
        return this.backendRefs.get(index).build();
    }

    public HTTPBackendRef buildFirstBackendRef() {
        return this.backendRefs.get(0).build();
    }

    public HTTPBackendRef buildLastBackendRef() {
        return this.backendRefs.get(this.backendRefs.size() - 1).build();
    }

    public HTTPBackendRef buildMatchingBackendRef(Predicate<HTTPBackendRefBuilder> predicate) {
        for (HTTPBackendRefBuilder item : this.backendRefs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingBackendRef(Predicate<HTTPBackendRefBuilder> predicate) {
        for (HTTPBackendRefBuilder item : this.backendRefs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withBackendRefs(List<HTTPBackendRef> backendRefs) {
        if (this.backendRefs != null) {
            this._visitables.get("backendRefs").clear();
        }
        if (backendRefs != null) {
            this.backendRefs = new ArrayList();
            for (HTTPBackendRef item : backendRefs) {
                this.addToBackendRefs(item);
            }
        } else {
            this.backendRefs = null;
        }
        return (A)this;
    }

    public A withBackendRefs(HTTPBackendRef ... backendRefs) {
        if (this.backendRefs != null) {
            this.backendRefs.clear();
            this._visitables.remove("backendRefs");
        }
        if (backendRefs != null) {
            for (HTTPBackendRef item : backendRefs) {
                this.addToBackendRefs(item);
            }
        }
        return (A)this;
    }

    public boolean hasBackendRefs() {
        return this.backendRefs != null && !this.backendRefs.isEmpty();
    }

    public BackendRefsNested<A> addNewBackendRef() {
        return new BackendRefsNested(-1, null);
    }

    public BackendRefsNested<A> addNewBackendRefLike(HTTPBackendRef item) {
        return new BackendRefsNested(-1, item);
    }

    public BackendRefsNested<A> setNewBackendRefLike(int index, HTTPBackendRef item) {
        return new BackendRefsNested(index, item);
    }

    public BackendRefsNested<A> editBackendRef(int index) {
        if (this.backendRefs.size() <= index) {
            throw new RuntimeException("Can't edit backendRefs. Index exceeds size.");
        }
        return this.setNewBackendRefLike(index, this.buildBackendRef(index));
    }

    public BackendRefsNested<A> editFirstBackendRef() {
        if (this.backendRefs.size() == 0) {
            throw new RuntimeException("Can't edit first backendRefs. The list is empty.");
        }
        return this.setNewBackendRefLike(0, this.buildBackendRef(0));
    }

    public BackendRefsNested<A> editLastBackendRef() {
        int index = this.backendRefs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last backendRefs. The list is empty.");
        }
        return this.setNewBackendRefLike(index, this.buildBackendRef(index));
    }

    public BackendRefsNested<A> editMatchingBackendRef(Predicate<HTTPBackendRefBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.backendRefs.size(); ++i) {
            if (!predicate.test(this.backendRefs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching backendRefs. No match found.");
        }
        return this.setNewBackendRefLike(index, this.buildBackendRef(index));
    }

    public A addToFilters(int index, HTTPRouteFilter item) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        HTTPRouteFilterBuilder builder = new HTTPRouteFilterBuilder(item);
        if (index < 0 || index >= this.filters.size()) {
            this._visitables.get("filters").add(builder);
            this.filters.add(builder);
        } else {
            this._visitables.get("filters").add(index, builder);
            this.filters.add(index, builder);
        }
        return (A)this;
    }

    public A setToFilters(int index, HTTPRouteFilter item) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        HTTPRouteFilterBuilder builder = new HTTPRouteFilterBuilder(item);
        if (index < 0 || index >= this.filters.size()) {
            this._visitables.get("filters").add(builder);
            this.filters.add(builder);
        } else {
            this._visitables.get("filters").set(index, builder);
            this.filters.set(index, builder);
        }
        return (A)this;
    }

    public A addToFilters(HTTPRouteFilter ... items) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        for (HTTPRouteFilter item : items) {
            HTTPRouteFilterBuilder builder = new HTTPRouteFilterBuilder(item);
            this._visitables.get("filters").add(builder);
            this.filters.add(builder);
        }
        return (A)this;
    }

    public A addAllToFilters(Collection<HTTPRouteFilter> items) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        for (HTTPRouteFilter item : items) {
            HTTPRouteFilterBuilder builder = new HTTPRouteFilterBuilder(item);
            this._visitables.get("filters").add(builder);
            this.filters.add(builder);
        }
        return (A)this;
    }

    public A removeFromFilters(HTTPRouteFilter ... items) {
        if (this.filters == null) {
            return (A)this;
        }
        for (HTTPRouteFilter item : items) {
            HTTPRouteFilterBuilder builder = new HTTPRouteFilterBuilder(item);
            this._visitables.get("filters").remove(builder);
            this.filters.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromFilters(Collection<HTTPRouteFilter> items) {
        if (this.filters == null) {
            return (A)this;
        }
        for (HTTPRouteFilter item : items) {
            HTTPRouteFilterBuilder builder = new HTTPRouteFilterBuilder(item);
            this._visitables.get("filters").remove(builder);
            this.filters.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromFilters(Predicate<HTTPRouteFilterBuilder> predicate) {
        if (this.filters == null) {
            return (A)this;
        }
        Iterator<HTTPRouteFilterBuilder> each = this.filters.iterator();
        Object visitables = this._visitables.get("filters");
        while (each.hasNext()) {
            HTTPRouteFilterBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<HTTPRouteFilter> buildFilters() {
        return this.filters != null ? HTTPRouteRuleFluent.build(this.filters) : null;
    }

    public HTTPRouteFilter buildFilter(int index) {
        return this.filters.get(index).build();
    }

    public HTTPRouteFilter buildFirstFilter() {
        return this.filters.get(0).build();
    }

    public HTTPRouteFilter buildLastFilter() {
        return this.filters.get(this.filters.size() - 1).build();
    }

    public HTTPRouteFilter buildMatchingFilter(Predicate<HTTPRouteFilterBuilder> predicate) {
        for (HTTPRouteFilterBuilder item : this.filters) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingFilter(Predicate<HTTPRouteFilterBuilder> predicate) {
        for (HTTPRouteFilterBuilder item : this.filters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withFilters(List<HTTPRouteFilter> filters) {
        if (this.filters != null) {
            this._visitables.get("filters").clear();
        }
        if (filters != null) {
            this.filters = new ArrayList();
            for (HTTPRouteFilter item : filters) {
                this.addToFilters(item);
            }
        } else {
            this.filters = null;
        }
        return (A)this;
    }

    public A withFilters(HTTPRouteFilter ... filters) {
        if (this.filters != null) {
            this.filters.clear();
            this._visitables.remove("filters");
        }
        if (filters != null) {
            for (HTTPRouteFilter item : filters) {
                this.addToFilters(item);
            }
        }
        return (A)this;
    }

    public boolean hasFilters() {
        return this.filters != null && !this.filters.isEmpty();
    }

    public FiltersNested<A> addNewFilter() {
        return new FiltersNested(-1, null);
    }

    public FiltersNested<A> addNewFilterLike(HTTPRouteFilter item) {
        return new FiltersNested(-1, item);
    }

    public FiltersNested<A> setNewFilterLike(int index, HTTPRouteFilter item) {
        return new FiltersNested(index, item);
    }

    public FiltersNested<A> editFilter(int index) {
        if (this.filters.size() <= index) {
            throw new RuntimeException("Can't edit filters. Index exceeds size.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    public FiltersNested<A> editFirstFilter() {
        if (this.filters.size() == 0) {
            throw new RuntimeException("Can't edit first filters. The list is empty.");
        }
        return this.setNewFilterLike(0, this.buildFilter(0));
    }

    public FiltersNested<A> editLastFilter() {
        int index = this.filters.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last filters. The list is empty.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    public FiltersNested<A> editMatchingFilter(Predicate<HTTPRouteFilterBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.filters.size(); ++i) {
            if (!predicate.test(this.filters.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching filters. No match found.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    public A addToMatches(int index, HTTPRouteMatch item) {
        if (this.matches == null) {
            this.matches = new ArrayList();
        }
        HTTPRouteMatchBuilder builder = new HTTPRouteMatchBuilder(item);
        if (index < 0 || index >= this.matches.size()) {
            this._visitables.get("matches").add(builder);
            this.matches.add(builder);
        } else {
            this._visitables.get("matches").add(index, builder);
            this.matches.add(index, builder);
        }
        return (A)this;
    }

    public A setToMatches(int index, HTTPRouteMatch item) {
        if (this.matches == null) {
            this.matches = new ArrayList();
        }
        HTTPRouteMatchBuilder builder = new HTTPRouteMatchBuilder(item);
        if (index < 0 || index >= this.matches.size()) {
            this._visitables.get("matches").add(builder);
            this.matches.add(builder);
        } else {
            this._visitables.get("matches").set(index, builder);
            this.matches.set(index, builder);
        }
        return (A)this;
    }

    public A addToMatches(HTTPRouteMatch ... items) {
        if (this.matches == null) {
            this.matches = new ArrayList();
        }
        for (HTTPRouteMatch item : items) {
            HTTPRouteMatchBuilder builder = new HTTPRouteMatchBuilder(item);
            this._visitables.get("matches").add(builder);
            this.matches.add(builder);
        }
        return (A)this;
    }

    public A addAllToMatches(Collection<HTTPRouteMatch> items) {
        if (this.matches == null) {
            this.matches = new ArrayList();
        }
        for (HTTPRouteMatch item : items) {
            HTTPRouteMatchBuilder builder = new HTTPRouteMatchBuilder(item);
            this._visitables.get("matches").add(builder);
            this.matches.add(builder);
        }
        return (A)this;
    }

    public A removeFromMatches(HTTPRouteMatch ... items) {
        if (this.matches == null) {
            return (A)this;
        }
        for (HTTPRouteMatch item : items) {
            HTTPRouteMatchBuilder builder = new HTTPRouteMatchBuilder(item);
            this._visitables.get("matches").remove(builder);
            this.matches.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromMatches(Collection<HTTPRouteMatch> items) {
        if (this.matches == null) {
            return (A)this;
        }
        for (HTTPRouteMatch item : items) {
            HTTPRouteMatchBuilder builder = new HTTPRouteMatchBuilder(item);
            this._visitables.get("matches").remove(builder);
            this.matches.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromMatches(Predicate<HTTPRouteMatchBuilder> predicate) {
        if (this.matches == null) {
            return (A)this;
        }
        Iterator<HTTPRouteMatchBuilder> each = this.matches.iterator();
        Object visitables = this._visitables.get("matches");
        while (each.hasNext()) {
            HTTPRouteMatchBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<HTTPRouteMatch> buildMatches() {
        return this.matches != null ? HTTPRouteRuleFluent.build(this.matches) : null;
    }

    public HTTPRouteMatch buildMatch(int index) {
        return this.matches.get(index).build();
    }

    public HTTPRouteMatch buildFirstMatch() {
        return this.matches.get(0).build();
    }

    public HTTPRouteMatch buildLastMatch() {
        return this.matches.get(this.matches.size() - 1).build();
    }

    public HTTPRouteMatch buildMatchingMatch(Predicate<HTTPRouteMatchBuilder> predicate) {
        for (HTTPRouteMatchBuilder item : this.matches) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMatch(Predicate<HTTPRouteMatchBuilder> predicate) {
        for (HTTPRouteMatchBuilder item : this.matches) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMatches(List<HTTPRouteMatch> matches) {
        if (this.matches != null) {
            this._visitables.get("matches").clear();
        }
        if (matches != null) {
            this.matches = new ArrayList();
            for (HTTPRouteMatch item : matches) {
                this.addToMatches(item);
            }
        } else {
            this.matches = null;
        }
        return (A)this;
    }

    public A withMatches(HTTPRouteMatch ... matches) {
        if (this.matches != null) {
            this.matches.clear();
            this._visitables.remove("matches");
        }
        if (matches != null) {
            for (HTTPRouteMatch item : matches) {
                this.addToMatches(item);
            }
        }
        return (A)this;
    }

    public boolean hasMatches() {
        return this.matches != null && !this.matches.isEmpty();
    }

    public MatchesNested<A> addNewMatch() {
        return new MatchesNested(-1, null);
    }

    public MatchesNested<A> addNewMatchLike(HTTPRouteMatch item) {
        return new MatchesNested(-1, item);
    }

    public MatchesNested<A> setNewMatchLike(int index, HTTPRouteMatch item) {
        return new MatchesNested(index, item);
    }

    public MatchesNested<A> editMatch(int index) {
        if (this.matches.size() <= index) {
            throw new RuntimeException("Can't edit matches. Index exceeds size.");
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    public MatchesNested<A> editFirstMatch() {
        if (this.matches.size() == 0) {
            throw new RuntimeException("Can't edit first matches. The list is empty.");
        }
        return this.setNewMatchLike(0, this.buildMatch(0));
    }

    public MatchesNested<A> editLastMatch() {
        int index = this.matches.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last matches. The list is empty.");
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    public MatchesNested<A> editMatchingMatch(Predicate<HTTPRouteMatchBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.matches.size(); ++i) {
            if (!predicate.test(this.matches.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching matches. No match found.");
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPRouteRuleFluent that = (HTTPRouteRuleFluent)o;
        if (!Objects.equals(this.backendRefs, that.backendRefs)) {
            return false;
        }
        if (!Objects.equals(this.filters, that.filters)) {
            return false;
        }
        if (!Objects.equals(this.matches, that.matches)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.backendRefs, this.filters, this.matches, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.backendRefs != null && !this.backendRefs.isEmpty()) {
            sb.append("backendRefs:");
            sb.append(this.backendRefs + ",");
        }
        if (this.filters != null && !this.filters.isEmpty()) {
            sb.append("filters:");
            sb.append(this.filters + ",");
        }
        if (this.matches != null && !this.matches.isEmpty()) {
            sb.append("matches:");
            sb.append(this.matches + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MatchesNested<N>
    extends HTTPRouteMatchFluent<MatchesNested<N>>
    implements Nested<N> {
        HTTPRouteMatchBuilder builder;
        int index;

        MatchesNested(int index, HTTPRouteMatch item) {
            this.index = index;
            this.builder = new HTTPRouteMatchBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)HTTPRouteRuleFluent.this.setToMatches(this.index, this.builder.build());
        }

        public N endMatch() {
            return this.and();
        }
    }

    public class FiltersNested<N>
    extends HTTPRouteFilterFluent<FiltersNested<N>>
    implements Nested<N> {
        HTTPRouteFilterBuilder builder;
        int index;

        FiltersNested(int index, HTTPRouteFilter item) {
            this.index = index;
            this.builder = new HTTPRouteFilterBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)HTTPRouteRuleFluent.this.setToFilters(this.index, this.builder.build());
        }

        public N endFilter() {
            return this.and();
        }
    }

    public class BackendRefsNested<N>
    extends HTTPBackendRefFluent<BackendRefsNested<N>>
    implements Nested<N> {
        HTTPBackendRefBuilder builder;
        int index;

        BackendRefsNested(int index, HTTPBackendRef item) {
            this.index = index;
            this.builder = new HTTPBackendRefBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)HTTPRouteRuleFluent.this.setToBackendRefs(this.index, this.builder.build());
        }

        public N endBackendRef() {
            return this.and();
        }
    }
}

