/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_9.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.kubernetes.api.model.v6_9.autoscaling.v2beta1.HorizontalPodAutoscalerCondition;
import io.fabric8.kubernetes.api.model.v6_9.autoscaling.v2beta1.HorizontalPodAutoscalerConditionBuilder;
import io.fabric8.kubernetes.api.model.v6_9.autoscaling.v2beta1.HorizontalPodAutoscalerConditionFluent;
import io.fabric8.kubernetes.api.model.v6_9.autoscaling.v2beta1.HorizontalPodAutoscalerStatus;
import io.fabric8.kubernetes.api.model.v6_9.autoscaling.v2beta1.MetricStatus;
import io.fabric8.kubernetes.api.model.v6_9.autoscaling.v2beta1.MetricStatusBuilder;
import io.fabric8.kubernetes.api.model.v6_9.autoscaling.v2beta1.MetricStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class HorizontalPodAutoscalerStatusFluent<A extends HorizontalPodAutoscalerStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<HorizontalPodAutoscalerConditionBuilder> conditions = new ArrayList();
    private ArrayList<MetricStatusBuilder> currentMetrics = new ArrayList();
    private Integer currentReplicas;
    private Integer desiredReplicas;
    private String lastScaleTime;
    private Long observedGeneration;
    private Map<String, Object> additionalProperties;

    public HorizontalPodAutoscalerStatusFluent() {
    }

    public HorizontalPodAutoscalerStatusFluent(HorizontalPodAutoscalerStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(HorizontalPodAutoscalerStatus instance) {
        HorizontalPodAutoscalerStatus horizontalPodAutoscalerStatus = instance = instance != null ? instance : new HorizontalPodAutoscalerStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withCurrentMetrics(instance.getCurrentMetrics());
            this.withCurrentReplicas(instance.getCurrentReplicas());
            this.withDesiredReplicas(instance.getDesiredReplicas());
            this.withLastScaleTime(instance.getLastScaleTime());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConditions(int index, HorizontalPodAutoscalerCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        HorizontalPodAutoscalerConditionBuilder builder = new HorizontalPodAutoscalerConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, HorizontalPodAutoscalerCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        HorizontalPodAutoscalerConditionBuilder builder = new HorizontalPodAutoscalerConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(HorizontalPodAutoscalerCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (HorizontalPodAutoscalerCondition item : items) {
            HorizontalPodAutoscalerConditionBuilder builder = new HorizontalPodAutoscalerConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<HorizontalPodAutoscalerCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (HorizontalPodAutoscalerCondition item : items) {
            HorizontalPodAutoscalerConditionBuilder builder = new HorizontalPodAutoscalerConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(HorizontalPodAutoscalerCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (HorizontalPodAutoscalerCondition item : items) {
            HorizontalPodAutoscalerConditionBuilder builder = new HorizontalPodAutoscalerConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<HorizontalPodAutoscalerCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (HorizontalPodAutoscalerCondition item : items) {
            HorizontalPodAutoscalerConditionBuilder builder = new HorizontalPodAutoscalerConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<HorizontalPodAutoscalerConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<HorizontalPodAutoscalerConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            HorizontalPodAutoscalerConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<HorizontalPodAutoscalerCondition> buildConditions() {
        return this.conditions != null ? HorizontalPodAutoscalerStatusFluent.build(this.conditions) : null;
    }

    public HorizontalPodAutoscalerCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public HorizontalPodAutoscalerCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public HorizontalPodAutoscalerCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public HorizontalPodAutoscalerCondition buildMatchingCondition(Predicate<HorizontalPodAutoscalerConditionBuilder> predicate) {
        for (HorizontalPodAutoscalerConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<HorizontalPodAutoscalerConditionBuilder> predicate) {
        for (HorizontalPodAutoscalerConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<HorizontalPodAutoscalerCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (HorizontalPodAutoscalerCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(HorizontalPodAutoscalerCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (HorizontalPodAutoscalerCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new HorizontalPodAutoscalerCondition(lastTransitionTime, message, reason, status, type));
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(HorizontalPodAutoscalerCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, HorizontalPodAutoscalerCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<HorizontalPodAutoscalerConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public A addToCurrentMetrics(int index, MetricStatus item) {
        if (this.currentMetrics == null) {
            this.currentMetrics = new ArrayList();
        }
        MetricStatusBuilder builder = new MetricStatusBuilder(item);
        if (index < 0 || index >= this.currentMetrics.size()) {
            this._visitables.get("currentMetrics").add(builder);
            this.currentMetrics.add(builder);
        } else {
            this._visitables.get("currentMetrics").add(index, builder);
            this.currentMetrics.add(index, builder);
        }
        return (A)this;
    }

    public A setToCurrentMetrics(int index, MetricStatus item) {
        if (this.currentMetrics == null) {
            this.currentMetrics = new ArrayList();
        }
        MetricStatusBuilder builder = new MetricStatusBuilder(item);
        if (index < 0 || index >= this.currentMetrics.size()) {
            this._visitables.get("currentMetrics").add(builder);
            this.currentMetrics.add(builder);
        } else {
            this._visitables.get("currentMetrics").set(index, builder);
            this.currentMetrics.set(index, builder);
        }
        return (A)this;
    }

    public A addToCurrentMetrics(MetricStatus ... items) {
        if (this.currentMetrics == null) {
            this.currentMetrics = new ArrayList();
        }
        for (MetricStatus item : items) {
            MetricStatusBuilder builder = new MetricStatusBuilder(item);
            this._visitables.get("currentMetrics").add(builder);
            this.currentMetrics.add(builder);
        }
        return (A)this;
    }

    public A addAllToCurrentMetrics(Collection<MetricStatus> items) {
        if (this.currentMetrics == null) {
            this.currentMetrics = new ArrayList();
        }
        for (MetricStatus item : items) {
            MetricStatusBuilder builder = new MetricStatusBuilder(item);
            this._visitables.get("currentMetrics").add(builder);
            this.currentMetrics.add(builder);
        }
        return (A)this;
    }

    public A removeFromCurrentMetrics(MetricStatus ... items) {
        if (this.currentMetrics == null) {
            return (A)this;
        }
        for (MetricStatus item : items) {
            MetricStatusBuilder builder = new MetricStatusBuilder(item);
            this._visitables.get("currentMetrics").remove(builder);
            this.currentMetrics.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromCurrentMetrics(Collection<MetricStatus> items) {
        if (this.currentMetrics == null) {
            return (A)this;
        }
        for (MetricStatus item : items) {
            MetricStatusBuilder builder = new MetricStatusBuilder(item);
            this._visitables.get("currentMetrics").remove(builder);
            this.currentMetrics.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromCurrentMetrics(Predicate<MetricStatusBuilder> predicate) {
        if (this.currentMetrics == null) {
            return (A)this;
        }
        Iterator<MetricStatusBuilder> each = this.currentMetrics.iterator();
        Object visitables = this._visitables.get("currentMetrics");
        while (each.hasNext()) {
            MetricStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<MetricStatus> buildCurrentMetrics() {
        return this.currentMetrics != null ? HorizontalPodAutoscalerStatusFluent.build(this.currentMetrics) : null;
    }

    public MetricStatus buildCurrentMetric(int index) {
        return this.currentMetrics.get(index).build();
    }

    public MetricStatus buildFirstCurrentMetric() {
        return this.currentMetrics.get(0).build();
    }

    public MetricStatus buildLastCurrentMetric() {
        return this.currentMetrics.get(this.currentMetrics.size() - 1).build();
    }

    public MetricStatus buildMatchingCurrentMetric(Predicate<MetricStatusBuilder> predicate) {
        for (MetricStatusBuilder item : this.currentMetrics) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCurrentMetric(Predicate<MetricStatusBuilder> predicate) {
        for (MetricStatusBuilder item : this.currentMetrics) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCurrentMetrics(List<MetricStatus> currentMetrics) {
        if (this.currentMetrics != null) {
            this._visitables.get("currentMetrics").clear();
        }
        if (currentMetrics != null) {
            this.currentMetrics = new ArrayList();
            for (MetricStatus item : currentMetrics) {
                this.addToCurrentMetrics(item);
            }
        } else {
            this.currentMetrics = null;
        }
        return (A)this;
    }

    public A withCurrentMetrics(MetricStatus ... currentMetrics) {
        if (this.currentMetrics != null) {
            this.currentMetrics.clear();
            this._visitables.remove("currentMetrics");
        }
        if (currentMetrics != null) {
            for (MetricStatus item : currentMetrics) {
                this.addToCurrentMetrics(item);
            }
        }
        return (A)this;
    }

    public boolean hasCurrentMetrics() {
        return this.currentMetrics != null && !this.currentMetrics.isEmpty();
    }

    public CurrentMetricsNested<A> addNewCurrentMetric() {
        return new CurrentMetricsNested(-1, null);
    }

    public CurrentMetricsNested<A> addNewCurrentMetricLike(MetricStatus item) {
        return new CurrentMetricsNested(-1, item);
    }

    public CurrentMetricsNested<A> setNewCurrentMetricLike(int index, MetricStatus item) {
        return new CurrentMetricsNested(index, item);
    }

    public CurrentMetricsNested<A> editCurrentMetric(int index) {
        if (this.currentMetrics.size() <= index) {
            throw new RuntimeException("Can't edit currentMetrics. Index exceeds size.");
        }
        return this.setNewCurrentMetricLike(index, this.buildCurrentMetric(index));
    }

    public CurrentMetricsNested<A> editFirstCurrentMetric() {
        if (this.currentMetrics.size() == 0) {
            throw new RuntimeException("Can't edit first currentMetrics. The list is empty.");
        }
        return this.setNewCurrentMetricLike(0, this.buildCurrentMetric(0));
    }

    public CurrentMetricsNested<A> editLastCurrentMetric() {
        int index = this.currentMetrics.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last currentMetrics. The list is empty.");
        }
        return this.setNewCurrentMetricLike(index, this.buildCurrentMetric(index));
    }

    public CurrentMetricsNested<A> editMatchingCurrentMetric(Predicate<MetricStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.currentMetrics.size(); ++i) {
            if (!predicate.test(this.currentMetrics.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching currentMetrics. No match found.");
        }
        return this.setNewCurrentMetricLike(index, this.buildCurrentMetric(index));
    }

    public Integer getCurrentReplicas() {
        return this.currentReplicas;
    }

    public A withCurrentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
        return (A)this;
    }

    public boolean hasCurrentReplicas() {
        return this.currentReplicas != null;
    }

    public Integer getDesiredReplicas() {
        return this.desiredReplicas;
    }

    public A withDesiredReplicas(Integer desiredReplicas) {
        this.desiredReplicas = desiredReplicas;
        return (A)this;
    }

    public boolean hasDesiredReplicas() {
        return this.desiredReplicas != null;
    }

    public String getLastScaleTime() {
        return this.lastScaleTime;
    }

    public A withLastScaleTime(String lastScaleTime) {
        this.lastScaleTime = lastScaleTime;
        return (A)this;
    }

    public boolean hasLastScaleTime() {
        return this.lastScaleTime != null;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HorizontalPodAutoscalerStatusFluent that = (HorizontalPodAutoscalerStatusFluent)o;
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.currentMetrics, that.currentMetrics)) {
            return false;
        }
        if (!Objects.equals(this.currentReplicas, that.currentReplicas)) {
            return false;
        }
        if (!Objects.equals(this.desiredReplicas, that.desiredReplicas)) {
            return false;
        }
        if (!Objects.equals(this.lastScaleTime, that.lastScaleTime)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.currentMetrics, this.currentReplicas, this.desiredReplicas, this.lastScaleTime, this.observedGeneration, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.currentMetrics != null && !this.currentMetrics.isEmpty()) {
            sb.append("currentMetrics:");
            sb.append(this.currentMetrics + ",");
        }
        if (this.currentReplicas != null) {
            sb.append("currentReplicas:");
            sb.append(this.currentReplicas + ",");
        }
        if (this.desiredReplicas != null) {
            sb.append("desiredReplicas:");
            sb.append(this.desiredReplicas + ",");
        }
        if (this.lastScaleTime != null) {
            sb.append("lastScaleTime:");
            sb.append(this.lastScaleTime + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class CurrentMetricsNested<N>
    extends MetricStatusFluent<CurrentMetricsNested<N>>
    implements Nested<N> {
        MetricStatusBuilder builder;
        int index;

        CurrentMetricsNested(int index, MetricStatus item) {
            this.index = index;
            this.builder = new MetricStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)HorizontalPodAutoscalerStatusFluent.this.setToCurrentMetrics(this.index, this.builder.build());
        }

        public N endCurrentMetric() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends HorizontalPodAutoscalerConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        HorizontalPodAutoscalerConditionBuilder builder;
        int index;

        ConditionsNested(int index, HorizontalPodAutoscalerCondition item) {
            this.index = index;
            this.builder = new HorizontalPodAutoscalerConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)HorizontalPodAutoscalerStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

