/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_9;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.kubernetes.api.model.v6_9.DaemonEndpoint;
import io.fabric8.kubernetes.api.model.v6_9.DaemonEndpointBuilder;
import io.fabric8.kubernetes.api.model.v6_9.DaemonEndpointFluent;
import io.fabric8.kubernetes.api.model.v6_9.NodeDaemonEndpoints;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NodeDaemonEndpointsFluent<A extends NodeDaemonEndpointsFluent<A>>
extends BaseFluent<A> {
    private DaemonEndpointBuilder kubeletEndpoint;
    private Map<String, Object> additionalProperties;

    public NodeDaemonEndpointsFluent() {
    }

    public NodeDaemonEndpointsFluent(NodeDaemonEndpoints instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NodeDaemonEndpoints instance) {
        NodeDaemonEndpoints nodeDaemonEndpoints = instance = instance != null ? instance : new NodeDaemonEndpoints();
        if (instance != null) {
            this.withKubeletEndpoint(instance.getKubeletEndpoint());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public DaemonEndpoint buildKubeletEndpoint() {
        return this.kubeletEndpoint != null ? this.kubeletEndpoint.build() : null;
    }

    public A withKubeletEndpoint(DaemonEndpoint kubeletEndpoint) {
        this._visitables.remove("kubeletEndpoint");
        if (kubeletEndpoint != null) {
            this.kubeletEndpoint = new DaemonEndpointBuilder(kubeletEndpoint);
            this._visitables.get("kubeletEndpoint").add(this.kubeletEndpoint);
        } else {
            this.kubeletEndpoint = null;
            this._visitables.get("kubeletEndpoint").remove(this.kubeletEndpoint);
        }
        return (A)this;
    }

    public boolean hasKubeletEndpoint() {
        return this.kubeletEndpoint != null;
    }

    public A withNewKubeletEndpoint(Integer port) {
        return this.withKubeletEndpoint(new DaemonEndpoint(port));
    }

    public KubeletEndpointNested<A> withNewKubeletEndpoint() {
        return new KubeletEndpointNested(null);
    }

    public KubeletEndpointNested<A> withNewKubeletEndpointLike(DaemonEndpoint item) {
        return new KubeletEndpointNested(item);
    }

    public KubeletEndpointNested<A> editKubeletEndpoint() {
        return this.withNewKubeletEndpointLike(Optional.ofNullable(this.buildKubeletEndpoint()).orElse(null));
    }

    public KubeletEndpointNested<A> editOrNewKubeletEndpoint() {
        return this.withNewKubeletEndpointLike(Optional.ofNullable(this.buildKubeletEndpoint()).orElse(new DaemonEndpointBuilder().build()));
    }

    public KubeletEndpointNested<A> editOrNewKubeletEndpointLike(DaemonEndpoint item) {
        return this.withNewKubeletEndpointLike(Optional.ofNullable(this.buildKubeletEndpoint()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeDaemonEndpointsFluent that = (NodeDaemonEndpointsFluent)o;
        if (!Objects.equals(this.kubeletEndpoint, that.kubeletEndpoint)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.kubeletEndpoint, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.kubeletEndpoint != null) {
            sb.append("kubeletEndpoint:");
            sb.append(this.kubeletEndpoint + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class KubeletEndpointNested<N>
    extends DaemonEndpointFluent<KubeletEndpointNested<N>>
    implements Nested<N> {
        DaemonEndpointBuilder builder;

        KubeletEndpointNested(DaemonEndpoint item) {
            this.builder = new DaemonEndpointBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NodeDaemonEndpointsFluent.this.withKubeletEndpoint(this.builder.build());
        }

        public N endKubeletEndpoint() {
            return this.and();
        }
    }
}

