/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_9;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.kubernetes.api.model.v6_9.Event;
import io.fabric8.kubernetes.api.model.v6_9.EventSeries;
import io.fabric8.kubernetes.api.model.v6_9.EventSeriesBuilder;
import io.fabric8.kubernetes.api.model.v6_9.EventSeriesFluent;
import io.fabric8.kubernetes.api.model.v6_9.EventSource;
import io.fabric8.kubernetes.api.model.v6_9.EventSourceBuilder;
import io.fabric8.kubernetes.api.model.v6_9.EventSourceFluent;
import io.fabric8.kubernetes.api.model.v6_9.MicroTime;
import io.fabric8.kubernetes.api.model.v6_9.MicroTimeBuilder;
import io.fabric8.kubernetes.api.model.v6_9.MicroTimeFluent;
import io.fabric8.kubernetes.api.model.v6_9.ObjectMeta;
import io.fabric8.kubernetes.api.model.v6_9.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v6_9.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.v6_9.ObjectReference;
import io.fabric8.kubernetes.api.model.v6_9.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v6_9.ObjectReferenceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class EventFluent<A extends EventFluent<A>>
extends BaseFluent<A> {
    private String action;
    private String apiVersion;
    private Integer count;
    private MicroTimeBuilder eventTime;
    private String firstTimestamp;
    private ObjectReferenceBuilder involvedObject;
    private String kind;
    private String lastTimestamp;
    private String message;
    private ObjectMetaBuilder metadata;
    private String reason;
    private ObjectReferenceBuilder related;
    private String reportingComponent;
    private String reportingInstance;
    private EventSeriesBuilder series;
    private EventSourceBuilder source;
    private String type;
    private Map<String, Object> additionalProperties;

    public EventFluent() {
    }

    public EventFluent(Event instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Event instance) {
        Event event = instance = instance != null ? instance : new Event();
        if (instance != null) {
            this.withAction(instance.getAction());
            this.withApiVersion(instance.getApiVersion());
            this.withCount(instance.getCount());
            this.withEventTime(instance.getEventTime());
            this.withFirstTimestamp(instance.getFirstTimestamp());
            this.withInvolvedObject(instance.getInvolvedObject());
            this.withKind(instance.getKind());
            this.withLastTimestamp(instance.getLastTimestamp());
            this.withMessage(instance.getMessage());
            this.withMetadata(instance.getMetadata());
            this.withReason(instance.getReason());
            this.withRelated(instance.getRelated());
            this.withReportingComponent(instance.getReportingComponent());
            this.withReportingInstance(instance.getReportingInstance());
            this.withSeries(instance.getSeries());
            this.withSource(instance.getSource());
            this.withType(instance.getType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getAction() {
        return this.action;
    }

    public A withAction(String action) {
        this.action = action;
        return (A)this;
    }

    public boolean hasAction() {
        return this.action != null;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public Integer getCount() {
        return this.count;
    }

    public A withCount(Integer count) {
        this.count = count;
        return (A)this;
    }

    public boolean hasCount() {
        return this.count != null;
    }

    public MicroTime buildEventTime() {
        return this.eventTime != null ? this.eventTime.build() : null;
    }

    public A withEventTime(MicroTime eventTime) {
        this._visitables.remove("eventTime");
        if (eventTime != null) {
            this.eventTime = new MicroTimeBuilder(eventTime);
            this._visitables.get("eventTime").add(this.eventTime);
        } else {
            this.eventTime = null;
            this._visitables.get("eventTime").remove(this.eventTime);
        }
        return (A)this;
    }

    public boolean hasEventTime() {
        return this.eventTime != null;
    }

    public A withNewEventTime(String time) {
        return this.withEventTime(new MicroTime(time));
    }

    public EventTimeNested<A> withNewEventTime() {
        return new EventTimeNested(null);
    }

    public EventTimeNested<A> withNewEventTimeLike(MicroTime item) {
        return new EventTimeNested(item);
    }

    public EventTimeNested<A> editEventTime() {
        return this.withNewEventTimeLike(Optional.ofNullable(this.buildEventTime()).orElse(null));
    }

    public EventTimeNested<A> editOrNewEventTime() {
        return this.withNewEventTimeLike(Optional.ofNullable(this.buildEventTime()).orElse(new MicroTimeBuilder().build()));
    }

    public EventTimeNested<A> editOrNewEventTimeLike(MicroTime item) {
        return this.withNewEventTimeLike(Optional.ofNullable(this.buildEventTime()).orElse(item));
    }

    public String getFirstTimestamp() {
        return this.firstTimestamp;
    }

    public A withFirstTimestamp(String firstTimestamp) {
        this.firstTimestamp = firstTimestamp;
        return (A)this;
    }

    public boolean hasFirstTimestamp() {
        return this.firstTimestamp != null;
    }

    public ObjectReference buildInvolvedObject() {
        return this.involvedObject != null ? this.involvedObject.build() : null;
    }

    public A withInvolvedObject(ObjectReference involvedObject) {
        this._visitables.remove("involvedObject");
        if (involvedObject != null) {
            this.involvedObject = new ObjectReferenceBuilder(involvedObject);
            this._visitables.get("involvedObject").add(this.involvedObject);
        } else {
            this.involvedObject = null;
            this._visitables.get("involvedObject").remove(this.involvedObject);
        }
        return (A)this;
    }

    public boolean hasInvolvedObject() {
        return this.involvedObject != null;
    }

    public InvolvedObjectNested<A> withNewInvolvedObject() {
        return new InvolvedObjectNested(null);
    }

    public InvolvedObjectNested<A> withNewInvolvedObjectLike(ObjectReference item) {
        return new InvolvedObjectNested(item);
    }

    public InvolvedObjectNested<A> editInvolvedObject() {
        return this.withNewInvolvedObjectLike(Optional.ofNullable(this.buildInvolvedObject()).orElse(null));
    }

    public InvolvedObjectNested<A> editOrNewInvolvedObject() {
        return this.withNewInvolvedObjectLike(Optional.ofNullable(this.buildInvolvedObject()).orElse(new ObjectReferenceBuilder().build()));
    }

    public InvolvedObjectNested<A> editOrNewInvolvedObjectLike(ObjectReference item) {
        return this.withNewInvolvedObjectLike(Optional.ofNullable(this.buildInvolvedObject()).orElse(item));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public String getLastTimestamp() {
        return this.lastTimestamp;
    }

    public A withLastTimestamp(String lastTimestamp) {
        this.lastTimestamp = lastTimestamp;
        return (A)this;
    }

    public boolean hasLastTimestamp() {
        return this.lastTimestamp != null;
    }

    public String getMessage() {
        return this.message;
    }

    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    public boolean hasMessage() {
        return this.message != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public String getReason() {
        return this.reason;
    }

    public A withReason(String reason) {
        this.reason = reason;
        return (A)this;
    }

    public boolean hasReason() {
        return this.reason != null;
    }

    public ObjectReference buildRelated() {
        return this.related != null ? this.related.build() : null;
    }

    public A withRelated(ObjectReference related) {
        this._visitables.remove("related");
        if (related != null) {
            this.related = new ObjectReferenceBuilder(related);
            this._visitables.get("related").add(this.related);
        } else {
            this.related = null;
            this._visitables.get("related").remove(this.related);
        }
        return (A)this;
    }

    public boolean hasRelated() {
        return this.related != null;
    }

    public RelatedNested<A> withNewRelated() {
        return new RelatedNested(null);
    }

    public RelatedNested<A> withNewRelatedLike(ObjectReference item) {
        return new RelatedNested(item);
    }

    public RelatedNested<A> editRelated() {
        return this.withNewRelatedLike(Optional.ofNullable(this.buildRelated()).orElse(null));
    }

    public RelatedNested<A> editOrNewRelated() {
        return this.withNewRelatedLike(Optional.ofNullable(this.buildRelated()).orElse(new ObjectReferenceBuilder().build()));
    }

    public RelatedNested<A> editOrNewRelatedLike(ObjectReference item) {
        return this.withNewRelatedLike(Optional.ofNullable(this.buildRelated()).orElse(item));
    }

    public String getReportingComponent() {
        return this.reportingComponent;
    }

    public A withReportingComponent(String reportingComponent) {
        this.reportingComponent = reportingComponent;
        return (A)this;
    }

    public boolean hasReportingComponent() {
        return this.reportingComponent != null;
    }

    public String getReportingInstance() {
        return this.reportingInstance;
    }

    public A withReportingInstance(String reportingInstance) {
        this.reportingInstance = reportingInstance;
        return (A)this;
    }

    public boolean hasReportingInstance() {
        return this.reportingInstance != null;
    }

    public EventSeries buildSeries() {
        return this.series != null ? this.series.build() : null;
    }

    public A withSeries(EventSeries series) {
        this._visitables.remove("series");
        if (series != null) {
            this.series = new EventSeriesBuilder(series);
            this._visitables.get("series").add(this.series);
        } else {
            this.series = null;
            this._visitables.get("series").remove(this.series);
        }
        return (A)this;
    }

    public boolean hasSeries() {
        return this.series != null;
    }

    public SeriesNested<A> withNewSeries() {
        return new SeriesNested(null);
    }

    public SeriesNested<A> withNewSeriesLike(EventSeries item) {
        return new SeriesNested(item);
    }

    public SeriesNested<A> editSeries() {
        return this.withNewSeriesLike(Optional.ofNullable(this.buildSeries()).orElse(null));
    }

    public SeriesNested<A> editOrNewSeries() {
        return this.withNewSeriesLike(Optional.ofNullable(this.buildSeries()).orElse(new EventSeriesBuilder().build()));
    }

    public SeriesNested<A> editOrNewSeriesLike(EventSeries item) {
        return this.withNewSeriesLike(Optional.ofNullable(this.buildSeries()).orElse(item));
    }

    public EventSource buildSource() {
        return this.source != null ? this.source.build() : null;
    }

    public A withSource(EventSource source) {
        this._visitables.remove("source");
        if (source != null) {
            this.source = new EventSourceBuilder(source);
            this._visitables.get("source").add(this.source);
        } else {
            this.source = null;
            this._visitables.get("source").remove(this.source);
        }
        return (A)this;
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public A withNewSource(String component, String host) {
        return this.withSource(new EventSource(component, host));
    }

    public SourceNested<A> withNewSource() {
        return new SourceNested(null);
    }

    public SourceNested<A> withNewSourceLike(EventSource item) {
        return new SourceNested(item);
    }

    public SourceNested<A> editSource() {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(null));
    }

    public SourceNested<A> editOrNewSource() {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(new EventSourceBuilder().build()));
    }

    public SourceNested<A> editOrNewSourceLike(EventSource item) {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(item));
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EventFluent that = (EventFluent)o;
        if (!Objects.equals(this.action, that.action)) {
            return false;
        }
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.count, that.count)) {
            return false;
        }
        if (!Objects.equals(this.eventTime, that.eventTime)) {
            return false;
        }
        if (!Objects.equals(this.firstTimestamp, that.firstTimestamp)) {
            return false;
        }
        if (!Objects.equals(this.involvedObject, that.involvedObject)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.lastTimestamp, that.lastTimestamp)) {
            return false;
        }
        if (!Objects.equals(this.message, that.message)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.reason, that.reason)) {
            return false;
        }
        if (!Objects.equals(this.related, that.related)) {
            return false;
        }
        if (!Objects.equals(this.reportingComponent, that.reportingComponent)) {
            return false;
        }
        if (!Objects.equals(this.reportingInstance, that.reportingInstance)) {
            return false;
        }
        if (!Objects.equals(this.series, that.series)) {
            return false;
        }
        if (!Objects.equals(this.source, that.source)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.action, this.apiVersion, this.count, this.eventTime, this.firstTimestamp, this.involvedObject, this.kind, this.lastTimestamp, this.message, this.metadata, this.reason, this.related, this.reportingComponent, this.reportingInstance, this.series, this.source, this.type, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.action != null) {
            sb.append("action:");
            sb.append(this.action + ",");
        }
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.count != null) {
            sb.append("count:");
            sb.append(this.count + ",");
        }
        if (this.eventTime != null) {
            sb.append("eventTime:");
            sb.append(this.eventTime + ",");
        }
        if (this.firstTimestamp != null) {
            sb.append("firstTimestamp:");
            sb.append(this.firstTimestamp + ",");
        }
        if (this.involvedObject != null) {
            sb.append("involvedObject:");
            sb.append(this.involvedObject + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.lastTimestamp != null) {
            sb.append("lastTimestamp:");
            sb.append(this.lastTimestamp + ",");
        }
        if (this.message != null) {
            sb.append("message:");
            sb.append(this.message + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.reason != null) {
            sb.append("reason:");
            sb.append(this.reason + ",");
        }
        if (this.related != null) {
            sb.append("related:");
            sb.append(this.related + ",");
        }
        if (this.reportingComponent != null) {
            sb.append("reportingComponent:");
            sb.append(this.reportingComponent + ",");
        }
        if (this.reportingInstance != null) {
            sb.append("reportingInstance:");
            sb.append(this.reportingInstance + ",");
        }
        if (this.series != null) {
            sb.append("series:");
            sb.append(this.series + ",");
        }
        if (this.source != null) {
            sb.append("source:");
            sb.append(this.source + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SourceNested<N>
    extends EventSourceFluent<SourceNested<N>>
    implements Nested<N> {
        EventSourceBuilder builder;

        SourceNested(EventSource item) {
            this.builder = new EventSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EventFluent.this.withSource(this.builder.build());
        }

        public N endSource() {
            return this.and();
        }
    }

    public class SeriesNested<N>
    extends EventSeriesFluent<SeriesNested<N>>
    implements Nested<N> {
        EventSeriesBuilder builder;

        SeriesNested(EventSeries item) {
            this.builder = new EventSeriesBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EventFluent.this.withSeries(this.builder.build());
        }

        public N endSeries() {
            return this.and();
        }
    }

    public class RelatedNested<N>
    extends ObjectReferenceFluent<RelatedNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        RelatedNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EventFluent.this.withRelated(this.builder.build());
        }

        public N endRelated() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EventFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class InvolvedObjectNested<N>
    extends ObjectReferenceFluent<InvolvedObjectNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        InvolvedObjectNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EventFluent.this.withInvolvedObject(this.builder.build());
        }

        public N endInvolvedObject() {
            return this.and();
        }
    }

    public class EventTimeNested<N>
    extends MicroTimeFluent<EventTimeNested<N>>
    implements Nested<N> {
        MicroTimeBuilder builder;

        EventTimeNested(MicroTime item) {
            this.builder = new MicroTimeBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EventFluent.this.withEventTime(this.builder.build());
        }

        public N endEventTime() {
            return this.and();
        }
    }
}

