/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_9;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.kubernetes.api.model.v6_9.DownwardAPIVolumeFile;
import io.fabric8.kubernetes.api.model.v6_9.DownwardAPIVolumeFileBuilder;
import io.fabric8.kubernetes.api.model.v6_9.DownwardAPIVolumeFileFluent;
import io.fabric8.kubernetes.api.model.v6_9.DownwardAPIVolumeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DownwardAPIVolumeSourceFluent<A extends DownwardAPIVolumeSourceFluent<A>>
extends BaseFluent<A> {
    private Integer defaultMode;
    private ArrayList<DownwardAPIVolumeFileBuilder> items = new ArrayList();
    private Map<String, Object> additionalProperties;

    public DownwardAPIVolumeSourceFluent() {
    }

    public DownwardAPIVolumeSourceFluent(DownwardAPIVolumeSource instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DownwardAPIVolumeSource instance) {
        DownwardAPIVolumeSource downwardAPIVolumeSource = instance = instance != null ? instance : new DownwardAPIVolumeSource();
        if (instance != null) {
            this.withDefaultMode(instance.getDefaultMode());
            this.withItems(instance.getItems());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getDefaultMode() {
        return this.defaultMode;
    }

    public A withDefaultMode(Integer defaultMode) {
        this.defaultMode = defaultMode;
        return (A)this;
    }

    public boolean hasDefaultMode() {
        return this.defaultMode != null;
    }

    public A addToItems(int index, DownwardAPIVolumeFile item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        DownwardAPIVolumeFileBuilder builder = new DownwardAPIVolumeFileBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get("items").add(index, builder);
            this.items.add(index, builder);
        }
        return (A)this;
    }

    public A setToItems(int index, DownwardAPIVolumeFile item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        DownwardAPIVolumeFileBuilder builder = new DownwardAPIVolumeFileBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get("items").set(index, builder);
            this.items.set(index, builder);
        }
        return (A)this;
    }

    public A addToItems(DownwardAPIVolumeFile ... items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (DownwardAPIVolumeFile item : items) {
            DownwardAPIVolumeFileBuilder builder = new DownwardAPIVolumeFileBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    public A addAllToItems(Collection<DownwardAPIVolumeFile> items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (DownwardAPIVolumeFile item : items) {
            DownwardAPIVolumeFileBuilder builder = new DownwardAPIVolumeFileBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    public A removeFromItems(DownwardAPIVolumeFile ... items) {
        if (this.items == null) {
            return (A)this;
        }
        for (DownwardAPIVolumeFile item : items) {
            DownwardAPIVolumeFileBuilder builder = new DownwardAPIVolumeFileBuilder(item);
            this._visitables.get("items").remove(builder);
            this.items.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromItems(Collection<DownwardAPIVolumeFile> items) {
        if (this.items == null) {
            return (A)this;
        }
        for (DownwardAPIVolumeFile item : items) {
            DownwardAPIVolumeFileBuilder builder = new DownwardAPIVolumeFileBuilder(item);
            this._visitables.get("items").remove(builder);
            this.items.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromItems(Predicate<DownwardAPIVolumeFileBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<DownwardAPIVolumeFileBuilder> each = this.items.iterator();
        Object visitables = this._visitables.get("items");
        while (each.hasNext()) {
            DownwardAPIVolumeFileBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<DownwardAPIVolumeFile> buildItems() {
        return this.items != null ? DownwardAPIVolumeSourceFluent.build(this.items) : null;
    }

    public DownwardAPIVolumeFile buildItem(int index) {
        return this.items.get(index).build();
    }

    public DownwardAPIVolumeFile buildFirstItem() {
        return this.items.get(0).build();
    }

    public DownwardAPIVolumeFile buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    public DownwardAPIVolumeFile buildMatchingItem(Predicate<DownwardAPIVolumeFileBuilder> predicate) {
        for (DownwardAPIVolumeFileBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingItem(Predicate<DownwardAPIVolumeFileBuilder> predicate) {
        for (DownwardAPIVolumeFileBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withItems(List<DownwardAPIVolumeFile> items) {
        if (this.items != null) {
            this._visitables.get("items").clear();
        }
        if (items != null) {
            this.items = new ArrayList();
            for (DownwardAPIVolumeFile item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    public A withItems(DownwardAPIVolumeFile ... items) {
        if (this.items != null) {
            this.items.clear();
            this._visitables.remove("items");
        }
        if (items != null) {
            for (DownwardAPIVolumeFile item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    public boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    public ItemsNested<A> addNewItem() {
        return new ItemsNested(-1, null);
    }

    public ItemsNested<A> addNewItemLike(DownwardAPIVolumeFile item) {
        return new ItemsNested(-1, item);
    }

    public ItemsNested<A> setNewItemLike(int index, DownwardAPIVolumeFile item) {
        return new ItemsNested(index, item);
    }

    public ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    public ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public ItemsNested<A> editMatchingItem(Predicate<DownwardAPIVolumeFileBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DownwardAPIVolumeSourceFluent that = (DownwardAPIVolumeSourceFluent)o;
        if (!Objects.equals(this.defaultMode, that.defaultMode)) {
            return false;
        }
        if (!Objects.equals(this.items, that.items)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.defaultMode, this.items, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.defaultMode != null) {
            sb.append("defaultMode:");
            sb.append(this.defaultMode + ",");
        }
        if (this.items != null && !this.items.isEmpty()) {
            sb.append("items:");
            sb.append(this.items + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ItemsNested<N>
    extends DownwardAPIVolumeFileFluent<ItemsNested<N>>
    implements Nested<N> {
        DownwardAPIVolumeFileBuilder builder;
        int index;

        ItemsNested(int index, DownwardAPIVolumeFile item) {
            this.index = index;
            this.builder = new DownwardAPIVolumeFileBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DownwardAPIVolumeSourceFluent.this.setToItems(this.index, this.builder.build());
        }

        public N endItem() {
            return this.and();
        }
    }
}

