/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_9;

import io.fabric8.kubernetes.api.builder.v6_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_9.Nested;
import io.fabric8.kubernetes.api.model.v6_9.CSIPersistentVolumeSource;
import io.fabric8.kubernetes.api.model.v6_9.SecretReference;
import io.fabric8.kubernetes.api.model.v6_9.SecretReferenceBuilder;
import io.fabric8.kubernetes.api.model.v6_9.SecretReferenceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CSIPersistentVolumeSourceFluent<A extends CSIPersistentVolumeSourceFluent<A>>
extends BaseFluent<A> {
    private SecretReferenceBuilder controllerExpandSecretRef;
    private SecretReferenceBuilder controllerPublishSecretRef;
    private String driver;
    private String fsType;
    private SecretReferenceBuilder nodeExpandSecretRef;
    private SecretReferenceBuilder nodePublishSecretRef;
    private SecretReferenceBuilder nodeStageSecretRef;
    private Boolean readOnly;
    private Map<String, String> volumeAttributes;
    private String volumeHandle;
    private Map<String, Object> additionalProperties;

    public CSIPersistentVolumeSourceFluent() {
    }

    public CSIPersistentVolumeSourceFluent(CSIPersistentVolumeSource instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CSIPersistentVolumeSource instance) {
        CSIPersistentVolumeSource cSIPersistentVolumeSource = instance = instance != null ? instance : new CSIPersistentVolumeSource();
        if (instance != null) {
            this.withControllerExpandSecretRef(instance.getControllerExpandSecretRef());
            this.withControllerPublishSecretRef(instance.getControllerPublishSecretRef());
            this.withDriver(instance.getDriver());
            this.withFsType(instance.getFsType());
            this.withNodeExpandSecretRef(instance.getNodeExpandSecretRef());
            this.withNodePublishSecretRef(instance.getNodePublishSecretRef());
            this.withNodeStageSecretRef(instance.getNodeStageSecretRef());
            this.withReadOnly(instance.getReadOnly());
            this.withVolumeAttributes(instance.getVolumeAttributes());
            this.withVolumeHandle(instance.getVolumeHandle());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public SecretReference buildControllerExpandSecretRef() {
        return this.controllerExpandSecretRef != null ? this.controllerExpandSecretRef.build() : null;
    }

    public A withControllerExpandSecretRef(SecretReference controllerExpandSecretRef) {
        this._visitables.remove("controllerExpandSecretRef");
        if (controllerExpandSecretRef != null) {
            this.controllerExpandSecretRef = new SecretReferenceBuilder(controllerExpandSecretRef);
            this._visitables.get("controllerExpandSecretRef").add(this.controllerExpandSecretRef);
        } else {
            this.controllerExpandSecretRef = null;
            this._visitables.get("controllerExpandSecretRef").remove(this.controllerExpandSecretRef);
        }
        return (A)this;
    }

    public boolean hasControllerExpandSecretRef() {
        return this.controllerExpandSecretRef != null;
    }

    public A withNewControllerExpandSecretRef(String name, String namespace) {
        return this.withControllerExpandSecretRef(new SecretReference(name, namespace));
    }

    public ControllerExpandSecretRefNested<A> withNewControllerExpandSecretRef() {
        return new ControllerExpandSecretRefNested(null);
    }

    public ControllerExpandSecretRefNested<A> withNewControllerExpandSecretRefLike(SecretReference item) {
        return new ControllerExpandSecretRefNested(item);
    }

    public ControllerExpandSecretRefNested<A> editControllerExpandSecretRef() {
        return this.withNewControllerExpandSecretRefLike(Optional.ofNullable(this.buildControllerExpandSecretRef()).orElse(null));
    }

    public ControllerExpandSecretRefNested<A> editOrNewControllerExpandSecretRef() {
        return this.withNewControllerExpandSecretRefLike(Optional.ofNullable(this.buildControllerExpandSecretRef()).orElse(new SecretReferenceBuilder().build()));
    }

    public ControllerExpandSecretRefNested<A> editOrNewControllerExpandSecretRefLike(SecretReference item) {
        return this.withNewControllerExpandSecretRefLike(Optional.ofNullable(this.buildControllerExpandSecretRef()).orElse(item));
    }

    public SecretReference buildControllerPublishSecretRef() {
        return this.controllerPublishSecretRef != null ? this.controllerPublishSecretRef.build() : null;
    }

    public A withControllerPublishSecretRef(SecretReference controllerPublishSecretRef) {
        this._visitables.remove("controllerPublishSecretRef");
        if (controllerPublishSecretRef != null) {
            this.controllerPublishSecretRef = new SecretReferenceBuilder(controllerPublishSecretRef);
            this._visitables.get("controllerPublishSecretRef").add(this.controllerPublishSecretRef);
        } else {
            this.controllerPublishSecretRef = null;
            this._visitables.get("controllerPublishSecretRef").remove(this.controllerPublishSecretRef);
        }
        return (A)this;
    }

    public boolean hasControllerPublishSecretRef() {
        return this.controllerPublishSecretRef != null;
    }

    public A withNewControllerPublishSecretRef(String name, String namespace) {
        return this.withControllerPublishSecretRef(new SecretReference(name, namespace));
    }

    public ControllerPublishSecretRefNested<A> withNewControllerPublishSecretRef() {
        return new ControllerPublishSecretRefNested(null);
    }

    public ControllerPublishSecretRefNested<A> withNewControllerPublishSecretRefLike(SecretReference item) {
        return new ControllerPublishSecretRefNested(item);
    }

    public ControllerPublishSecretRefNested<A> editControllerPublishSecretRef() {
        return this.withNewControllerPublishSecretRefLike(Optional.ofNullable(this.buildControllerPublishSecretRef()).orElse(null));
    }

    public ControllerPublishSecretRefNested<A> editOrNewControllerPublishSecretRef() {
        return this.withNewControllerPublishSecretRefLike(Optional.ofNullable(this.buildControllerPublishSecretRef()).orElse(new SecretReferenceBuilder().build()));
    }

    public ControllerPublishSecretRefNested<A> editOrNewControllerPublishSecretRefLike(SecretReference item) {
        return this.withNewControllerPublishSecretRefLike(Optional.ofNullable(this.buildControllerPublishSecretRef()).orElse(item));
    }

    public String getDriver() {
        return this.driver;
    }

    public A withDriver(String driver) {
        this.driver = driver;
        return (A)this;
    }

    public boolean hasDriver() {
        return this.driver != null;
    }

    public String getFsType() {
        return this.fsType;
    }

    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    public boolean hasFsType() {
        return this.fsType != null;
    }

    public SecretReference buildNodeExpandSecretRef() {
        return this.nodeExpandSecretRef != null ? this.nodeExpandSecretRef.build() : null;
    }

    public A withNodeExpandSecretRef(SecretReference nodeExpandSecretRef) {
        this._visitables.remove("nodeExpandSecretRef");
        if (nodeExpandSecretRef != null) {
            this.nodeExpandSecretRef = new SecretReferenceBuilder(nodeExpandSecretRef);
            this._visitables.get("nodeExpandSecretRef").add(this.nodeExpandSecretRef);
        } else {
            this.nodeExpandSecretRef = null;
            this._visitables.get("nodeExpandSecretRef").remove(this.nodeExpandSecretRef);
        }
        return (A)this;
    }

    public boolean hasNodeExpandSecretRef() {
        return this.nodeExpandSecretRef != null;
    }

    public A withNewNodeExpandSecretRef(String name, String namespace) {
        return this.withNodeExpandSecretRef(new SecretReference(name, namespace));
    }

    public NodeExpandSecretRefNested<A> withNewNodeExpandSecretRef() {
        return new NodeExpandSecretRefNested(null);
    }

    public NodeExpandSecretRefNested<A> withNewNodeExpandSecretRefLike(SecretReference item) {
        return new NodeExpandSecretRefNested(item);
    }

    public NodeExpandSecretRefNested<A> editNodeExpandSecretRef() {
        return this.withNewNodeExpandSecretRefLike(Optional.ofNullable(this.buildNodeExpandSecretRef()).orElse(null));
    }

    public NodeExpandSecretRefNested<A> editOrNewNodeExpandSecretRef() {
        return this.withNewNodeExpandSecretRefLike(Optional.ofNullable(this.buildNodeExpandSecretRef()).orElse(new SecretReferenceBuilder().build()));
    }

    public NodeExpandSecretRefNested<A> editOrNewNodeExpandSecretRefLike(SecretReference item) {
        return this.withNewNodeExpandSecretRefLike(Optional.ofNullable(this.buildNodeExpandSecretRef()).orElse(item));
    }

    public SecretReference buildNodePublishSecretRef() {
        return this.nodePublishSecretRef != null ? this.nodePublishSecretRef.build() : null;
    }

    public A withNodePublishSecretRef(SecretReference nodePublishSecretRef) {
        this._visitables.remove("nodePublishSecretRef");
        if (nodePublishSecretRef != null) {
            this.nodePublishSecretRef = new SecretReferenceBuilder(nodePublishSecretRef);
            this._visitables.get("nodePublishSecretRef").add(this.nodePublishSecretRef);
        } else {
            this.nodePublishSecretRef = null;
            this._visitables.get("nodePublishSecretRef").remove(this.nodePublishSecretRef);
        }
        return (A)this;
    }

    public boolean hasNodePublishSecretRef() {
        return this.nodePublishSecretRef != null;
    }

    public A withNewNodePublishSecretRef(String name, String namespace) {
        return this.withNodePublishSecretRef(new SecretReference(name, namespace));
    }

    public NodePublishSecretRefNested<A> withNewNodePublishSecretRef() {
        return new NodePublishSecretRefNested(null);
    }

    public NodePublishSecretRefNested<A> withNewNodePublishSecretRefLike(SecretReference item) {
        return new NodePublishSecretRefNested(item);
    }

    public NodePublishSecretRefNested<A> editNodePublishSecretRef() {
        return this.withNewNodePublishSecretRefLike(Optional.ofNullable(this.buildNodePublishSecretRef()).orElse(null));
    }

    public NodePublishSecretRefNested<A> editOrNewNodePublishSecretRef() {
        return this.withNewNodePublishSecretRefLike(Optional.ofNullable(this.buildNodePublishSecretRef()).orElse(new SecretReferenceBuilder().build()));
    }

    public NodePublishSecretRefNested<A> editOrNewNodePublishSecretRefLike(SecretReference item) {
        return this.withNewNodePublishSecretRefLike(Optional.ofNullable(this.buildNodePublishSecretRef()).orElse(item));
    }

    public SecretReference buildNodeStageSecretRef() {
        return this.nodeStageSecretRef != null ? this.nodeStageSecretRef.build() : null;
    }

    public A withNodeStageSecretRef(SecretReference nodeStageSecretRef) {
        this._visitables.remove("nodeStageSecretRef");
        if (nodeStageSecretRef != null) {
            this.nodeStageSecretRef = new SecretReferenceBuilder(nodeStageSecretRef);
            this._visitables.get("nodeStageSecretRef").add(this.nodeStageSecretRef);
        } else {
            this.nodeStageSecretRef = null;
            this._visitables.get("nodeStageSecretRef").remove(this.nodeStageSecretRef);
        }
        return (A)this;
    }

    public boolean hasNodeStageSecretRef() {
        return this.nodeStageSecretRef != null;
    }

    public A withNewNodeStageSecretRef(String name, String namespace) {
        return this.withNodeStageSecretRef(new SecretReference(name, namespace));
    }

    public NodeStageSecretRefNested<A> withNewNodeStageSecretRef() {
        return new NodeStageSecretRefNested(null);
    }

    public NodeStageSecretRefNested<A> withNewNodeStageSecretRefLike(SecretReference item) {
        return new NodeStageSecretRefNested(item);
    }

    public NodeStageSecretRefNested<A> editNodeStageSecretRef() {
        return this.withNewNodeStageSecretRefLike(Optional.ofNullable(this.buildNodeStageSecretRef()).orElse(null));
    }

    public NodeStageSecretRefNested<A> editOrNewNodeStageSecretRef() {
        return this.withNewNodeStageSecretRefLike(Optional.ofNullable(this.buildNodeStageSecretRef()).orElse(new SecretReferenceBuilder().build()));
    }

    public NodeStageSecretRefNested<A> editOrNewNodeStageSecretRefLike(SecretReference item) {
        return this.withNewNodeStageSecretRefLike(Optional.ofNullable(this.buildNodeStageSecretRef()).orElse(item));
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    public boolean hasReadOnly() {
        return this.readOnly != null;
    }

    public A addToVolumeAttributes(String key, String value) {
        if (this.volumeAttributes == null && key != null && value != null) {
            this.volumeAttributes = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.volumeAttributes.put(key, value);
        }
        return (A)this;
    }

    public A addToVolumeAttributes(Map<String, String> map) {
        if (this.volumeAttributes == null && map != null) {
            this.volumeAttributes = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.volumeAttributes.putAll(map);
        }
        return (A)this;
    }

    public A removeFromVolumeAttributes(String key) {
        if (this.volumeAttributes == null) {
            return (A)this;
        }
        if (key != null && this.volumeAttributes != null) {
            this.volumeAttributes.remove(key);
        }
        return (A)this;
    }

    public A removeFromVolumeAttributes(Map<String, String> map) {
        if (this.volumeAttributes == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.volumeAttributes == null) continue;
                this.volumeAttributes.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getVolumeAttributes() {
        return this.volumeAttributes;
    }

    public <K, V> A withVolumeAttributes(Map<String, String> volumeAttributes) {
        this.volumeAttributes = volumeAttributes == null ? null : new LinkedHashMap<String, String>(volumeAttributes);
        return (A)this;
    }

    public boolean hasVolumeAttributes() {
        return this.volumeAttributes != null;
    }

    public String getVolumeHandle() {
        return this.volumeHandle;
    }

    public A withVolumeHandle(String volumeHandle) {
        this.volumeHandle = volumeHandle;
        return (A)this;
    }

    public boolean hasVolumeHandle() {
        return this.volumeHandle != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CSIPersistentVolumeSourceFluent that = (CSIPersistentVolumeSourceFluent)o;
        if (!Objects.equals(this.controllerExpandSecretRef, that.controllerExpandSecretRef)) {
            return false;
        }
        if (!Objects.equals(this.controllerPublishSecretRef, that.controllerPublishSecretRef)) {
            return false;
        }
        if (!Objects.equals(this.driver, that.driver)) {
            return false;
        }
        if (!Objects.equals(this.fsType, that.fsType)) {
            return false;
        }
        if (!Objects.equals(this.nodeExpandSecretRef, that.nodeExpandSecretRef)) {
            return false;
        }
        if (!Objects.equals(this.nodePublishSecretRef, that.nodePublishSecretRef)) {
            return false;
        }
        if (!Objects.equals(this.nodeStageSecretRef, that.nodeStageSecretRef)) {
            return false;
        }
        if (!Objects.equals(this.readOnly, that.readOnly)) {
            return false;
        }
        if (!Objects.equals(this.volumeAttributes, that.volumeAttributes)) {
            return false;
        }
        if (!Objects.equals(this.volumeHandle, that.volumeHandle)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.controllerExpandSecretRef, this.controllerPublishSecretRef, this.driver, this.fsType, this.nodeExpandSecretRef, this.nodePublishSecretRef, this.nodeStageSecretRef, this.readOnly, this.volumeAttributes, this.volumeHandle, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.controllerExpandSecretRef != null) {
            sb.append("controllerExpandSecretRef:");
            sb.append(this.controllerExpandSecretRef + ",");
        }
        if (this.controllerPublishSecretRef != null) {
            sb.append("controllerPublishSecretRef:");
            sb.append(this.controllerPublishSecretRef + ",");
        }
        if (this.driver != null) {
            sb.append("driver:");
            sb.append(this.driver + ",");
        }
        if (this.fsType != null) {
            sb.append("fsType:");
            sb.append(this.fsType + ",");
        }
        if (this.nodeExpandSecretRef != null) {
            sb.append("nodeExpandSecretRef:");
            sb.append(this.nodeExpandSecretRef + ",");
        }
        if (this.nodePublishSecretRef != null) {
            sb.append("nodePublishSecretRef:");
            sb.append(this.nodePublishSecretRef + ",");
        }
        if (this.nodeStageSecretRef != null) {
            sb.append("nodeStageSecretRef:");
            sb.append(this.nodeStageSecretRef + ",");
        }
        if (this.readOnly != null) {
            sb.append("readOnly:");
            sb.append(this.readOnly + ",");
        }
        if (this.volumeAttributes != null && !this.volumeAttributes.isEmpty()) {
            sb.append("volumeAttributes:");
            sb.append(this.volumeAttributes + ",");
        }
        if (this.volumeHandle != null) {
            sb.append("volumeHandle:");
            sb.append(this.volumeHandle + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withReadOnly() {
        return this.withReadOnly(true);
    }

    public class NodeStageSecretRefNested<N>
    extends SecretReferenceFluent<NodeStageSecretRefNested<N>>
    implements Nested<N> {
        SecretReferenceBuilder builder;

        NodeStageSecretRefNested(SecretReference item) {
            this.builder = new SecretReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CSIPersistentVolumeSourceFluent.this.withNodeStageSecretRef(this.builder.build());
        }

        public N endNodeStageSecretRef() {
            return this.and();
        }
    }

    public class NodePublishSecretRefNested<N>
    extends SecretReferenceFluent<NodePublishSecretRefNested<N>>
    implements Nested<N> {
        SecretReferenceBuilder builder;

        NodePublishSecretRefNested(SecretReference item) {
            this.builder = new SecretReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CSIPersistentVolumeSourceFluent.this.withNodePublishSecretRef(this.builder.build());
        }

        public N endNodePublishSecretRef() {
            return this.and();
        }
    }

    public class NodeExpandSecretRefNested<N>
    extends SecretReferenceFluent<NodeExpandSecretRefNested<N>>
    implements Nested<N> {
        SecretReferenceBuilder builder;

        NodeExpandSecretRefNested(SecretReference item) {
            this.builder = new SecretReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CSIPersistentVolumeSourceFluent.this.withNodeExpandSecretRef(this.builder.build());
        }

        public N endNodeExpandSecretRef() {
            return this.and();
        }
    }

    public class ControllerPublishSecretRefNested<N>
    extends SecretReferenceFluent<ControllerPublishSecretRefNested<N>>
    implements Nested<N> {
        SecretReferenceBuilder builder;

        ControllerPublishSecretRefNested(SecretReference item) {
            this.builder = new SecretReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CSIPersistentVolumeSourceFluent.this.withControllerPublishSecretRef(this.builder.build());
        }

        public N endControllerPublishSecretRef() {
            return this.and();
        }
    }

    public class ControllerExpandSecretRefNested<N>
    extends SecretReferenceFluent<ControllerExpandSecretRefNested<N>>
    implements Nested<N> {
        SecretReferenceBuilder builder;

        ControllerExpandSecretRefNested(SecretReference item) {
            this.builder = new SecretReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CSIPersistentVolumeSourceFluent.this.withControllerExpandSecretRef(this.builder.build());
        }

        public N endControllerExpandSecretRef() {
            return this.and();
        }
    }
}

