/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.tuned.v1.OperandConfig;
import io.fabric8.openshift.api.model.tuned.v1.TuneDConfig;
import io.fabric8.openshift.api.model.tuned.v1.TuneDConfigBuilder;
import io.fabric8.openshift.api.model.tuned.v1.TuneDConfigFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class OperandConfigFluent<A extends OperandConfigFluent<A>>
extends BaseFluent<A> {
    private Boolean debug;
    private TuneDConfigBuilder tunedConfig;
    private Map<String, Object> additionalProperties;

    public OperandConfigFluent() {
    }

    public OperandConfigFluent(OperandConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(OperandConfig instance) {
        OperandConfig operandConfig = instance = instance != null ? instance : new OperandConfig();
        if (instance != null) {
            this.withDebug(instance.getDebug());
            this.withTunedConfig(instance.getTunedConfig());
            this.withDebug(instance.getDebug());
            this.withTunedConfig(instance.getTunedConfig());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Boolean getDebug() {
        return this.debug;
    }

    public A withDebug(Boolean debug) {
        this.debug = debug;
        return (A)this;
    }

    public boolean hasDebug() {
        return this.debug != null;
    }

    public TuneDConfig buildTunedConfig() {
        return this.tunedConfig != null ? this.tunedConfig.build() : null;
    }

    public A withTunedConfig(TuneDConfig tunedConfig) {
        this._visitables.remove(this.tunedConfig);
        if (tunedConfig != null) {
            this.tunedConfig = new TuneDConfigBuilder(tunedConfig);
            this._visitables.get("tunedConfig").add(this.tunedConfig);
        } else {
            this.tunedConfig = null;
            this._visitables.get("tunedConfig").remove(this.tunedConfig);
        }
        return (A)this;
    }

    public boolean hasTunedConfig() {
        return this.tunedConfig != null;
    }

    public A withNewTunedConfig(Boolean reapplySysctl) {
        return this.withTunedConfig(new TuneDConfig(reapplySysctl));
    }

    public TunedConfigNested<A> withNewTunedConfig() {
        return new TunedConfigNested(null);
    }

    public TunedConfigNested<A> withNewTunedConfigLike(TuneDConfig item) {
        return new TunedConfigNested(item);
    }

    public TunedConfigNested<A> editTunedConfig() {
        return this.withNewTunedConfigLike(Optional.ofNullable(this.buildTunedConfig()).orElse(null));
    }

    public TunedConfigNested<A> editOrNewTunedConfig() {
        return this.withNewTunedConfigLike(Optional.ofNullable(this.buildTunedConfig()).orElse(new TuneDConfigBuilder().build()));
    }

    public TunedConfigNested<A> editOrNewTunedConfigLike(TuneDConfig item) {
        return this.withNewTunedConfigLike(Optional.ofNullable(this.buildTunedConfig()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OperandConfigFluent that = (OperandConfigFluent)o;
        if (!Objects.equals(this.debug, that.debug)) {
            return false;
        }
        if (!Objects.equals(this.tunedConfig, that.tunedConfig)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.debug, this.tunedConfig, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.debug != null) {
            sb.append("debug:");
            sb.append(this.debug + ",");
        }
        if (this.tunedConfig != null) {
            sb.append("tunedConfig:");
            sb.append(this.tunedConfig + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withDebug() {
        return this.withDebug(true);
    }

    public class TunedConfigNested<N>
    extends TuneDConfigFluent<TunedConfigNested<N>>
    implements Nested<N> {
        TuneDConfigBuilder builder;

        TunedConfigNested(TuneDConfig item) {
            this.builder = new TuneDConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)OperandConfigFluent.this.withTunedConfig(this.builder.build());
        }

        public N endTunedConfig() {
            return this.and();
        }
    }
}

